﻿using com.sun.org.glassfish.external.statistics;
using java.lang;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using NPoco;
using QueryPlatform.Api.Infrastructure.Hubs;
using QueryPlatform.Api.Infrastructure.Modules;
using QueryPlatform.Api.Infrastructure.Queries;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Controllers
{
    [Authorize]
    [Route("api/resource")]
    [ApiController]
    public class HomeController : Controller
    {
        private readonly HomeQueries _homeQueries;
        private static System.Diagnostics.Process process;
        private readonly IWebHostEnvironment _environment;
        private readonly IHubContext<NotificationHub> _hubContext;
        private readonly DirectoryTree _directoryTree;
        public HomeController(HomeQueries homeQueries, IWebHostEnvironment environment, IHubContext<NotificationHub> hubContext, DirectoryTree directoryTree)
        {
            _homeQueries = homeQueries;
            _environment = environment;
            _hubContext = hubContext;
            _directoryTree = directoryTree;
        }
        /// <summary>
        /// 查询所有项目记录
        /// </summary>
        /// <returns></returns>
		[HttpGet("DemamdQuery")]
        [AllowAnonymous]
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) DemamdQuery(long paseIndex, string Demand_Name)
        {
            return _homeQueries.DemandQuery(paseIndex == 0 ? 1 : paseIndex, Demand_Name);
        }

        [HttpGet("ceshi")]
        [AllowAnonymous]
        public List<string> ceshi(string title, string content, string zxr = "")
        {
            return _homeQueries.ceshi();
        }
        /// <summary>
        /// 查询子表的记录
        /// </summary>
        /// <returns></returns>
        [HttpGet("DemamdQuery_")]
        [AllowAnonymous]
        public IEnumerable<dynamic> DemamdQuery_(int id)
        {
            var DemandQuery = _homeQueries.DemandQueryfu(id);
            return DemandQuery;
        }
        /// <summary>
        /// 添加需求记录
        /// </summary>
        /// <param name="sYS_Demand"></param>
        [HttpPost("DemandAdd")]
        [AllowAnonymous]
        public void DemandAdd([FromBody] SYS_DEMAND sYS_Demand)
        {
            _homeQueries.Demand(sYS_Demand);

        }
        /// <summary>
        /// 添加子表数据
        /// </summary>
        /// <param name="sYS_DemandSublist"></param>
        [HttpPost("DemandAddfu")]
        [AllowAnonymous]
        public void DemandAddfu([FromForm] SYS_DEMANDSUBLIS sYS_DemandSublist)
        {
            _homeQueries.Demandfu(sYS_DemandSublist, _environment.WebRootPath);
        }
        /// <summary>
        /// 添加服务器
        /// </summary>
        /// <param name="servers"></param>
        [HttpPost("ServersAdd")]
        [AllowAnonymous]
        public void ServersAdd(服务器 servers)
        {
            if (!string.IsNullOrEmpty(servers.服务器ip) && !string.IsNullOrEmpty(servers.数据库账号) && !string.IsNullOrEmpty(servers.数据库密码))
            {
                _homeQueries.ServersConfiguration(servers);
            }
        }
        /// <summary>
        /// 展示服务器
        /// </summary> 
        [HttpPost("ServersShow")]
        [AllowAnonymous]
        public IEnumerable<dynamic> ServersShow()
        {
            return _homeQueries.ServersShow();
        }
        /// <summary>
        /// 存储函数
        /// </summary>
        [HttpPost("Funcadd")]
        [AllowAnonymous]
        public void Funcadd([FromBody] COMMONLYUSED commonly)
        {
            if (!string.IsNullOrEmpty(commonly.Name) && !string.IsNullOrEmpty(commonly.value))
            {
                _homeQueries.FuncaConfiguration(commonly);
            }

        }
        /// <summary>
        /// 存储函数展示
        /// </summary>
        /// <returns></returns>
        [HttpGet("Funca")]
        [AllowAnonymous]
        public IEnumerable<dynamic> Funca()
        {
            var DemandQuery = _homeQueries.FuncaQuery();
            return DemandQuery;
        }

        //[HttpGet("lingchuanglujingjiancha")]
        //[AllowAnonymous]
        //public IEnumerable<dynamic> lingchuanglujingjiancha(string name)
        //{
        //    var DemandQuery = _homeQueries.lingchuanglujingjiancha(name);
        //    return DemandQuery;
        //}
        /// <summary>
        /// 查询记录导出
        /// </summary>
        /// <returns></returns>
        [HttpGet("Executes")]
        [AllowAnonymous]
        public string Executes(DateTime StartTime, DateTime EndTime)
        {
            return _homeQueries.Executes(StartTime, EndTime, _environment.WebRootPath);
        }
        /// <summary>
        /// 南海核对数据下拉框
        /// </summary>
        /// <returns></returns>
        [HttpPost("YiYuanShow")]
        [AllowAnonymous]
        public List<SYS_YIYUAN> YiYuanShow()
        {
            List<SYS_YIYUAN> yy = new List<SYS_YIYUAN>();
            yy.Add(new SYS_YIYUAN { hosid = 42, hosname = "广东省佛山市南海区人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 43, hosname = "广东省中西医结合医院" });
            yy.Add(new SYS_YIYUAN { hosid = 44, hosname = "广东省佛山市南海区中医院沙头分院" });
            yy.Add(new SYS_YIYUAN { hosid = 45, hosname = "广东省佛山市南海区妇幼保健院" });
            yy.Add(new SYS_YIYUAN { hosid = 46, hosname = "广东省人民医院南海医院" });
            yy.Add(new SYS_YIYUAN { hosid = 48, hosname = "广东省佛山市南海区第四人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 49, hosname = "广东省佛山市南海区第五人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 50, hosname = "广东省佛山市南海区第六人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 52, hosname = "广东省佛山市南海区第八人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 53, hosname = "广东省佛山市南海区第九人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 58, hosname = "广东省佛山市南海区公共卫生医院" });
            yy.Add(new SYS_YIYUAN { hosid = 61, hosname = "广东省佛山市南海经济开发区人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 92, hosname = "广东省佛山市南海区第七人民医院" });
            yy.Add(new SYS_YIYUAN { hosid = 105, hosname = "广东省佛山市南海区桂城医院" });
            yy.Add(new SYS_YIYUAN { hosid = 106, hosname = "南方医科大学第七附属医院" });
            return yy;
        }
        /// <summary>
        /// 单家医院核对数据
        /// </summary>
        /// <returns></returns>
        [HttpPost("YiYuanHeDui")]
        [AllowAnonymous]
        public IEnumerable<dynamic> YiYuanHeDui(long hos_id, string year)
        {
            return _homeQueries.YiYuanHeDui(hos_id, year);
        }
        /// <summary>
        /// 数据抽取登记展示列表
        /// </summary>
        /// <returns></returns>
        [HttpGet("ExtractQuery")]
        [AllowAnonymous]
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) ExtractQuery(long paseIndex)
        {
            return _homeQueries.ExtractShou(paseIndex == 0 ? 1 : paseIndex);
        }
        /// <summary>
        /// 数据抽取登记新增数据
        /// </summary>
        /// <returns></returns>
        [HttpPost("AddExtract")]
        [AllowAnonymous]
        public void AddExtract(SYS_EXTRACT sYS_Extract)
        {
            _homeQueries.Add(sYS_Extract);
        }
        /// <summary>
        /// 数据抽取登记修改
        /// </summary>
        /// <param name=""></param>
        /// <param name="dataExtract"></param>
        /// <returns></returns>
        [HttpPost("Update")]
        [AllowAnonymous]
        public IActionResult Update(DATAEXTRACT dataExtract)
        {
            _homeQueries.Update(dataExtract);
            return Ok();
        }

        //网站拉取json
        [HttpPost("Ybyp")]
        [AllowAnonymous]
        public async Task<IActionResult> Ybyp(int dqy, int zys)
        {
            for (long i = dqy; i <= zys; i++)
            {
                var client = new HttpClient();
                var request = new HttpRequestMessage
                {
                    Method = HttpMethod.Post,
                    RequestUri = new Uri("https://code.nhsa.gov.cn/yp/getPublishGoodsDataInfo.html?companyNameSc=&registeredProductName=&approvalCode=&batchNumber=20220920&_search=false&nd=1663825733775&rows=100&page=" + i + "&sidx=&sord=asc"),
                    Content = new StringContent("{\r\n\"companyNameSc\":null,\r\n\"registeredProductName\": null,\r\n\"approvalCode\": null,\r\n\"batchNumber\": \"20220920\",\r\n\"_search\": false,\r\n\"nd\": \"1663825733775\",\r\n\"rows\": 100,\r\n\"page\": " + i + ",\r\n\"sidx\":null,\r\n\"sord\": \"asc\",\r\n}")
                    {
                        Headers = { ContentType = new MediaTypeHeaderValue("text/plain") }
                    }
                };
                using (var response = await client.SendAsync(request))
                {
                    response.EnsureSuccessStatusCode();
                    var body = await response.Content.ReadAsStringAsync();
                    _homeQueries.Ybyp(body, i);

                }


            }
            return Ok();
        }
        /// <summary>
        /// 邮箱推送
        /// </summary>
        /// <param name="title">邮箱标题</param>
        /// <param name="content">内容</param>
        /// <param name="zxr">推送人</param>
        /// <returns></returns>
        [HttpPost("SendMail")]
        [AllowAnonymous]
        public IActionResult SendMail(string title, string content, string zxr = "")
        {
            _homeQueries.SendMail(title, content, zxr);
            return Ok();
        }
        #region 导出病人数据
        private static SemaphoreSlim semaphore = new SemaphoreSlim(1, 1);
        [HttpGet("DownloadOrders")]
        [AllowAnonymous]
        public async Task<string> DownloadOrdersAsync(string ExportTableName)
        {
            await semaphore.WaitAsync();
            var export = "";
            try
            {
                export = _homeQueries.Excelex(ExportTableName, _environment.WebRootPath); ;
            }
            catch (System.Exception e)
            {

                export = e.ToString();
            }
            finally
            {
                semaphore.Release();
            }

            return export;


        }
        #endregion 
        #region 导入病人数据 
        [HttpPost("ExcelToDataTable1")]
        [AllowAnonymous]
        public IActionResult ExcelToDataTable1(IFormFile file)
        {
            var export = _homeQueries.ExcelToDataTables(file);
            return Ok(export);
        }
        #endregion

        #region 游标数据拉取
        [HttpPost("AutomaticCursor")]
        [AllowAnonymous]
        public IActionResult AutomaticCursor()
        {

            //tis
            // _homeQueries.SendMail(title, content, zxr);
            return Ok();
        }
        #endregion

        [HttpPost("Cursor")]
        [AllowAnonymous]
        public List<string> Cursor([FromBody] CursorModel Sql)
        {
            return _homeQueries.Cursor(Sql);
        }

        [HttpGet("wjj")]
        [AllowAnonymous]
        public IActionResult GetDirectoryTree(string rootPath = "D:\\工作文档\\文档\\精细化分析平台")
        {
            try
            {
                var tree = _directoryTree.GetDirectoryTree(rootPath);
                return Ok(tree);
            }
            catch (System.Exception ex)
            {
                return StatusCode(StatusCodes.Status500InternalServerError, ex.Message);
            }
        }
    }
}