﻿using Dapper;
using HtmlAgilityPack;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using QueryPlatform.Api.Infrastructure;
//using QueryPlatform.Api.Infrastructure.Models;
using QueryPlatform.Api.Infrastructure.Modules;
using QueryPlatform.Api.Infrastructure.Queries;
using QueryPlatform.Infra;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;
using ZXing;
using ZXing.Common;
using ZXing.Rendering;

namespace QueryPlatform.Api.Controllers
{
    [Authorize]
    [Route("api/resource")]
    [ApiController]
    public class ResourceController : ControllerBase
    {
        private readonly IMemoryCache _cache;
        private readonly ResourceQueries resourceQueries;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly DrugqueryQueries drugqueryQueries;
        private readonly HomeQueries homeQueries;
        private readonly IUserIdentity _iuserIdentity;
        private readonly UserQueries _userQueries;
        public ResourceController(IMemoryCache cache, ResourceQueries resourceQueries, HomeQueries homeQueries, DrugqueryQueries drugqueryQueries, IUserIdentity iuserIdentity, UserQueries userQueries, IWebHostEnvironment webHostEnvironment)
        {

            this._cache = cache;
            this.homeQueries = homeQueries;
            this.drugqueryQueries = drugqueryQueries;
            this.resourceQueries = resourceQueries;
            this._iuserIdentity = (UserIdentity)iuserIdentity;
            this._userQueries = userQueries;
            _webHostEnvironment = webHostEnvironment;
        }
        /// <summary>
        /// 查询当月项目
        /// </summary>
        /// <returns></returns>
        [HttpGet("ItemQuery")]
        [AllowAnonymous]
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) ItemQuery(string name, long paseIndex)
        {
            return resourceQueries.ItemQuery(name, paseIndex);

        }
        /// <summary>
        /// 取消正在查询项目
        /// </summary>m
        /// <param name="id">id </param>
        /// <returns></returns>
        [HttpPost("CancelProject")]
        [AllowAnonymous]
        public bool CancelProject(int id)
        {
            bool ItemQueryList = resourceQueries.CancelProject(id);

            return ItemQueryList;
        }
        /// <summary>
        /// 查询项目报告
        /// </summary>
        /// <returns></returns>
        [HttpPost("ProjectReport")]
        [AllowAnonymous]
        public async Task<(IEnumerable<dynamic>, IEnumerable<dynamic>, string, string, IEnumerable<dynamic>, IEnumerable<dynamic>, string, IEnumerable<dynamic>)> ProjectReport([FromBody] SYS_Cs sYS_Cs)
        {
            return await resourceQueries.ProjectReport1(sYS_Cs.id, sYS_Cs.MEDIC_AREA, sYS_Cs.item_name, sYS_Cs.GENERIC_NAME, sYS_Cs.PROJECT_NAME, sYS_Cs.icd, sYS_Cs.DISEASE_NAME, _webHostEnvironment.WebRootPath, 0);
        }

        /// <summary>
        /// 下载项目报告
        /// </summary>
        /// <returns></returns>
        [HttpPost("DownloadFile")]
        [AllowAnonymous]
        public async Task<string> DownloadFileAsync([FromBody] SYS_Cs sYS_Cs)
        {
            var dz = await resourceQueries.ProjectReport1(sYS_Cs.id, sYS_Cs.MEDIC_AREA, sYS_Cs.item_name, sYS_Cs.GENERIC_NAME, sYS_Cs.PROJECT_NAME, sYS_Cs.icd, sYS_Cs.DISEASE_NAME, _webHostEnvironment.WebRootPath, 1);
            return dz.Item7;

        }
        /// <summary>
        /// 查询流水库表
        /// </summary>
        /// <returns></returns>
        [HttpPost("QueryFlowDatabase")]
        [AllowAnonymous]
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) QueryFlowDatabase(long paseIndex)
        {
            return resourceQueries.QueryFlowDatabase(paseIndex);
        }
        /// <summary>
        /// 查询药品产地
        /// </summary>
        /// <returns></returns>
        [HttpPost("ShowMEDIC_AREA")]
        [AllowAnonymous]
        public IEnumerable<dynamic> ShowMEDIC_AREA(int id)
        {
            return resourceQueries.ShowMEDIC_AREA(id);
        }
        /// <summary>
        /// 查询名称产地
        /// </summary>
        /// <returns></returns>
        [HttpPost("ShowITEM_NAME")]
        [AllowAnonymous]
        public IEnumerable<dynamic> ShowITEM_NAME(int id)
        {
            return resourceQueries.ShowITEM_NAME(id);
        }
        /// <summary>
        /// 建立流水库表
        /// </summary>
        /// <returns></returns>
        [HttpPost("EstablishFlowDatabaseTable")]
        [AllowAnonymous]
        public bool EstablishFlowDatabaseTable([FromBody] SYS_EstablishFlowDatabaseTable sYS_EstablishFlows)
        {
            return resourceQueries.EstablishFlowDatabaseTable(sYS_EstablishFlows.tableName.Replace(" ", ""), sYS_EstablishFlows.sql, sYS_EstablishFlows.id, sYS_EstablishFlows.remarks); ;

        }
        /// <summary>
        /// 建立流水库
        /// </summary>
        /// <returns></returns>
        [HttpPost("CreateAFlow_Library")]
        [AllowAnonymous]
        public bool CreateAFlow_Library(string DatabaseName, long indexs)
        {
            return resourceQueries.CreateAFlow_Library(DatabaseName, indexs);
        }
        /// <summary>
        /// 查询日志
        /// </summary>
        /// <returns></returns>
        [HttpPost("ShowLog")]
        [AllowAnonymous]
        public IEnumerable<dynamic> ShowLog(long indexs, string tableName)
        {
            return resourceQueries.ShowLog(indexs, tableName);
        }

        /// <summary>
        /// 拉取流水库数据
        /// </summary>
        /// <returns></returns> 
        private static SemaphoreSlim semaphore = new SemaphoreSlim(1, 1);
        [HttpPost("PullData")]
        [AllowAnonymous]
        public async Task PullDataAsync(long indexs, string DatabaseName, string tableName, string zxr,int dbz=0)
        {
            resourceQueries.pullstate(indexs, tableName);
            await semaphore.WaitAsync();
            try
            {
                resourceQueries.PullData(indexs, DatabaseName, tableName, dbz);
                homeQueries.SendMail("流水库拉取提醒", @$"流水库：{DatabaseName}拉取结束，请查看日志。有没有需要特殊处理的医院", zxr);
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                semaphore.Release();
            }
            resourceQueries.Connection(181).Execute($"UPDATE [SV_QueryPlatform].[dbo].[FlowReservoirStatus] SET DataPullTime=getdate() WHERE  indexs={indexs} and tableName='{tableName}'");
        }
        /// <summary>
        /// 操作人展示
        /// </summary>
        /// <returns></returns> 
        [HttpGet("ZxrQuery")]
        [AllowAnonymous]
        public IEnumerable<dynamic> ZxrQuery()
        {
            var user = _userQueries.GetUserById(_iuserIdentity.UserId);
            return homeQueries.ZxrQuery(user);
        }
        /// <summary>
        /// 可生成sql
        /// </summary>
        /// <returns></returns> 
        [HttpGet("DateExplorationSql")]
        [AllowAnonymous]
        public IEnumerable<dynamic> DateExplorationSql()
        {
            return homeQueries.DateExplorationSql();
        }
        /// <summary>
        /// 生成sql
        /// </summary>
        /// <returns></returns> 
        [HttpPost("DateExploration")]
        [AllowAnonymous]
        public string DateExploration(int RetrievalId, List<DateExploration> dateExplorations)
        {

            int ids = drugqueryQueries.indexsId(RetrievalId);
            var sql = "------生成时间：" + DateTime.Now.ToString();
            var name = "";

            try
            {

                if (homeQueries.DateExplorationSql1(dateExplorations) >= 1)
                {
                    sql = sql + @"
--------------------------------------------------------------------------------
" + homeQueries.DateExploration(-1, "", @$"MEDIC_PERSON_INFORMATION_{ids}", RetrievalId);
                }
                List<DES> des = homeQueries.DESIsAssay();
                foreach (var item in dateExplorations.Where(w => des.Select(s => s.id).Contains(w.Id)).Select(s => s.Name2).Distinct())
                {
                    sql = sql + @"
" + homeQueries.DateExploration(-2, item, @$"MEDIC_PERSON_INFORMATION_{ids}", 0);
                }



                foreach (var item in dateExplorations.OrderBy(o => o.Id))
                {
                    name = "";
                    if (!string.IsNullOrEmpty(item.Name1))
                        name = name + "," + item.Name1;
                    if (!string.IsNullOrEmpty(item.Name2))
                        name = name + "," + item.Name2;
                    if (!string.IsNullOrEmpty(item.Name3))
                        name = name + "," + item.Name3;
                    if (!string.IsNullOrEmpty(item.Name4))
                        name = name + "," + item.Name4;
                    if (!string.IsNullOrEmpty(item.Name5))
                        name = name + "," + item.Name5;
                    if (!string.IsNullOrEmpty(item.Name6))
                        name = name + "," + item.Name6;
                    if (!string.IsNullOrEmpty(item.Name7))
                        name = name + "," + item.Name7;
                    if (!string.IsNullOrEmpty(item.Name8))
                        name = name + "," + item.Name8;
                    if (!string.IsNullOrEmpty(item.Name9))
                        name = name + "," + item.Name9;
                    if (!string.IsNullOrEmpty(item.Name10))
                        name = name + "," + item.Name10;

                    name = name.Substring(1);

                    sql = sql +
                     @"
--------------------------------------------------------------------------------
" + homeQueries.DateExploration(item.Id, name, @$"MEDIC_PERSON_INFORMATION_{ids}", RetrievalId);

                }
            }
            catch (Exception e)
            {

                sql = "先填写输入框后勾选";
            }



            return sql;

        }
        [HttpGet("lingchuanglujingjiancha")]
        [AllowAnonymous]
        public IEnumerable<dynamic> lingchuanglujingjiancha(string name)
        {
            var DemandQuery = homeQueries.lingchuanglujingjiancha(name);
            return DemandQuery;
        }
        [HttpGet("ATC")]
        [AllowAnonymous]
        public async void ATC(string atccode = "", string url = "https://atcddd.fhi.no/atc_ddd_index/")
        {
            drugqueryQueries.ATC(atccode, url);
        }

 

    }
}
