﻿using QueryPlatform.Infra;
using System.ComponentModel;

namespace QueryPlatform.Api
{
    public class ApiResponse<TEntity>
        where TEntity : class, new()
    {
        public ResponseType StatusCode { get; set; }
        /// <summary>
        /// 消息内容。
        /// </summary>
        public string Message { get; set; }
        /// <summary>
        /// 返回数据。
        /// </summary>
        public TEntity Data { get; set; }

        public ApiResponse()
            : this(ResponseType.NotFound, EnumHelper.GetDescription(ResponseType.NotFound), null)
        {
        }
        public ApiResponse(ResponseType type)
            : this(type, EnumHelper.GetDescription(type), null)
        {
        }

        public ApiResponse(ResponseType type, string message)
            : this(type, message, null)
        {
        }

        public ApiResponse(ResponseType type, TEntity entity)
            : this(type, EnumHelper.GetDescription(type), entity)
        {
        }

        public ApiResponse(ResponseType type, string message, TEntity entity)
        {
            StatusCode = type;
            Message = message;
            Data = entity;
        }
    }

    public sealed class ApiResponse : ApiResponse<object>
    {
        public ApiResponse()
        {
        }

        public ApiResponse(ResponseType type) : base(type)
        {
        }

        public ApiResponse(ResponseType type, string message) : base(type, message)
        {
        }

        public ApiResponse(ResponseType type, object entity) : base(type, entity)
        {
        }

        public ApiResponse(ResponseType type, string message, object entity) : base(type, message, entity)
        {
        }
    }

    public enum ResponseType
    {
        /// <summary>
        /// 执行成功
        /// </summary>
        [Description("执行成功")]
        OK = 200,

        /// <summary>
        /// 参数错误
        /// </summary>
        [Description("参数错误")]
        BadRequest = 400,

        /// <summary>
        /// 身份认证未授权
        /// </summary>
        [Description("身份认证未授权")]
        Unauthorized = 401,

        /// <summary>
        /// 资源无效
        /// </summary>
        [Description("资源无效")]
        NotFound = 404,

        /// <summary>
        /// 内部错误
        /// </summary>
        [Description("内部错误")]
        longernalServerError = 500,

        /// <summary>
        /// 不支持请求
        /// </summary>
        [Description("不支持请求")]
        NotImplemented = 501,
        Fail = 502,
    }
}
