﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using System.Linq;
using System.Net;

namespace QueryPlatform.Api.Infrastructure.Filters
{
    public class ValidateModelFilter : IResultFilter
    {
        private readonly ILogger<ValidateModelFilter> _logger;
        public ValidateModelFilter(ILogger<ValidateModelFilter> logger)
        {
            _logger = logger;
        }

        public void OnResultExecuting(ResultExecutingContext context)
        {
            var response = context.Result as BadRequestObjectResult;
            if (response != null && response.Value is ValidationProblemDetails)
            {
                var details = response.Value as ValidationProblemDetails;

                var result = new ParameterErrorResponse
                {
                    Message = "参数无效",
                    Instance = context.HttpContext.Request.Path,
                };
                foreach (var item in details.Errors)
                {
                    if (!result.Errors.ContainsKey(item.Key) && item.Value.Any())
                        result.Errors.Add(item.Key, item.Value.First());
                }

                context.Result = new BadRequestObjectResult(result);
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.BadRequest;
            }
        }

        public void OnResultExecuted(ResultExecutedContext context)
        {
            if (context.Exception == null)
            {
                if (context.Result is ObjectResult)
                {
                    var objectResult = (ObjectResult)context.Result;
                    var jsonData = JsonConvert.SerializeObject(objectResult.Value);
                    _logger.LogInformation($"请求地址：{context.HttpContext.Request.Path};响应结果:{jsonData}");
                }

                else if (context.Result is EmptyResult)
                {
                    _logger.LogInformation($"请求地址：{context.HttpContext.Request.Path};没有响应结果");
                }
            }
        }
    }
}
