﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.SignalR;
using System;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Infrastructure.Hubs
{
    [Authorize]
    public class NotificationHub : Hub
    {
        public override Task OnConnectedAsync()
        {
            var userId = Context.User.Claims.FirstOrDefault(w => w.Type == ClaimTypes.Sid)?.Value;
            Groups.AddToGroupAsync(Context.ConnectionId, userId);
            return base.OnConnectedAsync();
        }

        public override Task OnDisconnectedAsync(Exception exception)
        {
            var userId = Context.User.Claims.FirstOrDefault(w => w.Type == ClaimTypes.Sid)?.Value;
            Groups.RemoveFromGroupAsync(Context.ConnectionId, userId);
            return base.OnDisconnectedAsync(exception);
        } 
    }

}
