﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using QueryPlatform.Infra;

namespace QueryPlatform.Api.Infrastructure
{
    public class JsonHelper : IJsonConverter
    {
        private readonly JsonSerializerSettings _serializerSettings;

        public JsonHelper(IOptions<MvcNewtonsoftJsonOptions> options)
        {
            IsoDateTimeConverter datetimeConverter = new IsoDateTimeConverterContent
            {
                DateTimeFormat = "yyyy-MM-dd HH:mm:ss"
            };
            _serializerSettings = new JsonSerializerSettings
            {
                MissingMemberHandling = MissingMemberHandling.Ignore,
                NullValueHandling = NullValueHandling.Ignore,
                ReferenceLoopHandling = ReferenceLoopHandling.Ignore
            };
            _serializerSettings.Converters.Add(datetimeConverter);
            _serializerSettings.ContractResolver = new LowercaseContractResolver();
            _serializerSettings = options.Value.SerializerSettings;
        }
        //public static T Deserialize<T>(string json)
        //{
        //    return JsonConvert.DeserializeObject<T>(json);
        //}
        /// <summary>
        /// 将指定的 JSON 数据反序列化成指定对象。
        /// </summary>
        /// <typeparam name="T">对象类型。</typeparam>
        /// <param name="json">JSON 数据。</param>
        /// <returns></returns>

        public string Serialize(object @object)
        {
            return JsonConvert.SerializeObject(@object, Formatting.None, _serializerSettings);
        }
    }
}
