﻿using EasyCaching.Core;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using QueryPlatform.Infra;
using System;
using System.IO;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Infrastructure.Middlewares
{
    /// <summary>
    /// 解码中间件
    /// </summary>
    public class DoubleRequestMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly IEasyCachingProvider _provider;

        public DoubleRequestMiddleware(
            RequestDelegate next,
            IEasyCachingProvider provider)
        {
            _next = next;
            _provider = provider;
        }

        public async Task Invoke(HttpContext context)
        {
            var request = context.Request;
            var timestamp = request.Headers["Timestamp"];
            string body = await new StreamReader(request.Body).ReadToEndAsync();

            StringBuilder @string = new StringBuilder();
            @string
                .Append(request.Method)
                .Append(request.Scheme)
                .Append(context.Connection.RemoteIpAddress)
                .Append(context.Connection.RemotePort)
                .Append(request.Path)
                .Append(request.QueryString)
                .Append(timestamp)
                .Append(body);

            var sign = Md5Util.Encrypt(@string.ToString());

            var key = $"api.submit.sign.{sign}";

            if (_provider.Exists(key))
            {
                var response = new DoubleSubmitResponse();
                context.Response.StatusCode = (int)HttpStatusCode.Forbidden;
                context.Response.ContentType = "application/json";
                await context.Response.WriteAsync(JsonConvert.SerializeObject(response));
                return;
            }

            _provider.Set(key, DateTime.Now, TimeSpan.FromSeconds(20));
            await _next(context);
        }
    }

    public static class DoubleRequestMiddlewareExtensions
    {
        public static IApplicationBuilder UseDoubleRequest(this IApplicationBuilder builder)
        {
            return builder.UseMiddleware<DoubleRequestMiddleware>();
        }
    }
}
