﻿using System;

namespace QueryPlatform.Api.Infrastructure
{
    public class Notification
    {
        public Notification(long userId, string method, PushContent body)
        {
            UserId = userId;
            Method = method;
            Body = body;
        }

        public long UserId { get; set; }
        public string Method { get; set; }
        public PushContent Body { get; set; }

        public abstract class PushContent
        {
            protected PushContent(string content)
            {
                Content = content;
            }

            public abstract string Type { get; }
            public string Time { get => DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"); }
            public string Content { get; set; }
        }
    }

    public class EventContent : Notification.PushContent
    {
        public EventContent(object eventId, string subject, string content) : base(content)
        {
            EventId = eventId;
            Subject = subject;
        }

        public object EventId { get; set; }
        public string Subject { get; set; }

        public override string Type => "Event";
    }
    public class TextContent : Notification.PushContent
    {
        public TextContent(string content) : base(content)
        {
        }

        public override string Type => "Text";
    }
}
