﻿using System.Collections.Generic;

namespace QueryPlatform.Api.Infrastructure
{
    public class Page
    {
        public Page() : this(1, 30) { }
        public Page(long index) : this(index, 30) { }

        public Page(long index, long size)
        {
            Index = index;
            Size = size;
        }

        /// <summary>
        /// 页码
        /// </summary>
        public long Index { get; set; }
        /// <summary>
        /// 页行数 默认30
        /// </summary>
        public long Size { get; set; }
    }

    public class Page<TEntity> : Page
    {
        public Page(long total, IEnumerable<TEntity> data)
        {
            Total = total;
            Data = data;
        }

        public Page(long index, long size, long total, IEnumerable<TEntity> data)
            : base(index, size)
        {
            Total = total;
            Data = data;
        }

        public long Total { get; set; }
        public IEnumerable<TEntity> Data { get; set; }
    }
}
