﻿using Dapper;
using DocumentFormat.OpenXml;
using FluentEmail.Core;//
using FluentEmail.Smtp;//
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.SignalR;
using Microsoft.Data.SqlClient;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using NPoco.Expressions;
using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using NPOI.XSSF.UserModel;
using QueryPlatform.Api.Infrastructure.Modules;
using StackExchange.Profiling.Internal;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.IO;
using System.Linq;
using System.Net;//
using System.Net.Mail;//
using System.Text;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Infrastructure.Queries
{

    public class HomeQueries
    {
        private readonly string _Connection156;
        private readonly string _configConnectionString;
        public HomeQueries(string configConnectionString, string Connection156)
        {
            _configConnectionString = configConnectionString;
            _Connection156 = Connection156;
        }
        private DbConnection Connection()
        {
            return new SqlConnection(_configConnectionString);
        }
        public DbConnection Connection(long ip, string y = "", string t = "")
        {
            if (ip == 156)
            {
                return new SqlConnection((y == "") ? _Connection156 : _Connection156.Replace(y, t));
            }
            if (ip == 181)
            {
                return new SqlConnection((y == "") ? _configConnectionString : _configConnectionString.Replace(y, t));
            }
            return new SqlConnection();
        }
        #region 存储函数添加查询 
        public void FuncaConfiguration(COMMONLYUSED commonly)
        {
            var funcaadd = @$"INSERT into [SV_QueryPlatform_Demand].[dbo].[CommonlyUsed](Name,value,remarks) VALUES('{commonly.Name}','{commonly.value.Replace("'", "''")}','{commonly.remarks}')";
            Connection().Execute(funcaadd);
        }
        /// <summary>
        /// 存储函数展示
        /// </summary>
        /// <returns></returns>
        public IEnumerable<dynamic> FuncaQuery()
        {
            var query = @$"SELECT [Name],[value] ,[remarks] FROM [SV_QueryPlatform_Demand].[dbo].[CommonlyUsed]";
            return Connection().Query(query).ToList();
        }
        public IEnumerable<dynamic> lingchuanglujingjiancha(string name)
        {
            if (string.IsNullOrEmpty(name))
            {
                name = "肺脓肿";
            }
            var where = @$"where clinical_route_name = '{name}'";
            var query = @$"SELECT  
clinical_route_name,
  CASE WHEN LAG(医嘱名称) OVER (ORDER BY cast(排序 as int),医嘱名称) = 医嘱名称  THEN NULL  ELSE 住院 END AS 住院,
  CASE WHEN LAG(医嘱名称) OVER (ORDER BY cast(排序 as int),医嘱名称) = 医嘱名称  THEN NULL  ELSE 住院标准 END AS 住院标准, 
  CASE WHEN LAG(医嘱名称) OVER (ORDER BY cast(排序 as int),医嘱名称) = 医嘱名称  THEN NULL  ELSE 医嘱类型 END AS 医嘱类型,
 CASE WHEN LAG(医嘱名称) OVER (ORDER BY cast(排序 as int),医嘱名称) = 医嘱名称  THEN NULL  ELSE 是否必开 END AS  是否必开  ,
   CASE WHEN LAG(医嘱名称) OVER (ORDER BY cast(排序 as int),医嘱名称) = 医嘱名称  THEN NULL  ELSE 医嘱名称 END AS  医嘱名称,
  项目,
  备注,
  项目id
FROM 

(  SELECT 排序 排序 ,clinical_route_name clinical_route_name ,住院 住院,住院标准, 医嘱类型,是否必开,医嘱名称,项目,备注,项目id ,
      
         ROW_NUMBER() OVER (ORDER BY cast(排序 as int) ) AS row_num
  FROM [DB_丹寨县人民医院].[dbo].[View_临床核对]{where}) a
ORDER BY clinical_route_name,cast(排序 as int);";
            return Connection().Query(query).ToList();
        }
        #endregion
        #region 需求记录展示、添加、导出csv、上传sql脚本  
        public string Executes(DateTime StartTime, DateTime EndTime, string WebRootPath)
        {
            var sql = $@"  SELECT  [START_TIME] 项目时间,Demand_User 需求来源, [Demand_Name]需求名称,[Demand_Describe]需求描述 FROM [SV_QueryPlatform_Demand].[dbo].[MEDIC_DEMAND]where 1=1  {((StartTime.ToString() != "0001/1/1 0:00:00") ? "and [search_time]>='" + StartTime + "'" : "")} 
{((EndTime.ToString() != "0001/1/1 0:00:00") ? "and [search_time]<='" + EndTime + "'" : "")} order by START_TIME";
            var queryData = Connection().Query(sql);
            var data1 = queryData.Select(t => t as IDictionary<string, object>).ToList();
            try
            {
                var strRows = new StringBuilder();//数据拼写，这里是测试数据不多，但是真是情况基本是大量数据。所以要用StringBuilder
                if (data1.Any())
                {
                    // Header
                    strRows.Append(string.Join(",", data1[0].Select(t => t.Key)));
                    strRows.Append(@$"
");//换行 
                    foreach (var item in data1)
                    {
                        var vals = item.Values.Select(t =>
                        {
                            var value = t?.ToString();
                            return string.IsNullOrWhiteSpace(value) ? "" : value;
                        });

                        strRows.Append(string.Join(",", vals));
                        strRows.Append(@$"
");//换行
                    }
                }
                string sExportFileName = "需求记录导出" + DateTime.Now.AddDays(-1).ToString("yyyyMMdd") + ".csv"; //文件名

                string path = Path.Combine(WebRootPath + @"\export", sExportFileName);

                string 下载地址 = @"http://192.168.18.181:8055/api/export/export/" + sExportFileName;
                //检查是否有这个文件，没有创建文件，最后一定要Close，不然文件占用无法写入
                if (File.Exists(path))
                {
                    System.IO.File.Delete(path); //已有该文件进行删除
                }
                File.Create(path).Close();//创建文件


                //写入文件
                using (System.IO.StreamWriter file = new System.IO.StreamWriter(path, true))
                {
                    file.WriteLine(strRows);
                    file.Dispose();
                }
                return 下载地址;
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) DemandQuery(long paseIndex, string Demand_Name)
        {
            string where = " ";
            if (!string.IsNullOrEmpty(Demand_Name))
            {
                where = "and [Demand_Name] like '%" + Demand_Name + "%'";
            }
            string where2 = " ";
            if (!string.IsNullOrEmpty(Demand_Name))
            {
                where2 = " where  [Demand_Name] like '%" + Demand_Name + "%'";
            }
            IEnumerable<dynamic> sj = Connection().Query($@"  
            SELECT ID, [Demand_Name], [Demand_Describe], [INDEXS],[Demand_User], [START_TIME]          
                     FROM [SV_QueryPlatform_Demand].[dbo].[MEDIC_DEMAND]  {where2} order by id desc offset ({paseIndex} - 1)*(10) rows fetch next 10 rows only").ToList();

            IEnumerable<dynamic> zon = Connection().Query($@"SELECT  CAST(COUNT(*)AS MONEY)totalCount ,{paseIndex} paseIndex FROM(
                 SELECT  ID FROM [SV_QueryPlatform_Demand].[dbo].[MEDIC_DEMAND]  {where2})a").ToList();
            return (sj, zon);
        }
        public void Demand(SYS_DEMAND sYS_Demand)
        {
            var sql = @$"INSERT into [SV_QueryPlatform_Demand].[dbo].[MEDIC_DEMAND]([START_TIME],[INDEXS],[Demand_Describe],[Demand_Name],[Demand_User] ) VALUES(getdate(),{sYS_Demand.INDEXS},'{sYS_Demand.Demand_Describe}','{sYS_Demand.Demand_Name}','{sYS_Demand.Demand_User}')";
            Connection().Execute(sql, commandTimeout: 60 * 60 * 5);
        }
        public string PostFile(IFormFile file, string WebRootPath)
        {
            StreamReader reader = new StreamReader(file.OpenReadStream());
            string content = reader.ReadToEnd();
            string name = file.FileName;
            var date = DateTime.Now.ToLongDateString().ToString(); // 2008年9月4日
            var time = DateTime.Now.ToLongTimeString().ToString(); // 20:16:16
            var dateTime = date + time;
            string filename = "";
            string 下载地址 = "";
            if (name.Substring(name.Length - 3, 3) == "txt" || name.Substring(name.Length - 3, 3) == "sql")
            {
                if (name.Substring(name.Length - 3, 3) == "sql")
                {
                    name = name.Replace("sql", "txt");
                }
                filename = Path.Combine(WebRootPath + @"\export", name.Replace(".", dateTime.Replace(":", "") + "."));
                下载地址 = @"http://192.168.18.181:8055/api/export/export/" + name.Replace(".", dateTime.Replace(":", "") + ".");
            }
            else
            {
                throw new DomainException("只支持txt || sql文件！！！");
            }

            if (System.IO.File.Exists(filename))
            {
                System.IO.File.Delete(filename);
            }
            using (FileStream fs = System.IO.File.Create(filename))
            {
                // 复制文件
                file.CopyTo(fs);
                // 清空缓冲区数据
                fs.Flush();
            }
            return 下载地址;
        }
        public void Demandfu(SYS_DEMANDSUBLIS sYS_DemandSublist, string WebRootPath)
        {
            string xzfile = PostFile(sYS_DemandSublist.file, WebRootPath);
            var sql = @$"INSERT into [SV_QueryPlatform_Demand].[dbo].[MEDIC_DEMAND_Sublist]([START_TIME],[Fid],[sql_text] ,UserName,remark) VALUES(getdate(),'{sYS_DemandSublist.id}','{xzfile}','{sYS_DemandSublist.UserName}','{sYS_DemandSublist.remark}')";
            Connection().Execute(sql, commandTimeout: 60 * 60 * 5);
        }
        public IEnumerable<dynamic> DemandQueryfu(int id)
        {
            var query = @$"SELECT [ID],[START_TIME] ,[sql_text],[UserName],[remark] FROM [SV_QueryPlatform_Demand].[dbo].[MEDIC_DEMAND_Sublist] where fid={id}";
            return Connection().Query(query).ToList();
        }
        #endregion
        #region 服务器
        /// <summary>
        /// 添加服务器
        /// </summary>
        /// <param name="servers"></param>
        public void ServersConfiguration(服务器 servers)
        {
            var sql = @$"INSERT into [SV_QueryPlatform].[dbo].[服务器]([服务器ip],[数据库账号],[数据库密码])VALUES('{servers.服务器ip}','{servers.数据库账号}','{servers.数据库密码}')";
            Connection().Execute(sql, commandTimeout: 60 * 60 * 5);
        }
        /// <summary>
        /// 展示服务器
        /// </summary>
        /// <param name="servers"></param>
        public IEnumerable<dynamic> ServersShow()
        {
            return Connection().Query(@$"SELECT * FROM [SV_QueryPlatform].[dbo].[服务器]");
        }
        #endregion 
        #region 查询南海核对数据
        public IEnumerable<dynamic> YiYuanHeDui(long hos_id, string year)
        {
            var where = @$" and year={year} and HospitalId={hos_id}";
            var sql = @$"SELECT 1 a,  a 大类别,x 年份,y 小类别,cast(value as nvarchar)值
FROM OPENQUERY([MYSQL49],
'select ''人均就诊次数''a, year x,CONCAT(Source ,''-'',''平均就诊次数'') y,round(sum(persontime)/sum(personnum),2) value 
from hos_original_personnum
where 1 = 1 {where}
group by x,Source')
union
SELECT  2, a,x,y,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
SELECT ''业务总收入''a,year x, CONCAT(Source, '' - '', ''业务收入'') y,cast(SUM(FEE) as SIGNED) value
     FROM Hos_original_feetype where 1 = 1 {where}
GROUP BY year,Source ')
union
SELECT 3, a,y,x,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select ''业务总收入''a, year y, CONCAT(Source, '' - '', ''医保收入'')x, round(sum(fee)) value
    from hos_original_paytypefee t where paytype1 = ''医保'' {where}
group by y,Source ')
union
SELECT  4, 业务收入结构,y,x,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select t1.*from(
    select ''业务收入结构'', year y, concat(Classification, '''', ''占比'') x, concat(round(cast(sum(fee) as SIGNED) / (select sum(VALUE) from(
    select Classification x, year y, cast(sum(fee) as SIGNED) value from Hos_original_feetype

    where classification not in ('''', ''\0'') {where}

    group by year, Classification
) t1 left join(select name, sort from sys_sort where type = ''feetype'') t2
on t1.x = t2.name) * 100, 2),'''',''%'') value
     from Hos_original_feetype
         where classification not in ('''',''\0'') {where}

    group by year,Classification
) t1 left join(select name, sort from sys_sort where type = ''feetype'') t2
  on t1.x = t2.name')
union
SELECT 5, 工作量,y,x,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select ''工作量'', year y, CONCAT(Source, '''', ''量'')x,cast(sum(persontime) as SIGNED) value
  from Hos_original_persontime where 1 = 1 {where} group by year,Source
')
union
SELECT 6,工作量,y,x,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select ''工作量'', year y, CONCAT(Source, '''', ''医保业务量'')x, sum(PersonTime) value from hos_original_paytypeperson t where paytype1 = ''医保'' {where}
group by y ,Source')
union
SELECT 7, x,y,平均住院日,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
SELECT ''平均住院日''x,year y, ''平均住院日'', format(sum(daycount) / sum(persontime), 2) value
  FROM hos_original_hosstay where 1 = 1 {where}
GROUP BY year ')
union
SELECT 8, x,y,医保平均住院日,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select  ''平均住院日''x,year y, ''医保平均住院日'',round(sum(daycount) / sum(persontime), 2) value
from hos_original_paytypeperson where paytype1 = ''医保'' and source = ''住院'' {where} group by y ')
union
SELECT 9, y,x,收住院率,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select ''收住院率''y,t1.x x, ''收住院率'',round(t1.value * 100.0 / t2.value, 2) value from(
select year x, cast(sum(persontime) as signed) value from hos_original_persontime
where source = ''住院'' and year<>'''' {where} group by year ) t1 left join(
select  year x, cast(sum(persontime) as signed) value from hos_original_persontime
 where source = ''门诊'' and year <> '''' {where} group by year) t2 on t1.x = t2.x')
union
SELECT 10, x,y,医保收住院率, cast(value as nvarchar) FROM OPENQUERY([MYSQL49], '
select ''收住院率'' x, year y, ''医保收住院率'',round(sum(case source when ''住院'' then persontime end) * 100 / sum(case source when ''门诊'' then persontime end), 2) value
from hos_original_paytypeperson where paytype1 = ''医保'' {where} group by x,y ')
union
SELECT 11, 次均费用,y,x,cast(value as nvarchar) FROM OPENQUERY([MYSQL49], '
select ''次均费用'',t1.y,concat(t1.Source, t1.x, ''次均费用'')x, round(t1.value / t2.value, 2) value
from(select paytype1 x, year y, Source, sum(fee) value from hos_original_paytypefee
where 1 = 1 {where} group by x, y, Source) t1
inner join(select paytype1 x, year y, Source, sum(persontime) value from hos_original_paytypeperson
where 1 = 1 {where}  group by x, y, Source) t2
on t1.x = t2.x and t1.y = t2.y and t1.Source = t2.Source where t1.x = ''医保''')
union
SELECT  12,  次均费用,x,y,cast(value as nvarchar)
FROM OPENQUERY([MYSQL49], '
select ''次均费用'' ,a.year x, concat(a.Source, '''', ''次均费用'') y, ROUND(a.fee / b.persontime) value from(
select Source, year, sum(fee) fee from Hos_original_feetype  where 1 = 1 {where}
group by year,Source ) a right join(
select Source, year, sum(persontime) persontime from Hos_original_persontime where 1 = 1 {where} group by year, Source
) b on a.year = b.year and a.Source = b.Source')";
            return Connection().Query(sql);
            ;
        }
        #endregion
        #region 爬虫保存josn
        public IEnumerable<dynamic> Ybyp(string josn, long ym)
        {
            var sql = @$"insert into  [SV_QueryPlatform_Demand].[dbo].[医保字典json]([医保字典json],[页])
select  replace(replace('{josn.Replace("'", "")}','	',''),'
',''),{ym} ";
            return Connection().Query(sql);
        }
        #endregion
        #region 操作人查询  
        public IEnumerable<dynamic> ZxrQuery(SYS_USER sYS_USER)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            return connection.Query<dynamic>($@"SELECT UserName  FROM [SV_QueryPlatform_Demand].[dbo].[Mailboxs] where type={(sYS_USER.States == true ? "2" : "3")}").ToList();
        }
        #endregion 
        #region 数据探索sql生成存储过程  
        public List<DES> DESIsAssay()
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            return connection.Query<DES>($@"SELECT  [id],IsAssay
                  FROM [SV_QueryPlatform_Demand].[dbo].[DateExplorationSql] where IsAssay=1").ToList();
        }
        public IEnumerable<dynamic> DateExplorationSql()
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            return connection.Query<dynamic>($@"SELECT  [id] 
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],0,'|') Name1
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],1,'|') Name2
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],2,'|') Name3
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],3,'|') Name4
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],4,'|') Name5
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],5,'|') Name6
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],6,'|') Name7
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],7,'|') Name8
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],8,'|') Name9
                  ,[SV_QueryPlatform_].[dbo].[fGetStrBySplit]([RuleName],9,'|') Name10
                  FROM [SV_QueryPlatform_Demand].[dbo].[DateExplorationSql]").ToList();
        }
        public long DateExplorationSql1(List<DateExploration> dateExplorations)
        {
            string where = "";
            foreach (var item in dateExplorations.Select(s => s.Id))
            {
                where = "," + item;
            }
            where = where.Substring(1);
            var sql = @$"SELECT * FROM [SV_QueryPlatform_Demand].[dbo].[DateExplorationSql]  where id in ({where}) and RuleName like '%首诊%' ";

            DbConnection connection = new SqlConnection(_configConnectionString);
            return connection.Query<dynamic>(sql).Count();
        }
        public string DateExploration(int id, string name, string TableName, long indexs)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = connection.Query<string>($@"DECLARE	@return_value long,@sql nvarchar(max) SELECT	@sql = N'output' EXEC @return_value = [SV_QueryPlatform_].[dbo].[DemandExploration]  @id = {id},@condition = N'{name}',@TableName = N'{TableName}',@indexs = {indexs},@sql = @sql OUTPUT SELECT @sql sql").FirstOrDefault();
            return sql;
        }
        #endregion
        #region 添加绩效拿回医院数据登记
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) ExtractShou(long paseIndex)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            IEnumerable<dynamic> data = connection.Query($@"  
                       select HOS_ID,ExecOpenLink,ExecDatabase,HOS_NAME,CREATION_TIME,UPDATE_TIME,START_TIME,END_TIME,I_UPDATE_TIME,REMARK,Executor from (
 SELECT  a.ID,HOS_ID,b.ExecOpenLink,b.ExecDatabase,HOS_NAME,CREATION_TIME,UPDATE_TIME,START_TIME,END_TIME,I_UPDATE_TIME,REMARK,Executor        
                     FROM [SV_QueryPlatform_Demand].[dbo].[DataExtract]  a
      join [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] b on a.HOS_ID=b.id)a order by case when a.I_UPDATE_TIME<=getdate() then 1000000 else id end
      desc offset ({paseIndex}- 1)*(10) rows fetch next 10 rows only").ToList();


            IEnumerable<dynamic> zong = connection.Query($@"SELECT  CAST(COUNT(*)AS MONEY)totalCount ,{paseIndex} paseIndex FROM(
                        SELECT ID FROM [SV_QueryPlatform_Demand].[dbo].[DataExtract])a").ToList();
            return (data, zong);
        }
        public void Update(DATAEXTRACT dataExtract)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = @$"update [SV_QueryPlatform_Demand].[dbo].[DataExtract] set HOS_ID='{dataExtract.HOS_ID}',UPDATE_TIME=getdate(),START_TIME='{dataExtract.START_TIME}',END_TIME='{dataExtract.END_TIME}',I_UPDATE_TIME='{dataExtract.END_TIME.AddMonths(3)}',REMARK='{dataExtract.REMARK}' where hos_id={dataExtract.HOS_ID}";
            connection.Execute(sql, commandTimeout: 60 * 60 * 5);
        }
        public void Add(SYS_EXTRACT sYS_Extract)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            List<DATAEXTRACT> ques = connection.Query<DATAEXTRACT>(@$"select HOS_ID from [SV_QueryPlatform_Demand].[dbo].[DataExtract]").ToList();
            foreach (var item in ques)
            {
                if (item.HOS_ID == sYS_Extract.HOS_ID)
                {
                    throw new DomainException("医院已存在，无需重复添加！");
                }
            }
            var sql = @$"INSERT into [SV_QueryPlatform_Demand].[dbo].[DataExtract](HOS_ID,HOS_NAME,CREATION_TIME,UPDATE_TIME,START_TIME,END_TIME,I_UPDATE_TIME,REMARK,Executor )VALUES('{sYS_Extract.HOS_ID}','{sYS_Extract.HOS_NAME}',getdate(),getdate(),'{sYS_Extract.START_TIME}','{sYS_Extract.END_TIME}','{sYS_Extract.END_TIME.AddMonths(3)}','{sYS_Extract.REMARK}','{sYS_Extract.Executor}')";

            connection.Execute(sql, commandTimeout: 60 * 60 * 5);

            var sql2 = @$"update [SV_QueryPlatform_Demand].[dbo].[DataExtract] set ExecDatabase=(SELECT b.ExecDatabase FROM [SV_QueryPlatform_Demand].[dbo].[DataExtract]  a
      join [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] b on a.HOS_ID=b.id  where a.hos_id={sYS_Extract.HOS_ID}),ExecOpenLink=((SELECT b.ExecOpenLink FROM [SV_QueryPlatform_Demand].[dbo].[DataExtract]  a
      join [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] b on a.HOS_ID=b.id  where a.hos_id={sYS_Extract.HOS_ID})) where [HOS_ID]={sYS_Extract.HOS_ID}";

            connection.Execute(sql2, commandTimeout: 60 * 60 * 5);
        }
        #endregion 
        #region 发送邮箱 
        public void SendMail(string title, string content, string zxr = "")
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = @$"SELECT [mailbox],[password],[type],[UserName],jurisdiction,[SV_QueryPlatform_Demand].dbo.fn_GetPy(UserName) UserNames FROM [SV_QueryPlatform_Demand].[dbo].[Mailboxs]";

            var mailboxs = connection.Query<Mailboxs>(sql, commandTimeout: 60 * 60 * 5);
            var OutgoingEmail = mailboxs.Where(w => w.type == 1).FirstOrDefault();
            var ReceivingMailboxs = mailboxs;
            if (string.IsNullOrEmpty(zxr))
            {
                ReceivingMailboxs = mailboxs.Where(w => w.type == 2 & w.jurisdiction == "管理员").ToList();
            }
            else
            {
                sql = @$"SELECT [SV_QueryPlatform_Demand].dbo.fn_GetPy('{zxr}') UserNames ";
                var zxrs = connection.Query<string>(sql).FirstOrDefault();
                ReceivingMailboxs = mailboxs.Where(w => w.type == 2 & w.UserNames == zxrs).ToList();
            }
            SmtpClient smtp = new SmtpClient
            {
                Host = "smtp.qq.com",
                UseDefaultCredentials = true,
                EnableSsl = true,
                DeliveryMethod = SmtpDeliveryMethod.Network,
                Credentials = new NetworkCredential(OutgoingEmail.mailbox, OutgoingEmail.password)
            };
            Email.DefaultSender = new SmtpSender(smtp);
            try
            {
                foreach (var item in ReceivingMailboxs)
                {
                    if (item != null)
                    {
                        var email = Email
                        .From(OutgoingEmail.mailbox)//发送人
                        .To(item.mailbox)//收件人 .CC("admin@126.com")//抄送人
                        .Subject(title)//邮件标题
                        .Body(content);//邮件内容
                        email.Send();//发送
                    }
                }
            }
            catch (Exception e)
            {

                throw;
            }

        }
        #endregion
        #region 传入人群表 调用存储过程生成excl导出数据
        public void DateExploration(string ExportTableName)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = connection.Execute($@"EXEC SV_QueryPlatform_.[dbo].[DataExport]  N'{ExportTableName}' ", commandTimeout: 10000000);
        }
        #endregion 
        #region 导出excel表格数据 
        public string Excelex(string ExportTableName, string WebRootPath)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var memory = new MemoryStream();
            var date = DateTime.Now;
            var sql = "";
            string 下载地址 = "";
            try
            {
                DateExploration(ExportTableName);
            }
            catch (Exception e)
            {
                throw new DomainException($@"请核对表名！如果无误请确保有拼库名！错误：" + e);
            }
            try
            {
                string newFile = Path.Combine(WebRootPath + @"\export", "病人模板导出" + date.Year + date.Month + date.Day + date.Hour + date.Minute + date.Second + ".xlsx");

                下载地址 = @"http://192.168.18.181:8055/api/export/export/" + "病人模板导出" + date.Year + date.Month + date.Day + date.Hour + date.Minute + date.Second + ".xlsx";
                if (System.IO.File.Exists(newFile))
                {
                    System.IO.File.Delete(newFile);
                }
                using (var fs = new FileStream(newFile, FileMode.Create, FileAccess.ReadWrite))
                {

                    //HSSFWorkbook workbook = new HSSFWorkbook();.xls（选用xls的话，最后返回下载的后缀名改为xls）
                    XSSFWorkbook workbook = new XSSFWorkbook();//.xlsx，（推荐xlsx，2007版本以上都是xlsx的） 
                    #region 病人表
                    var sheet = workbook.CreateSheet("病人表");//创建工作表
                    var header = sheet.CreateRow(0);//工作行
                    var brb = new Dictionary<string, Func<PUB_PATIENT, object>>
                    {
                       { "0"+" 病人编码" , t => t.病人编码},
                       { "1"+" 医院病人编码" , t => t.医院病人编码},
                       { "2"+" 性别" , t => t.性别},
                       { "3"+" 出生日期" , t => t.出生日期},
                       { "4"+" 标准地域" , t => t.标准地域},
                       { "5"+" 民族" , t => t.民族},
                       { "6"+" 国籍" , t => t.国籍},
                       { "7"+" 创建机构" , t => t.创建机构},
                       { "8"+" 病人主索引" , t => t.病人主索引}
                    };

                    foreach (var item in brb)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[PUB_PATIENT]";
                    var PUB_PATIENT = connection.Query<PUB_PATIENT>(sql).OrderBy(s => s.病人主索引).ToList();
                    for (int i = 0; i < PUB_PATIENT.Count; i++)
                    {
                        var datarow = sheet.CreateRow(rowIndex);

                        foreach (var item in brb)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(PUB_PATIENT[i])?.ToString()) ? "" : item.Value.Invoke(PUB_PATIENT[i])?.ToString());
                        }
                        rowIndex++;
                    }
                    #endregion
                    #region 门诊登记
                    var sheet1 = workbook.CreateSheet("门诊登记");//创建工作表
                    var header1 = sheet1.CreateRow(0);//工作行
                    var brb1 = new Dictionary<string, Func<OUT_REG_INFO, object>>
                    {
                       { "0"+" 挂号序号" , t => t.挂号序号},
                       { "1"+" 医院挂号序号" , t => t.医院挂号序号},
                       { "2"+" 病人编码" , t => t.病人编码},
                       { "3"+" 医院病人编码" , t => t.医院病人编码},
                       { "4"+" 挂号时间" , t => t.挂号时间},
                       { "5"+" 医院挂号科室" , t => t.医院挂号科室},
                       { "6"+" 医院科室名称" , t => t.医院科室名称},
                       { "7"+" 医保类型" , t => t.医保类型},
                       { "8"+" 急诊_门诊" , t => t.急诊_门诊},
                       { "9"+" 标准一级诊断" , t => t.标准一级诊断},
                       { "10"+" 标准科室" , t => t.标准科室},
                       { "11"+" 创建机构" , t => t.创建机构},
                       { "12"+" 上传时间" , t => t.上传时间},
                       { "13"+" 是否医保" , t => t.是否医保},
                       { "14"+" 总费用" , t => t.总费用},
                       { "15"+" 自付费用" , t => t.自付费用}
                    };


                    foreach (var item in brb1)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header1.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex1 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[OUT_REG_INFO]";
                    var OUT_REG_INFO = connection.Query<OUT_REG_INFO>(sql).OrderBy(s => s.挂号序号).ToList();
                    for (int i = 0; i < OUT_REG_INFO.Count; i++)
                    {
                        var datarow = sheet1.CreateRow(rowIndex1);

                        foreach (var item in brb1)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(OUT_REG_INFO[i])?.ToString()) ? "" : item.Value.Invoke(OUT_REG_INFO[i])?.ToString());
                        }
                        rowIndex1++;
                    }
                    #endregion
                    #region 门诊诊断
                    var sheet2 = workbook.CreateSheet("门诊诊断");//创建工作表
                    var header2 = sheet2.CreateRow(0);//工作行
                    var brb2 = new Dictionary<string, Func<OUT_DIAG, object>>
                    {
                       { "0"+" 诊断序号" , t => t.诊断序号},
                       { "1"+" 医院诊断序号" , t => t.医院诊断序号},
                       { "2"+" 挂号序号" , t => t.挂号序号},
                       { "3"+" 医院挂号序号" , t => t.医院挂号序号},
                       { "4"+" 诊断编号" , t => t.诊断编号},
                       { "5"+" 诊断编码" , t => t.诊断编码},
                       { "6"+" 疾病名称" , t => t.疾病名称},
                       { "7"+" 诊断日期" , t => t.诊断日期},
                       { "8"+" 备注" , t => t.备注},
                       { "9"+" 创建机构" , t => t.创建机构}
                    };

                    foreach (var item in brb2)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header2.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex2 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[OUT_DIAG]";
                    var OUT_DIAG = connection.Query<OUT_DIAG>(sql).OrderBy(s => s.诊断序号).ToList();
                    for (int i = 0; i < OUT_DIAG.Count; i++)
                    {
                        var datarow = sheet2.CreateRow(rowIndex2);

                        foreach (var item in brb2)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(OUT_DIAG[i])?.ToString()) ? "" : item.Value.Invoke(OUT_DIAG[i])?.ToString());
                        }
                        rowIndex2++;
                    }
                    #endregion
                    #region 门诊处方
                    var sheet3 = workbook.CreateSheet("门诊处方");//创建工作表
                    var header3 = sheet3.CreateRow(0);//工作行
                    var brb3 = new Dictionary<string, Func<OUT_PRES, object>>
                    {
                       { "0"+" 处方编号" , t => t.处方编号},
                       { "1"+" 医院处方编号" , t => t.医院处方编号},
                       { "2"+" 挂号序号" , t => t.挂号序号},
                       { "3"+" 医院挂号序号" , t => t.医院挂号序号},
                       { "4"+" 组号" , t => t.组号},
                       { "5"+" 处方序号" , t => t.处方序号},
                       { "6"+" 处方时间" , t => t.处方时间},
                       { "7"+" 处方类型" , t => t.处方类型},
                       { "8"+" 药品代码" , t => t.药品代码},
                       { "9"+" 药品分类" , t => t.药品分类},
                       { "10"+" 药品通用名称" , t => t.药品通用名称},
                       { "11"+" 药品名称" , t => t.药品名称},
                       { "12"+" 药品剂型" , t => t.药品剂型},
                       { "13"+" 药品规格" , t => t.药品规格},
                       { "14"+" 药品产地" , t => t.药品产地},
                       { "15"+" 每次用量" , t => t.每次用量},
                       { "16"+" 用量单位" , t => t.用量单位},
                       { "17"+" 用法编码" , t => t.用法编码},
                       { "18"+" 给药方式" , t => t.给药方式},
                       { "19"+" 配药天数" , t => t.配药天数},
                       { "20"+" 配药单位" , t => t.配药单位},
                       { "21"+" 皮试结果" , t => t.皮试结果},
                       { "22"+" 用药备注" , t => t.用药备注},
                       { "23"+" 医保分类" , t => t.医保分类},
                       { "24"+" 创建机构" , t => t.创建机构}
                    };

                    foreach (var item in brb3)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header3.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex3 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[OUT_PRES]";
                    var OUT_PRES = connection.Query<OUT_PRES>(sql).OrderBy(s => s.处方编号).ToList();
                    for (int i = 0; i < OUT_PRES.Count; i++)
                    {
                        var datarow = sheet3.CreateRow(rowIndex3);

                        foreach (var item in brb3)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(OUT_PRES[i])?.ToString()) ? "" : item.Value.Invoke(OUT_PRES[i])?.ToString());
                        }
                        rowIndex3++;
                    }
                    #endregion
                    #region 门诊费用
                    var sheet4 = workbook.CreateSheet("门诊费用");//创建工作表
                    var header4 = sheet4.CreateRow(0);//工作行
                    var brb4 = new Dictionary<string, Func<OUT_FEE, object>>
                    {
                       { "0"+" 收费号" , t => t.收费号},
                       { "1"+" 上传收费号" , t => t.上传收费号},
                       { "2"+" 挂号序号" , t => t.挂号序号},
                       { "3"+" 医院挂号序号" , t => t.医院挂号序号},
                       { "4"+" 项目种类" , t => t.项目种类},
                       { "5"+" 上传费用代码" , t => t.上传费用代码},
                       { "6"+" 费用名称" , t => t.费用名称},
                       { "7"+" 单价" , t => t.单价},
                       { "8"+" 费用类别" , t => t.费用类别},
                       { "9"+" 数量" , t => t.数量},
                       { "10"+" 单位" , t => t.单位},
                       { "11"+" 金额" , t => t.金额},
                       { "12"+" 科室编码" , t => t.科室编码},
                       { "13"+" 科室名称" , t => t.科室名称},
                       { "14"+" 收费日期" , t => t.收费日期},
                       { "15"+" 创建机构" , t => t.创建机构},
                       { "16"+" 标准分类名称" , t => t.标准分类名称},
                       { "17"+" 药品产地" , t => t.药品产地},
                       { "18"+" 执行科室编码" , t => t.执行科室编码},
                       { "19"+" 执行科室名称" , t => t.执行科室名称}
                    };

                    foreach (var item in brb4)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header4.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex4 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[OUT_FEE]";
                    var OUT_FEE = connection.Query<OUT_FEE>(sql).OrderBy(s => s.收费号).ToList();
                    for (int i = 0; i < OUT_FEE.Count; i++)
                    {
                        var datarow = sheet4.CreateRow(rowIndex4);

                        foreach (var item in brb4)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(OUT_FEE[i])?.ToString()) ? "" : item.Value.Invoke(OUT_FEE[i])?.ToString());
                        }
                        rowIndex4++;
                    }
                    #endregion
                    #region 住院登记
                    var sheet5 = workbook.CreateSheet("住院登记");//创建工作表
                    var header5 = sheet5.CreateRow(0);//工作行
                    var brb5 = new Dictionary<string, Func<INPAT_REG_INFO, object>>
                    {
                       { "0"+" 住院序号" , t => t.住院序号},
                       { "1"+" 医院住院序号" , t => t.医院住院序号},
                       { "2"+" 病人编码" , t => t.病人编码},
                       { "3"+" 医院病人编号" , t => t.医院病人编号},
                       { "4"+" 上传入院科室" , t => t.上传入院科室},
                       { "5"+" 入院科室名称" , t => t.入院科室名称},
                       { "6"+" 病区名称" , t => t.病区名称},
                       { "7"+" 入院时间" , t => t.入院时间},
                       { "8"+" 出院时间" , t => t.出院时间},
                       { "9"+" 医保类型" , t => t.医保类型},
                       { "10"+" 身高" , t => t.身高},
                       { "11"+" 体重" , t => t.体重},
                       { "12"+" 入院情况" , t => t.入院情况},
                       { "13"+" 出院情况" , t => t.出院情况},
                       { "14"+" 标准一级诊断" , t => t.标准一级诊断},
                       { "15"+" 标准科室" , t => t.标准科室},
                       { "16"+" 创建机构" , t => t.创建机构},
                       { "17"+" 是否医保" , t => t.是否医保},
                       { "18"+" 腰围" , t => t.腰围},
                       { "19"+" 总费用" , t => t.总费用},
                       { "20"+" 自付费用" , t => t.自付费用},
                       { "21"+" 出院科室编码" , t => t.出院科室编码},
                       { "22"+" 出院科室名称" , t => t.出院科室名称},
                       { "23"+"  住院病人的来源" , t => t. 住院病人的来源}
                    };

                    foreach (var item in brb5)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header5.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex5 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[INPAT_REG_INFO]";
                    var INPAT_REG_INFO = connection.Query<INPAT_REG_INFO>(sql).OrderBy(s => s.住院序号).ToList();
                    for (int i = 0; i < INPAT_REG_INFO.Count; i++)
                    {
                        var datarow = sheet5.CreateRow(rowIndex5);

                        foreach (var item in brb5)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(INPAT_REG_INFO[i])?.ToString()) ? "" : item.Value.Invoke(INPAT_REG_INFO[i])?.ToString());
                        }
                        rowIndex5++;
                    }
                    #endregion
                    #region 住院诊断
                    var sheet6 = workbook.CreateSheet("住院诊断");//创建工作表
                    var header6 = sheet6.CreateRow(0);//工作行
                    var brb6 = new Dictionary<string, Func<INPAT_DIAG, object>>
                    {
                       { "0"+" 诊断序号" , t => t.诊断序号},
                       { "1"+" 医院住院序号" , t => t.医院住院序号},
                       { "2"+" 住院序号" , t => t.住院序号},
                       { "3"+" 医院住院序号" , t => t.医院住院序号},
                       { "4"+" 诊断编号" , t => t.诊断编号},
                       { "5"+" 编码" , t => t.编码},
                       { "6"+" 疾病名称" , t => t.疾病名称},
                       { "7"+" 备注" , t => t.备注},
                       { "8"+" 诊断类型" , t => t.诊断类型},
                       { "9"+" 诊断时间" , t => t.诊断时间},
                       { "10"+" 治愈状态" , t => t.治愈状态},
                       { "11"+" 创建机构" , t => t.创建机构}
                    };

                    foreach (var item in brb6)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header6.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex6 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[INPAT_DIAG]";
                    var INPAT_DIAG = connection.Query<INPAT_DIAG>(sql).OrderBy(s => s.诊断序号).ToList();
                    for (int i = 0; i < INPAT_DIAG.Count; i++)
                    {
                        var datarow = sheet6.CreateRow(rowIndex6);

                        foreach (var item in brb6)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(INPAT_DIAG[i])?.ToString()) ? "" : item.Value.Invoke(INPAT_DIAG[i])?.ToString());
                        }
                        rowIndex6++;
                    }
                    #endregion
                    #region 住院医嘱
                    var sheet7 = workbook.CreateSheet("住院医嘱");//创建工作表
                    var header7 = sheet7.CreateRow(0);//工作行
                    var brb7 = new Dictionary<string, Func<INPAT_ORDER, object>>
                    {
                       { "0"+" 医嘱序号" , t => t.医嘱序号},
                       { "1"+" 上传医嘱序号" , t => t.上传医嘱序号},
                       { "2"+" 住院序号" , t => t.住院序号},
                       { "3"+" 医院住院序号" , t => t.医院住院序号},
                       { "4"+" 医嘱类型" , t => t.医嘱类型},
                       { "5"+" 项目种类" , t => t.项目种类},
                       { "6"+" 费用代码" , t => t.费用代码},
                       { "7"+" 费用名称" , t => t.费用名称},
                       { "8"+" 皮试结果" , t => t.皮试结果},
                       { "9"+" 药品规格" , t => t.药品规格},
                       { "10"+" 每次剂量" , t => t.每次剂量},
                       { "11"+" 剂量单位" , t => t.剂量单位},
                       { "12"+" 用量个数" , t => t.用量个数},
                       { "13"+" 用量单位" , t => t.用量单位},
                       { "14"+" 药品用法" , t => t.药品用法},
                       { "15"+" 给药方式" , t => t.给药方式},
                       { "16"+" 配药数量" , t => t.配药数量},
                       { "17"+" 单价" , t => t.单价},
                       { "18"+" 医嘱天数" , t => t.医嘱天数},
                       { "19"+" 开始服药日期" , t => t.开始服药日期},
                       { "20"+" 结束服药日期" , t => t.结束服药日期},
                       { "21"+" 用药天数" , t => t.用药天数},
                       { "22"+" 备注" , t => t.备注},
                       { "23"+" 创建机构" , t => t.创建机构},
                    };

                    foreach (var item in brb7)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header7.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex7 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[INPAT_ORDER]";
                    var INPAT_ORDER = connection.Query<INPAT_ORDER>(sql).OrderBy(s => s.医嘱序号).ToList();
                    for (int i = 0; i < INPAT_ORDER.Count; i++)
                    {
                        var datarow = sheet7.CreateRow(rowIndex7);

                        foreach (var item in brb7)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(INPAT_ORDER[i])?.ToString()) ? "" : item.Value.Invoke(INPAT_ORDER[i])?.ToString());
                        }
                        rowIndex7++;
                    }
                    #endregion
                    #region 住院费用
                    var sheet8 = workbook.CreateSheet("住院费用");//创建工作表
                    var header8 = sheet8.CreateRow(0);//工作行
                    var brb8 = new Dictionary<string, Func<INPAT_FEE, object>>
                    {
                       { "0"+" 收费号" , t => t.收费号},
                       { "1"+" 医院收费序号" , t => t.医院收费序号},
                       { "2"+" 费用类别" , t => t.费用类别},
                       { "3"+" 住院序号" , t => t.住院序号},
                       { "4"+" 医院住院序号" , t => t.医院住院序号},
                       { "5"+" 项目种类" , t => t.项目种类},
                       { "6"+" 医院费用代码" , t => t.医院费用代码},
                       { "7"+" 费用名称" , t => t.费用名称},
                       { "8"+" 单价" , t => t.单价},
                       { "9"+" 数量" , t => t.数量},
                       { "10"+" 药量单位" , t => t.药量单位},
                       { "11"+" 金额" , t => t.金额},
                       { "12"+" 收费日期" , t => t.收费日期},
                       { "13"+" 科室编码" , t => t.科室编码},
                       { "14"+" 科室名称" , t => t.科室名称},
                       { "15"+" 创建机构" , t => t.创建机构},
                       { "16"+" 标准分类名称" , t => t.标准分类名称},
                       { "17"+" 药品产地" , t => t.药品产地},
                       { "18"+" 执行科室编码" , t => t.执行科室编码},
                       { "19"+" 执行科室名称" , t => t.执行科室名称}
                    };

                    foreach (var item in brb8)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header8.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex8 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[INPAT_FEE]";
                    var INPAT_FEE = connection.Query<INPAT_FEE>(sql).OrderBy(s => s.收费号).ToList();
                    for (int i = 0; i < INPAT_FEE.Count; i++)
                    {
                        var datarow = sheet8.CreateRow(rowIndex8);

                        foreach (var item in brb8)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(INPAT_FEE[i])?.ToString()) ? "" : item.Value.Invoke(INPAT_FEE[i])?.ToString());
                        }
                        rowIndex8++;
                    }
                    #endregion
                    #region 手术信息
                    var sheet9 = workbook.CreateSheet("手术信息");//创建工作表
                    var header9 = sheet9.CreateRow(0);//工作行
                    var brb9 = new Dictionary<string, Func<OPS_INFO, object>>
                    {
                       { "0"+" 手术编号" , t => t.手术编号},
                       { "1"+" 医院手术编号" , t => t.医院手术编号},
                       { "2"+" 住院序号" , t => t.住院序号},
                       { "3"+" 医院住院序号" , t => t.医院住院序号},
                       { "4"+" 医嘱序号" , t => t.医嘱序号},
                       { "5"+" 医院医嘱序号" , t => t.医院医嘱序号},
                       { "6"+" 医院费用编码" , t => t.医院费用编码},
                       { "7"+" 手术名称" , t => t.手术名称},
                       { "8"+" 术前诊断" , t => t.术前诊断},
                       { "9"+" 手术结果" , t => t.手术结果},
                       { "10"+" 手术等级" , t => t.手术等级},
                       { "11"+" 手术创口等级" , t => t.手术创口等级},
                       { "12"+" 手术开始时间" , t => t.手术开始时间},
                       { "13"+" 手术结束时间" , t => t.手术结束时间},
                       { "14"+" 科室编码" , t => t.科室编码},
                       { "15"+" 科室名称" , t => t.科室名称},
                       { "16"+" 愈合程度" , t => t.愈合程度},
                       { "17"+" 麻醉方式" , t => t.麻醉方式},
                       { "18"+" 择期手术" , t => t.择期手术},
                       { "19"+" 创建机构" , t => t.创建机构},
                       { "20"+" 手术操作编码" , t => t.手术操作编码},
                       { "21"+" 标准手术名称" , t => t.标准手术名称},
                       { "22"+" 标准手术操作编码" , t => t.标准手术操作编码}
                    };

                    foreach (var item in brb9)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header9.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex9 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[OPS_INFO]";
                    var OPS_INFO = connection.Query<OPS_INFO>(sql).OrderBy(s => s.手术编号).ToList();
                    for (int i = 0; i < OPS_INFO.Count; i++)
                    {
                        var datarow = sheet9.CreateRow(rowIndex9);

                        foreach (var item in brb9)
                        {
                            var cell = datarow.CreateCell(int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" "))));
                            cell.SetCellValue(string.IsNullOrEmpty(item.Value.Invoke(OPS_INFO[i])?.ToString()) ? "" : item.Value.Invoke(OPS_INFO[i])?.ToString());
                        }
                        rowIndex9++;
                    }
                    #endregion
                    #region 检查信息
                    var sheet10 = workbook.CreateSheet("检查信息");//创建工作表
                    var header10 = sheet10.CreateRow(0);//工作行
                    var brb10 = new Dictionary<string, Func<EXEC_REPORT, object>>
                    {
                       { "0"+" 报告单编号" , t => t.报告单编号},
                       { "1"+" 医院报告编号" , t => t.医院报告编号},
                       { "2"+" 病人序号" , t => t.病人序号},
                       { "3"+" 医院病人序号" , t => t.医院病人序号},
                       { "4"+" 医嘱序号" , t => t.医嘱序号},
                       { "5"+" 医院医嘱序号" , t => t.医院医嘱序号},
                       { "6"+" 简要病史" , t => t.简要病史},
                       { "7"+" 项目名称" , t => t.项目名称},
                       { "8"+" 诊断表现" , t => t.诊断表现},
                       { "9"+" 诊断结论" , t => t.诊断结论},
                       { "10"+" 报告时间" , t => t.报告时间},
                       { "11"+" 患者来源" , t => t.患者来源},
                       { "12"+" 创建机构" , t => t.创建机构}
                    };

                    foreach (var item in brb10)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header10.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex10 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[EXEC_REPORT]";
                    var EXEC_REPORT = connection.Query<EXEC_REPORT>(sql).OrderBy(s => s.报告单编号).ToList();
                    for (int i = 0; i < EXEC_REPORT.Count; i++)
                    {
                        var datarow = sheet10.CreateRow(rowIndex10);

                        foreach (var item in brb10)
                        {
                            int id = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                            var cell = datarow.CreateCell(id);
                            cell.SetCellValue(id == 11 ? (string.IsNullOrEmpty(item.Value.Invoke(EXEC_REPORT[i])?.ToString()) ? "" : item.Value.Invoke(EXEC_REPORT[i])?.ToString()) == "1" ? "门诊" : "住院" : string.IsNullOrEmpty(item.Value.Invoke(EXEC_REPORT[i])?.ToString()) ? "" : item.Value.Invoke(EXEC_REPORT[i])?.ToString());

                        }
                        rowIndex10++;
                    }
                    #endregion
                    #region 化验信息
                    var sheet11 = workbook.CreateSheet("化验信息");//创建工作表
                    var header11 = sheet11.CreateRow(0);//工作行
                    var brb11 = new Dictionary<string, Func<ASSAY_REPORT, object>>
                    {
                       { "0"+" 化验报告编码" , t => t.化验报告编码},
                       { "1"+" 医院报告编码" , t => t.医院报告编码},
                       { "2"+" 病人序号" , t => t.病人序号},
                       { "3"+" 医院病人序号" , t => t.医院病人序号},
                       { "4"+" 报告时间" , t => t.报告时间},
                       { "5"+" 标本类型" , t => t.标本类型},
                       { "6"+" 化验项目代码" , t => t.化验项目代码},
                       { "7"+" 项目名称" , t => t.项目名称},
                       { "8"+" 项目e文名" , t => t.项目e文名},
                       { "9"+" 结构单位" , t => t.结构单位},
                       { "10"+" 结果" , t => t.结果单位},
                       { "11"+" 参考范围" , t => t.参考范围},
                       { "12"+" 结果状态" , t => t.结果状态},
                       { "13"+" 患者来源" , t => t.患者来源},
                       { "14"+" 创建机构" , t => t.创建机构}
                    };

                    foreach (var item in brb11)
                    {
                        int key = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                        var name = item.Key.Replace(key + " ", "");
                        header11.CreateCell(key).SetCellValue(name);
                    }
                    var rowIndex11 = 1;
                    sql = $"SELECT * FROM [数据导出].[dbo].[ASSAY_REPORT]";
                    var ASSAY_REPORT = connection.Query<ASSAY_REPORT>(sql).OrderBy(s => s.化验报告编码).ToList();
                    for (int i = 0; i < ASSAY_REPORT.Count; i++)
                    {
                        var datarow = sheet11.CreateRow(rowIndex11);

                        foreach (var item in brb11)
                        {
                            int id = int.Parse(item.Key.Substring(0, item.Key.LastIndexOf(" ")));
                            var cell = datarow.CreateCell(id);
                            cell.SetCellValue(id == 13 ? (string.IsNullOrEmpty(item.Value.Invoke(ASSAY_REPORT[i])?.ToString()) ? "" : item.Value.Invoke(ASSAY_REPORT[i])?.ToString()) == "1" ? "门诊" : "住院" : string.IsNullOrEmpty(item.Value.Invoke(ASSAY_REPORT[i])?.ToString()) ? "" : item.Value.Invoke(ASSAY_REPORT[i])?.ToString());

                        }
                        rowIndex11++;
                    }
                    #endregion
                    workbook.Write(fs);
                }
                using (var stream = new FileStream(newFile, FileMode.Open))
                {
                    stream.CopyTo(memory);
                }
                memory.Position = 0;
            }
            catch (Exception e)
            {

                throw e;
            }

            return 下载地址;
        }
        #endregion
        #region 导入excel多个表格数据
        /// <summary>
        /// 将excel中多sheet表的数据导入到DataTable中
        /// </summary>
        /// <param name="file">文件名称</param>
        /// <param name="WebRootPath">路径</param>
        /// <param name="sheetnumber">excel工作薄sheet的位置</param>
        /// <param name="isFirstRowColumn">第一行是否是DataTable的列名</param>
        /// <returns>返回的DataTable</returns>
        public string ExcelToDataTables(IFormFile file)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);

            var jieguo = "成功";
            var sql = "";
            var num = 0;
            try
            {
                sql = @$"truncate table [数据导出].[dbo].[ASSAY_REPORT]
                                 truncate table [数据导出].[dbo].[EXEC_REPORT]
                                 truncate table [数据导出].[dbo].[INPAT_DIAG]
                                 truncate table [数据导出].[dbo].[INPAT_FEE]
                                 truncate table [数据导出].[dbo].[INPAT_ORDER]
                                 truncate table [数据导出].[dbo].[INPAT_REG_INFO]
                                 truncate table [数据导出].[dbo].[OPS_INFO]
                                 truncate table [数据导出].[dbo].[OUT_DIAG]
                                 truncate table [数据导出].[dbo].[OUT_FEE]
                                 truncate table [数据导出].[dbo].[OUT_PRES]
                                 truncate table [数据导出].[dbo].[OUT_REG_INFO]
                                 truncate table [数据导出].[dbo].[PUB_PATIENT]";
                connection.Execute(sql);

                for (int i = 0; i <= 11; i++)
                {
                    var a = "\"}";
                    num = i;
                    var date = ExcelToDataTable(file, i, true);

                    if (date != null)
                    {

                        if (i == 0)//病人表
                        {
                            var dates = JsonConvert.DeserializeObject<List<PUB_PATIENT>>(date);
                            foreach (var item in dates)
                            {
                                sql = @$"insert into [数据导出].[dbo].[PUB_PATIENT]
                                      ([医院病人编码],[性别],[出生日期],[标准地域],[民族],[国籍],[创建机构] ,[病人主索引])  
                                    select '{item.医院病人编码}','{item.性别}','{item.出生日期}','{item.标准地域}','{item.民族}','{item.国籍}','{item.创建机构}', '{item.病人主索引}'";
                                connection.Execute(sql);
                            }
                        }
                        if (i == 1)//门诊登记
                        {
                            var dates = JsonConvert.DeserializeObject<List<OUT_REG_INFO>>(date);
                            foreach (var item in dates)
                            {
                                sql = @$"insert into [数据导出].[dbo].[OUT_REG_INFO]
                                      ([医院挂号序号],[病人编码],[医院病人编号] ,[挂号时间],[医院挂号科室],[医院科室名称],[医保类型]
                                        ,[急诊_门诊],[标准一级诊断],[标准科室],[创建机构],[上传时间],[是否医保],[总费用],[自付费用])  
                                   select '{item.医院挂号序号}','{item.病人编码}','{item.医院病人编码}','{item.挂号时间}','{item.医院挂号科室}','{item.医院科室名称}','{item.医保类型}',
                                   '{item.急诊_门诊}','{item.标准一级诊断}','{item.标准科室}','{item.创建机构}','{item.上传时间}','{item.是否医保}','{item.总费用}','{item.自付费用}'";
                                connection.Execute(sql);
                            }
                        }
                        //if (i == 2)//门诊诊断
                        //{
                        //    var dates = JsonConvert.DeserializeObject<List<OUT_DIAG>>(date);
                        //    foreach (var item in dates)
                        //    {
                        //        sql = @$"insert into [数据导出].[dbo].[OUT_DIAG]
                        //              ([医院诊断序号],[挂号序号],[医院挂号序号],[诊断编号],[诊断编码],[疾病名称],[诊断日期],[备注],[创建机构])  
                        //            select '{item["医院诊断序号"]}','{item["挂号序号"]}','{item["医院挂号序号"]}',
                        //                   '{item["诊断编号"]}','{item["诊断编码"]}','{item["疾病名称"]}',
                        //                   '{item["诊断日期"]}', '{item["备注"]}', '{item["创建机构"]}'";
                        //        connection.Execute(sql);
                        //    }
                        //}
                        //if (i == 3)//门诊处方
                        //{
                        //    foreach (DataRow item in date.Rows)
                        //    {
                        //        sql = @$"insert into [数据导出].[dbo].[OUT_PRES]
                        //              ([医院处方编号],[挂号序号],[医院挂号序号],[组号],[处方序号],[处方时间],[处方类型],[药品代码],[药品分类],[药品通用名称],[药品名称],[药品剂型],[药品规格],[药品产地],[每次用量],[用量单位],[用法编码],[给药方式],[配药天数],[配药数量],[配药单位],[皮试结果],[医保分类],[创建机构])  
                        //            select '{item["医院处方编号"]}','{item["挂号序号"]}','{item["医院挂号序号"]}',
                        //                   '{item["组号"]}','{item["处方序号"]}','{item["处方时间"]}',
                        //                   '{item["处方类型"]}','{item["药品代码"]}','{item["药品分类"]}', 
                        //                   '{item["药品通用名称"]}','{item["药品名称"]}','{item["药品剂型"]}',
                        //                   '{item["药品规格"]}','{item["药品产地"]}','{item["每次用量"]}',
                        //                   '{item["用量单位"]}','{item["用法编码"]}','{item["给药方式"]}',
                        //                   '{item["配药天数"]}','{item["配药数量"]}','{item["配药单位"]}',
                        //                   '{item["皮试结果"]}','{item["医保分类"]}','{item["创建机构"]}'";
                        //        connection.Execute(sql);
                        //    }
                        //}
                        //if (i == 4) //门诊费用
                        //{
                        //    foreach (DataRow item in date.Rows)
                        //    {
                        //        sql = @$"insert into [数据导出].[dbo].[OUT_FEE] 
                        //            ([上传收费号],[挂号序号],[医院挂号序号],[项目种类],[上传费用代码],[费用名称],[单价],[费用类别],[数量],
                        //             [单位],[金额],[科室编码],[科室名称],[收费日期],[创建机构],[标准分类名称],[药品产地],[执行科室编码],[执行科室名称])  
                        //            select '{item["上传收费号"]}','{item["挂号序号"]}','{item["医院挂号序号"]}','{item["项目种类"]}','{item["上传费用代码"]}','{item["费用名称"]}',
                        //                   '{item["单价"]}','{item["费用类别"]}','{item["数量"]}','{item["单位"]}','{item["金额"]}','{item["科室编码"]}','{item["科室名称"]}',
                        //                   '{item["收费日期"]}','{item["创建机构"]}','{item["标准分类名称"]}','{item["药品产地"]}','{item["执行科室编码"]}','{item["执行科室名称"]}'";
                        //        connection.Execute(sql);
                        //    }
                        //}
                        //if (i == 5) //住院登记
                        //{
                        //    foreach (DataRow item in date.Rows)
                        //    {
                        //        sql = @$"insert into [数据导出].[dbo].[INPAT_REG_INFO]
                        //            ([医院住院序号] ,[病人编码],[医院病人编码],[上传入院科室],[入院科室名称],[病区名称],[入院时间],[出院时间]
                        //            ,[医保类型],[身高],[体重],[入院情况],[出院情况],[标准一级诊断],[标准科室],[创建机构],[是否医保],[腰围]
                        //            ,[总费用],[自付费用],[出院科室编码],[出院科室名称],[住院病人的来源])  
                        //            select '{item["医院住院序号"]}','{item["病人编码"]}','{item["医院病人编码"]}','{item["上传入院科室"]}','{item["入院科室名称"]}','{item["病区名称"]}',
                        //                   '{item["入院时间"]}','{item["出院时间"]}','{item["医保类型"]}','{item["身高"]}','{item["体重"]}','{item["入院情况"]}','{item["出院情况"]}',
                        //                   '{item["标准一级诊断"]}','{item["标准科室"]}','{item["创建机构"]}','{item["是否医保"]}','{item["腰围"]}','{item["总费用"]}',
                        //                   '{item["自付费用"]}','{item["出院科室编码"]}','{item["出院科室名称"]}','{item["住院病人的来源"]}'";
                        //        connection.Execute(sql);
                        //    }
                        //}
                        //if (i == 6) //住院诊断
                        //{
                        //    foreach (DataRow item in date.Rows)
                        //    {
                        //        sql = @$"insert into [数据导出].[dbo].[INPAT_REG_INFO]
                        //            ([医院住院序号] ,[病人编码],[医院病人编码],[上传入院科室],[入院科室名称],[病区名称],[入院时间],[出院时间]
                        //            ,[医保类型],[身高],[体重],[入院情况],[出院情况],[标准一级诊断],[标准科室],[创建机构],[是否医保],[腰围]
                        //            ,[总费用],[自付费用],[出院科室编码],[出院科室名称],[住院病人的来源])  
                        //            select '{item["医院住院序号"]}','{item["病人编码"]}','{item["医院病人编码"]}','{item["上传入院科室"]}','{item["入院科室名称"]}','{item["病区名称"]}',
                        //                   '{item["入院时间"]}','{item["出院时间"]}','{item["医保类型"]}','{item["身高"]}','{item["体重"]}','{item["入院情况"]}','{item["出院情况"]}',
                        //                   '{item["标准一级诊断"]}','{item["标准科室"]}','{item["创建机构"]}','{item["是否医保"]}','{item["腰围"]}','{item["总费用"]}',
                        //                   '{item["自付费用"]}','{item["出院科室编码"]}','{item["出院科室名称"]}','{item["住院病人的来源"]}'";
                        //        connection.Execute(sql);
                        //    }
                        //}
                        if (i == 7) //住院医嘱
                        {

                        }
                        if (i == 8) //住院费用
                        {

                        }
                        if (i == 9) //手术信息
                        {

                        }
                        if (i == 10) //检查信息
                        {

                        }
                        if (i == 11) //化验信息
                        {

                        }

                    }

                }
            }
            catch (Exception e)
            {
                jieguo = @$"失败   错误{num}：" + e.ToString();
            }

            return jieguo;
        }

        /// <summary>   
        /// Datatable转换为Json 
        /// </summary>      
        /// <param name="dt">Datatable对象</param>
        /// <returns>Json字符串</returns>    
        public static string ToJson(DataTable dt)
        {
            StringBuilder jsonString = new StringBuilder();
            jsonString.Append("[");
            DataRowCollection drc = dt.Rows;
            for (int i = 0; i < drc.Count; i++)
            {
                jsonString.Append("{");
                for (int j = 0; j < dt.Columns.Count; j++)
                {
                    string strKey = dt.Columns[j].ColumnName;
                    string strValue = "\"" + drc[i][j].ToString() + "\"";
                    Type type = dt.Columns[j].DataType;
                    jsonString.Append("\"" + strKey + "\":");
                    strValue = String.Format(strValue, type);
                    if (j < dt.Columns.Count - 1)
                    {
                        jsonString.Append(strValue + ",");
                    }
                    else
                    {
                        jsonString.Append(strValue);
                    }
                }
                jsonString.Append("},");
            }
            jsonString.Remove(jsonString.Length - 1, 1);
            jsonString.Append("]");
            return jsonString.ToString();
        }

        public string ExcelToDataTable(IFormFile file, int sheetnumber, bool isFirstRowColumn, int startRow = 0)
        {
            IWorkbook workbook = null;
            DbConnection connection = new SqlConnection(_configConnectionString);
            ISheet sheet = null;
            DataTable data = new DataTable();
            StreamReader reader = new StreamReader(file.OpenReadStream());//打开读取文件流
            string content = reader.ReadToEnd();//读取文件流末尾字符
            string name = file.FileName;
            string filename = "";

            filename = Path.Combine("E:/代码/queryPlatform/api/QueryPlatform.Api/bin/Debug/netcoreapp3.1/wwwroot/export", name);
            try
            {
                try
                {
                    FileStream fs = new FileStream(filename, FileMode.Open, FileAccess.Read);
                    if (filename.IndexOf(".xlsx") > 0) // 2007版本
                        workbook = new XSSFWorkbook(fs);
                    else if (filename.IndexOf(".xls") > 0) // 2003版本
                        workbook = new HSSFWorkbook(fs);
                }
                catch (Exception e)
                {
                    throw new Exception("未找到该文件!请确保为导出时的名称!");
                }
                sheet = workbook.GetSheetAt(sheetnumber);

                if (sheet != null)
                {
                    IRow firstRow = sheet.GetRow(startRow);
                    int cellCount = firstRow.LastCellNum; //一行最后一个cell的编号 即总的列数

                    if (isFirstRowColumn)
                    {
                        for (int i = firstRow.FirstCellNum; i < cellCount; ++i)
                        {
                            ICell cell = firstRow.GetCell(i);
                            if (cell != null)
                            {
                                string cellValue = cell.ToString();

                                if (cellValue != null)
                                {
                                    DataColumn column = new DataColumn(cellValue);
                                    data.Columns.Add(column);
                                }
                            }
                        }
                        if (startRow == 0)
                        {
                            startRow = sheet.FirstRowNum + 1;
                        }
                        else
                        {
                            startRow += 1;
                        }
                    }
                    else
                    {
                        if (startRow == 0)
                        {
                            startRow = sheet.FirstRowNum;
                        }
                    }

                    //最后一列的标号
                    int rowCount = sheet.LastRowNum;
                    for (int i = startRow; i <= rowCount; ++i)
                    {
                        IRow row = sheet.GetRow(i);
                        // if (row == null || row.FirstCellNum < 0 || (string.IsNullOrWhiteSpace(row.GetCell(0).Value().ToStringWDV()) && string.IsNullOrWhiteSpace(row.GetCell(1).Value().ToStringWDV()) && string.IsNullOrWhiteSpace(row.GetCell(2).Value().ToStringWDV()))) break; //没有数据的行默认是null　　　　　　　
                        DataRow dataRow = data.NewRow();
                        for (int j = row.FirstCellNum; j < cellCount; ++j)
                        {
                            if (row.GetCell(j) != null) ; //同理，没有数据的单元格都默认是null
                            dataRow[j] = row.GetCell(j);
                        }
                        data.Rows.Add(dataRow);
                    }
                }

                ////插入数据库
                //var sql = @$"";
                //var que = data.Query<string>(sql).FirstOrDefault();

                return ToJson(data);

            }
            catch (Exception ex)
            {
                throw new Exception("Exception: " + ex.Message);
            }
        }
        #endregion



        public List<string> ceshi()
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = @$"SELECT  [zyh]  ,[jws]  FROM [呼吸科20221225].[dbo].[疾病清洗aaaa]  ";
            var errs = new List<string>();
            var mailboxs = connection.Query<aaaa>(sql, commandTimeout: 60 * 60 * 5);
            if (mailboxs.Any())
            {
                foreach (var item in mailboxs)
                {
                    try
                    {
                        var obj = JsonConvert.DeserializeObject<abc>(item.jws);
                        sql = @$" insert into  [呼吸科20221225].[dbo].[疾病JOSN解析后](zyh, 疾病史, 传染病史, 手术史外伤史, 过敏史, 重要药物应用史, 预防接种史, 输血史)
                                      select '{item.zyh.Replace("'", "")}', '{obj.疾病史.Replace("'", "")}', '{obj.传染病史.Replace("'", "")}', 
'{obj.手术史外伤史.Replace("'", "")}', '{obj.过敏史.Replace("'", "")}', '{obj.重要药物应用史.Replace("'", "")}', '{obj.预防接种史.Replace("'", "")}', '{obj.输血史}';";
                        connection.Execute(sql);

                    }
                    catch
                    {
                        errs.Add(item.zyh);
                    }
                }
            }
            return errs;
        }


        public List<string> city_hosLevel_hosType(string type)
        {
            var dbs = "SELECT city,left(hosLevel,1)hosLevel,hosType FROM [DB_SV_Data_Config].[dbo].[SYS_Hospital] where isnull([ExecOpenLink],'')!='' and isnull([ExecDatabase],'')!=''";
            var hoss = Connection(156).Query<SYS_Hospital>(dbs);
            if (type == "city")
            {
                return hoss.Select(s => s.City.Replace(" ","")).Distinct().ToList();
            }
            else if (type == "hosLevel")
            {
                return hoss.Select(s => s.HosLevel.Replace(" ", "")).Distinct().ToList();
            }
            else if (type == "hosType")
            {
                return hoss.Select(s => s.HosType.Replace(" ", "")).Distinct().ToList();
            }
            return null;
        }

        /// <summary>
        /// 游标
        /// </summary>
        /// <returns></returns>
        public List<string> Cursor(CursorModel model)
        {
            var dbs = "SELECT ExecOpenLink ,ExecDatabase FROM [DB_SV_Data_Config].[dbo].[SYS_Hospital] where isnull([ExecOpenLink],'')!='' and isnull([ExecDatabase],'')!=''";
            List<string> Return = new List<string>();
            if (string.IsNullOrEmpty(model.ExecuteSql) || string.IsNullOrEmpty(model.TableName)) Return.Add("请填写流水库表名和待执行sql！");
            Return.Add("医院区域：" + (string.IsNullOrEmpty(model.City) ? "全部" : model.City));
            Return.Add("医院等级：" + (string.IsNullOrEmpty(model.HosLevel) ? "全部" : model.HosLevel));
            Return.Add("医院类型：" + (string.IsNullOrEmpty(model.HosType) ? "全部" : model.HosType));
            if (!string.IsNullOrEmpty(model.City)) dbs = dbs + $" and City like '%{model.City}%'";
            if (!string.IsNullOrEmpty(model.HosLevel)) dbs = dbs + $" and HosLevel like '%{model.HosLevel}%'";
            if (!string.IsNullOrEmpty(model.HosType)) dbs = dbs + $" and HosType like '%{model.HosType}%'";
            Return.Add("ExecuteSql：" + model.ExecuteSql);
            var hoss = Connection(156).Query<SYS_Hospital>(dbs);
            Return.Add("需执行医院数：" + hoss.Count());

            //建表
            var _sys = hoss.FirstOrDefault();
            服务器 fwq = Connection(181).Query<服务器>($"SELECT [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{_sys.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", _sys.ExecOpenLink, _sys.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
            var json = new SqlConnection(msConnectionString).Query(model.ExecuteSql.Replace("@Name", _sys.ExecDatabase)).ToJson();
            JArray jsonArray = JArray.Parse(json);
            var CreateTable = $"CREATE TABLE [SV_Cursor].[dbo].[{model.TableName}](";
            var insertInto = $"insert into [192.168.18.181].[SV_Cursor].[dbo].[{model.TableName}](";
            if (jsonArray.Count > 0)
            {
                JObject jsonObject = (JObject)jsonArray[0];
                List<string> propertyNames = new List<string>();
                foreach (JProperty property in jsonObject.Properties())
                {
                    CreateTable = CreateTable + property.Name + $" [nvarchar](max) NULL,";
                    insertInto = insertInto + property.Name + $",";
                }
                CreateTable = CreateTable + ")";
                insertInto = insertInto.Substring(0, insertInto.Length - 1) + ")";
                Connection(181).Execute(CreateTable);
            }

            //执行
            foreach (var hos in hoss)
            {
                var ExecSql = "";
                fwq = Connection(181).Query<服务器>($"SELECT [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
                msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
                try
                {
                    ExecSql = insertInto + model.ExecuteSql.Replace("@Name", hos.ExecDatabase);
                    new SqlConnection(msConnectionString).Execute(ExecSql);
                }
                catch (Exception)
                {
                    Return.Add($"执行状态：执行失败,服务器地址：{hos.ExecOpenLink},数据库名称：{hos.ExecDatabase},ExecuteSql：{ExecSql}");
                }
            }
            Return.Add("执行结束");
            return Return;
        }
    }





}