﻿using Dapper;
using Dapper.Contrib.Extensions;
using Microsoft.Data.SqlClient;
using QueryPlatform.Api.Infrastructure.Modules;
using StackExchange.Profiling;
using StackExchange.Profiling.Data;
using System.Collections.Generic;
using System.Data.Common;

namespace QueryPlatform.Api.Infrastructure.Queries
{
    public class UserQueries
    {
        private readonly string _connectionString;
        public UserQueries(string connectionString)
        {
            _connectionString = connectionString;
        }
        public SYS_USER GetUserByAccount(string account, int id)
        {
            using (DbConnection connection = new ProfiledDbConnection(new SqlConnection(_connectionString), MiniProfiler.Current))
            {
                return connection.QueryFirstOrDefault<SYS_USER>("SELECT * FROM SYS_USER WHERE LOGIN=@account AND IsDelete=0 and id <>" + id, new { account });
            }
        }
        public IEnumerable<SYS_USER> GetUsers(string realname)
        {
            using (DbConnection connection = new ProfiledDbConnection(new SqlConnection(_connectionString), MiniProfiler.Current))
            {
                return connection.Query<SYS_USER>("SELECT * FROM SYS_USER WHERE isdelete=0 and realname like '%" + realname + "%'");
            }
        }
        public SYS_USER GetUserById(int userId)
        {
            using (DbConnection connection = new ProfiledDbConnection(new SqlConnection(_connectionString), MiniProfiler.Current))
            {
                return connection.Get<SYS_USER>(userId);
            }
        }
    }
}
