﻿using Dapper.Contrib.Extensions;
using Microsoft.Data.SqlClient;
using QueryPlatform.Api.Infrastructure.Modules;
using QueryPlatform.Api.Infrastructure.Request;
using StackExchange.Profiling;
using StackExchange.Profiling.Data;
using System;
using System.Data.Common;

namespace QueryPlatform.Api.Infrastructure.Queries
{
    public class UserStorage
    {
        private readonly string _connectionString;

        public UserStorage(string connectionString)
        {
            this._connectionString = connectionString;
        }

        public SYS_USER Add(UserRequest request)
        {
            using (DbConnection connection = new ProfiledDbConnection(new SqlConnection(_connectionString), MiniProfiler.Current))
            {
                var user = new SYS_USER
                {
                    CreateDate = DateTime.Now,
                    Login = request.Login,
                    Password = request.Password,
                    RealName = request.RealName,
                    States = request.States,
                    IsDelete = false,
                };

                user.id = (int)connection.Insert(user);

                return user;
            }
        }

        /// <summary>
        /// 修改密码
        /// </summary> 
        /// <returns></returns>
        public SYS_USER Update(UserRequest request)
        {
            using (DbConnection connection = new ProfiledDbConnection(new SqlConnection(_connectionString), MiniProfiler.Current))
            {
                var user = connection.Get<SYS_USER>(request.ID);
                if (user == null)
                    throw new DomainException("账号不存在");
                if (request.Password != "" && request.Password != null)
                {
                    user.Password = request.Password;
                }
                user.Login = request.Login;
                user.RealName = request.RealName;
                user.States = request.States;
                if (!connection.Update(user))
                    throw new DomainException("更新用户信息失败");
                return user;
            }
        }

        /// <summary>
        /// 修改用户信息
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="delete"></param>
        /// <param name="reset"></param>
        /// <returns></returns>
        public SYS_USER Update(long userId, bool? delete = null, bool? reset = null, bool? disable = null)
        {
            using (DbConnection connection = new ProfiledDbConnection(new SqlConnection(_connectionString), MiniProfiler.Current))
            {
                var user = connection.Get<SYS_USER>(userId);
                if (user == null)
                    throw new DomainException("账号不存在");

                if (delete.HasValue)
                    user.IsDelete = delete.Value;
                if (reset.HasValue)
                    user.Password = "123456";
                if (disable.HasValue)
                    user.IsDisable = disable.Value;
                if (!connection.Update(user))
                    throw new DomainException("更新用户信息失败");

                return user;
            }
        }
    }
}
