using Autofac.Extensions.DependencyInjection;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Microsoft.ML;
using Microsoft.ML.Data;
using Serilog;
using System;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;
using Ude;
using ZXing;
using ZXing.Common;

namespace QueryPlatform.Api
{
    public class Program
    {
        static Program()
        {
            string env = Environment.GetEnvironmentVariable("ASPNETCORE_ENVIRONMENT");
            BaseDirectory = AppDomain.CurrentDomain.BaseDirectory;
            Configuration = new ConfigurationBuilder()
                .SetBasePath(BaseDirectory)
                .AddJsonFile($"appsettings.json", optional: false, reloadOnChange: true)
                .AddJsonFile($"appsettings.{env}.json", optional: true, reloadOnChange: true)
                .AddJsonFile($"secret.json", optional: true, reloadOnChange: true)
                .AddXmlFile($"overview.xml", true, true)
                .AddEnvironmentVariables()
                .Build();
        }

        public static IConfiguration Configuration { get; }
        public static string BaseDirectory { get; }
     
  
        // ʽ
        static Encoding DetectEncoding(Stream stream)
        {
            CharsetDetector detector = new CharsetDetector();
            detector.Feed(stream);
            detector.DataEnd();
            string encodingName = detector.Charset;
            return Encoding.GetEncoding(encodingName);
        }
        public static void Main(string[] args)
        {

            //// ML.NET
            //var mlContext = new MLContext();

            //// ׼
            //var trainingData = LoadData();

            //// ͱǩ
            //var dataView = mlContext.Data.LoadFromEnumerable<HouseData>(trainingData);

            //// ģ͹ܵ
            //var pipeline = mlContext.Transforms.Concatenate("Features", "Size")
            //    .Append(mlContext.Regression.Trainers.Sdca(labelColumnName: "Price"));

            //// ѵģ
            //Console.WriteLine(DateTime.Now);
            //var model = pipeline.Fit(dataView);
            //Console.WriteLine(DateTime.Now);
            //// ʹģͽԤ
            //var predictionEngine = mlContext.Model.CreatePredictionEngine<HouseData, PredictionResult>(model);
            //var prediction = predictionEngine.Predict(new HouseData { Size = 2000 });

            //// ӡԤ
            //Console.WriteLine($"Predicted price for a house with 2000 sqft: {prediction.Price}");

            //Console.ReadLine();

            Log.Logger = CreateSerilogLogger();

            Log.Information("Starting web host");
            CreateHostBuilder(args).Build().Run();
        }



        class HouseData
        {
            [LoadColumn(0)]
            public float Size { get; set; }
            [LoadColumn(1)]
            public float Price { get; set; }
        }

        // Ԥṹ
        class PredictionResult
        {
            public float Price { get; set; }
        }

        // 
        private static HouseData[] LoadData()
        {
            // ʵпܴļݿ
            return new HouseData[]
            {
                new HouseData { Size = 1000, Price = 300000 },
                new HouseData { Size = 1500, Price = 400000 },
                new HouseData { Size = 2000, Price = 500000 },
                new HouseData { Size = 2500, Price = 600000 },
                new HouseData { Size = 3000, Price = 700000 },
            };
        }

        public static IHostBuilder CreateHostBuilder(string[] args)
        {
            var urls = Configuration.GetValue("ListenUrls", "http://*:56900");

            return Host.CreateDefaultBuilder(args)
                .UseServiceProviderFactory(new AutofacServiceProviderFactory())
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder
                        .UseUrls(urls.Split(','))
                        .UseStartup<Startup>();
                })
                .ConfigureAppConfiguration((context, config) =>
                {
                    config.AddConfiguration(Configuration);
                })
                .UseContentRoot(BaseDirectory)
                .UseSerilog();
        }

        private static Serilog.ILogger CreateSerilogLogger()
        {
            var basePath = Path.Combine(BaseDirectory, "logs");
            return new LoggerConfiguration()
                .ReadFrom.Configuration(Configuration)
                //.MinimumLevel.Verbose()
                .Enrich.FromLogContext()
                .WriteTo.Console()
                .WriteTo.File($"{basePath}\\.log", rollingInterval: RollingInterval.Day, retainedFileCountLimit: null)
                .CreateLogger();
        }
    }
}
