﻿using System;
using System.Collections.Generic;

public class ReportData
{
    public ReportData()
        : this("")
    {

    }

    public ReportData(string title)
    {
        Title = title;
    }

    /// <summary>
    /// 
    /// </summary>
    public Nullable<long> ChartType { get; set; }

    /// <summary>
    /// 报表标题
    /// </summary>
    public string Title { get; set; }

    /// <summary>
    /// X轴标题
    /// </summary>
    public string XTitle { get; set; }

    /// <summary>
    /// X轴单位
    /// </summary>
    public string XUnit { get; set; }

    /// <summary>
    /// Y轴标题
    /// </summary>
    public string YTitle { get; set; }

    /// <summary>
    /// Y轴单位
    /// </summary>
    public string YUnit { get; set; }

    /// <summary>
    /// 值标题
    /// </summary>
    public string VTitle { get; set; }

    /// <summary>
    /// 值单位
    /// </summary>
    public string VUnit { get; set; }

    /// <summary>
    /// name标题
    /// </summary>
    public string NTitle { get; set; }

    /// <summary>
    /// name单位
    /// </summary>
    public string NUnit { get; set; }

    /// <summary>
    /// 图表说明
    /// </summary>
    public string Formula { get; set; }

    /// <summary>
    /// 1表示需要进行小于百分2的类型进行合并
    /// </summary>
    public Nullable<long> DataType { get; set; }

    /// <summary>
    /// 图标value过滤执值
    /// </summary>
    public Nullable<decimal> FilterValue { get; set; }

    /// <summary>
    /// 图表数据
    /// </summary>
    public IEnumerable<ChartData> ChartData { get; set; } = new List<ChartData>();
}

/// <summary>
/// 图表
/// </summary>

public class ChartData
{
    /// <summary>
    /// X轴内容
    /// </summary>
    public string X { get; set; }
    /// <summary>
    /// Y轴内容
    /// </summary>
    public string Y { get; set; }
    /// <summary>
    /// 分类
    /// </summary>
    public string Name { get; set; }
    /// <summary>
    /// 值
    /// </summary>
    public Double Value { get; set; }

    /// <summary>
    /// 总量
    /// </summary>
    public Double? Total { get; set; }
    /// <summary>
    /// ChartData 类型标签
    /// </summary>
    public string Type { get; set; }
}

