﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;
using QueryPlatform.Api.Infrastructure;
using QueryPlatform.Api.Infrastructure.Queries;
using QueryPlatform.Api.Infrastructure.Request;
using QueryPlatform.Infra;
using System;
using System.Net;
using System.Security.Claims;

namespace QueryPlatform.Api.Controllers
{
    [Authorize]
    [Route("api/account")]
    [ApiController]
    public class AccountController : ControllerBase
    {
        private readonly IUserIdentity _identity;
        private readonly UserQueries _userQueries;
        private readonly JwtOption _jwtOption;

        public AccountController(IUserIdentity identity, IOptions<JwtOption> options, UserQueries userQueries)
        {
            _identity = identity;
            _userQueries = userQueries;
            _jwtOption = options.Value;
        }
        /// <summary>
        /// 登录授权
        /// </summary>
        /// <remarks>
        /// Sample request:
        ///
        ///     POST /Todo
        ///     {
        ///       "Account": "admin",
        ///       "Password": "1111"
        ///     }
        ///
        /// </remarks>
        /// <returns></returns>
        [ProducesResponseType(typeof(JwtResult), (int)HttpStatusCode.OK)]
        [HttpPost("login"), AllowAnonymous]
        public ActionResult Login([FromBody] LoginRequest request)
        {
            var user = _userQueries.GetUserByAccount(request.Account, 0);
            // 微信登录提示方式不同
            if (user == null)
                throw new DomainException("账号不存在");

            if (!user.Password.Equals(request.Password, StringComparison.OrdinalIgnoreCase))
                throw new DomainException("密码错误");

            var claims = new[]
            {
                new Claim(ClaimTypes.Sid, user.id.ToString()),
                new Claim(ClaimTypes.Surname, user.RealName),
                new Claim(ClaimTypes.Name, user.Login),
            };
            var jwt = new JwtToken(_jwtOption).GenerateToken(claims);
            return Ok(jwt);
        }
        /// <summary>
        /// 刷新登录JWT TOKEN
        /// </summary>
        /// <returns></returns> 
        [HttpPost]
        [Route("refresh")]
        public ActionResult Refresh()
        {
            var jwt = new JwtToken(_jwtOption).GenerateToken(_identity.Claims);
            return Ok(jwt);
        }
    }
}
