﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using QueryPlatform.Api.Infrastructure.Modules;
using QueryPlatform.Api.Infrastructure.Queries;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Controllers
{
    [Authorize]
    [Route("api/resource")]
    [ApiController]
    public class AnalysisController : Controller
    {
        private readonly AnalysisQueries _aQueries;
        private readonly HomeQueries _homeQueries;
        private readonly IMemoryCache _cache;
        public AnalysisController(IMemoryCache cache, AnalysisQueries aQueries, HomeQueries homeQueries)
        {
            _cache = cache;
            _homeQueries = homeQueries;
            _aQueries = aQueries;
        }
        /// <summary>
        /// 医院展示
        /// </summary>
        /// <returns></returns> 
        [HttpPost("HosListInquire")]
        [AllowAnonymous]
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) HosListInquire(int paseIndex, string hos_name, int? hos_id)
        {
            return _aQueries.HosListInquire(paseIndex, hos_name, hos_id);
        }
        /// <summary>
        /// 数据解析
        /// </summary>
        /// <returns></returns> 
        private static SemaphoreSlim semaphore = new SemaphoreSlim(1, 1);
        [HttpPost("ParseInquire")]
        [AllowAnonymous]
        public async Task ParseInquireAsync(Sys_cs sys_)
        {

            int id = _aQueries.JX_SCJXJL(sys_.hosid, sys_.zxr);//1.生成解析记录         
            _aQueries.updateztZ(id, sys_.hosid, "等待执行");
            await semaphore.WaitAsync();
            try
            {
                if (sys_.num <= 1)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--1更新reg_id，master_index");
                    _aQueries.JX_GXID(id, sys_.hosid);//1更新reg_id，master_index
                }
                if (sys_.num <= 2)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--2更新标准库里DIC_DIAG_SUMMARY里的标准字段");
                    _aQueries.JX_DIC_DIAG(id, sys_.hosid);//2更新标准库里DIC_DIAG_SUMMARY里的标准字段
                }
                if (sys_.num <= 3)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--3新建费用查询字典表");
                    _aQueries.JX_DIC_FEE(id, sys_.hosid);//3新建费用查询字典表
                }
                if (sys_.num <= 4)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--4未匹配上的诊断导入到DA_Disease表中");
                    _aQueries.JX_ADD_DA_Disease(id, sys_.hosid);//4未匹配上的诊断导入到DA_Disease表中
                }
                if (sys_.num <= 5)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--5匹配更新标准库DIC_DRUG_ATC的标准字段");
                    _aQueries.JX_DIC_DRUG_ATC(id, sys_.hosid);//5匹配更新标准库 DIC_DRUG_ATC的标准字段
                }
                if (sys_.num <= 6)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--6未匹配上的导入DA_Drug 做处理");
                    _aQueries.JX_ADD_DA_Drug(id, sys_.hosid);//6未匹配上的导入 [dbo].[DA_Drug] 做处理
                }
                if (sys_.num <= 7)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--7对导入的药品跑权重");
                    _aQueries.JX_DRUG_DATA_QZ(id, sys_.hosid);//7对导入的药品跑权重
                }
                if (sys_.num <= 8)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--8对导入的诊断做处理，剔除无效字符");
                    _aQueries.JX_DA_DIAGNOSIS_DATA(id, sys_.hosid);//8对导入的诊断做处理，剔除无效字符
                }
                if (sys_.num <= 9)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--9新导入的诊断跑权重,生成标准科室,标准一级诊断,标准二级诊断");
                    _aQueries.JX_DIAGNOSIS_DATA_QZ(sys_.hosid);//9新导入的诊断跑权重,生成标准科室，标准一级诊断，标准二级诊断
                }
                if (sys_.num <= 10)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--10更新DIC_DIAG_GATHER里的标准字段");
                    _aQueries.JX_REMATCH_DIAG(id, sys_.hosid);//10更新DIC_DIAG_GATHER里的标准字段
                }
                if (sys_.num <= 11)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--11更新标准库里DIC_DIAG_SUMMARY里的标准字段");
                    _aQueries.JX_DIC_DIAG(id, sys_.hosid);//11更新标准库里DIC_DIAG_SUMMARY里的标准字段
                }
                if (sys_.num <= 12)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--12调用函数更新out_reg_info标准诊断");
                    _aQueries.JX_UPDATE_REG_INFO(id, sys_.hosid);//12调用函数更新out_reg_info标准诊断
                }
                if (sys_.num <= 13)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--13医保（1插入card_type表,2更改SOURCE,3修改登记表i_card_type）");
                    _aQueries.JX_REMOVE_CARD_TYPE(id, sys_.hosid);//13医保（1--插入card_type表,2--更改SOURCE ,3--修改登记表i_card_type）
                }
                if (sys_.num <= 14)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "--14费用分类");
                    _aQueries.JX_INSERT_CATEGORY(id, sys_.hosid);//14费用分类
                }
                if (sys_.num <= 15)
                {
                    _aQueries.updateztZ(id, sys_.hosid, "执行完成");//15解析结束
                }

                _homeQueries.SendMail("医院解析提醒", @$"医院编号：{sys_.hosid} 解析结束！请前去确认是否需要费用分类。", sys_.zxr);
            }
            catch (Exception ex)
            {
                _homeQueries.SendMail("医院解析提醒", @$"医院编号：{sys_.hosid} 解析失败！错误日志：{ex}", sys_.zxr);
                _aQueries.updateztZ(id, sys_.hosid, "执行失败");//解析结束
                throw;
            }
            finally
            {
                semaphore.Release();
            }
        }
        /// <summary>
        /// 下拉框
        /// </summary>
        /// <returns></returns>  
        [HttpPost("JxLx")]
        [AllowAnonymous]
        public IEnumerable<dynamic> JxLx()
        {
            return _aQueries.JxLx();
        }
    }
}
