﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QueryPlatform.Api.Infrastructure.Modules;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Infrastructure.Queries
{
    [Authorize]
    [Route("api/resource")]
    [ApiController]
    public class DrugqueryController : Controller
    {
        private readonly DrugqueryQueries _drugqueryQueries;
        private readonly HomeQueries _homeQueries;
        public DrugqueryController(DrugqueryQueries drugqueryQueries, HomeQueries homeQueries)
        {
            _drugqueryQueries = drugqueryQueries;
            _homeQueries = homeQueries;
        }
        ///   /// <summary>
        ///  查询病人疾病信息和药品信息 type1=疾病 type2药品
        /// </summary>
        /// <returns></returns>
        private static SemaphoreSlim semaphore = new SemaphoreSlim(1, 1);
        [HttpPost("Drugquery")]
        [AllowAnonymous]
        public async Task Drugquery([FromBody] SYS_Drugquery sYS_Drugquery, string zxr)
        {
            var icd_or_diseaseCondition = "";
            var notdisease = "";
            var notdrugs = "";
            var notmaterialName = "";
            long type = 0;
            long num = 0;
            var drugs = "";
            var materialNames = "";
            //icd 诊断
            if (sYS_Drugquery.icd != null)
            {
                foreach (var icdname in sYS_Drugquery.icd)
                {
                    if (!string.IsNullOrEmpty(icdname) & !icdname.Contains("!") & !icdname.Contains("！"))
                        icd_or_diseaseCondition = icd_or_diseaseCondition + $"or icd like '%{icdname}%'";
                    if (!string.IsNullOrEmpty(icdname) & (icdname.Contains("!") || icdname.Contains("！")))
                        notdisease = notdisease + $"and icd not like '%{icdname.Replace("！", "").Replace("!", "")}%'";
                }
            }
            if (sYS_Drugquery.diseaseName != null)
            {
                foreach (var disease in sYS_Drugquery.diseaseName)
                {
                    if (!string.IsNullOrEmpty(disease) & !disease.Contains("!") & !disease.Contains("！"))
                    {
                        icd_or_diseaseCondition = icd_or_diseaseCondition + $"or DISEASE_NAME like '%{disease}%'";
                    }
                    else
                    {
                        notdisease = notdisease + $"and DISEASE_NAME not like '%{disease.Replace("！", "").Replace("!", "")}%'";
                    }
                }
            }
            if (icd_or_diseaseCondition.Length > 0)
            {
                icd_or_diseaseCondition = icd_or_diseaseCondition.Substring(2, icd_or_diseaseCondition.Length - 2);
                if (notdisease.Length > 0)
                    icd_or_diseaseCondition = "(" + icd_or_diseaseCondition + ")" + notdisease;

            }

            //药品
            if (sYS_Drugquery.drugName != null)
            {
                foreach (var drug in sYS_Drugquery.drugName)
                {
                    if (!string.IsNullOrEmpty(drug) & !drug.Contains("!") & !drug.Contains("！"))
                    {
                        drugs = drugs + $"or item_name like '%{drug}%'";
                    }
                    else
                    {
                        notdrugs = notdrugs + $"and item_name not like '%{drug.Replace("！", "").Replace("!", "")}%'";
                    }
                }
            }
            if (drugs.Length > 0)
            {
                drugs = drugs.Substring(2, drugs.Length - 2);
                if (notdrugs.Length > 0)
                    drugs = "(" + drugs + ")" + notdrugs;
            }
            //材料
            if (sYS_Drugquery.materialName != null)
            {
                foreach (var materialname in sYS_Drugquery.materialName)
                {
                    if (!string.IsNullOrEmpty(materialname) & !materialname.Contains("!") & !materialname.Contains("！"))
                    {
                        materialNames = materialNames + $"or item_name like '%{materialname}%'";
                    }
                    else
                    {
                        notmaterialName = notmaterialName + $"and unitprice>=450 and item_name not like '%{materialname.Replace("！", "").Replace("!", "")}%'";
                    }
                }
            }
            if (materialNames.Length > 0)
            {
                materialNames = materialNames.Substring(2, materialNames.Length - 2);
                if (notmaterialName.Length > 0)
                    materialNames = "(" + materialNames + ")" + notmaterialName;

            }



            if (!string.IsNullOrEmpty(icd_or_diseaseCondition) && string.IsNullOrEmpty(drugs) && string.IsNullOrEmpty(materialNames))
            {
                type = 1;//1疾病 
                num = _drugqueryQueries.SqlAdd(sYS_Drugquery, type, zxr);
            }
            else if (!string.IsNullOrEmpty(drugs) && string.IsNullOrEmpty(icd_or_diseaseCondition) && string.IsNullOrEmpty(materialNames))
            {
                type = 2;//2药品 
                num = _drugqueryQueries.SqlAdd(sYS_Drugquery, type, zxr);
            }
            else if (!string.IsNullOrEmpty(materialNames) && string.IsNullOrEmpty(drugs) && string.IsNullOrEmpty(materialNames))
            {
                type = 3;//3材料
                num = _drugqueryQueries.SqlAdd(sYS_Drugquery, type, zxr);
            }
            await semaphore.WaitAsync();
            try
            {
                asynsDrugquery(sYS_Drugquery, icd_or_diseaseCondition, drugs, materialNames, num, type, zxr);
            }
            finally
            {
                semaphore.Release();
            }
        }

        private void asynsDrugquery(SYS_Drugquery sYS_Drugquery, string icd_or_diseaseCondition, string drugs, string materialNames, long num, long type, string zxr)
        {
            _drugqueryQueries.updateCOMPLETE_MARK(num, 21);
            try
            {
                if (type == 1)
                {
                    var tasks = new List<Task>();
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Diseasequery(sYS_Drugquery.type1_2, icd_or_diseaseCondition, num, 1, zxr)));
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Diseasequery(sYS_Drugquery.type1_2, icd_or_diseaseCondition, num, 2, zxr)));
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Diseasequery(sYS_Drugquery.type1_2, icd_or_diseaseCondition, num, 3, zxr)));
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Diseasequery(sYS_Drugquery.type1_2, icd_or_diseaseCondition, num, 4, zxr)));
                    Task.WaitAll(tasks.ToArray());
                }
                else if (type == 2)
                {
                    try
                    {
                        var tasks = new List<Task>();
                        tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Drugquery(sYS_Drugquery.typefee, sYS_Drugquery.type1_2, drugs, sYS_Drugquery.drugName, num, 1, zxr)));
                        tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Drugquery(sYS_Drugquery.typefee, sYS_Drugquery.type1_2, drugs, sYS_Drugquery.drugName, num, 4, zxr)));
                        tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Drugquery(sYS_Drugquery.typefee, sYS_Drugquery.type1_2, drugs, sYS_Drugquery.drugName, num, 3, zxr)));
                        tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.Drugquery(sYS_Drugquery.typefee, sYS_Drugquery.type1_2, drugs, sYS_Drugquery.drugName, num,5, zxr)));
                        Task.WaitAll(tasks.ToArray());
                    }
                    catch (Exception ex)
                    { 
                        throw;
                    }

                }
                else if (type == 3)
                {
                    var tasks = new List<Task>();
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.材料query(1,sYS_Drugquery.type1_2, materialNames, sYS_Drugquery.materialName, num, 1, zxr)));
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.材料query(1,sYS_Drugquery.type1_2, materialNames, sYS_Drugquery.materialName, num, 2, zxr)));
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.材料query(1, sYS_Drugquery.type1_2, materialNames, sYS_Drugquery.materialName, num, 3, zxr)));
                    tasks.Add(Task.Factory.StartNew(() => _drugqueryQueries.材料query(1, sYS_Drugquery.type1_2, materialNames, sYS_Drugquery.materialName, num, 4, zxr)));
                    Task.WaitAll(tasks.ToArray());
                }
                else
                {
                    throw new DomainException("只能单类型查询！！");
                }
                _drugqueryQueries.updateCOMPLETE_MARK(num, 22);
                _homeQueries.SendMail(@$"药品/疾病/材料平台提醒", @$" {(type == 1 ? "疾病" : type == 2 ? "药品" : "材料")}：{sYS_Drugquery.peojectName}拉取结束！", zxr);
            }
            catch (Exception e)
            {
                throw e;
            }
        }

        ///   /// <summary>
        ///  化验检查检索
        /// </summary>
        /// <returns></returns>
        [HttpPost("化验检查query")]
        [AllowAnonymous]
        public void 化验检查query(int indexs, string project_name, string[] commodity_name, int type, string zxr, int bz = 0)
        {
            int id = _drugqueryQueries.SqlAssayAdd(indexs, project_name, commodity_name, type);
            int ids = _drugqueryQueries.indexsId(indexs);
            var item_name = "";
            if (commodity_name != null)
            {
                foreach (var item in commodity_name)
                {
                    if (!string.IsNullOrEmpty(item))
                    {
                        if (type == 1)
                            item_name = item_name + $"or ASSAY_ITEM_NAME like '%{item}%' or ITEM_ENAME like '%{item}%' or RESULTS like '%{item}%'";
                        if (type == 2)
                            item_name = item_name + $"or EXAMINE_NAME like '%{item}%'";
                    }
                }
                if (item_name.Length > 0)
                {
                    item_name = item_name.Substring(2, item_name.Length - 2);
                }
            }
            ///////////////////////------------进入业务------------/////////////////////////////

            _drugqueryQueries.化验query(type, indexs, id, 1, zxr, ids);//建人群中转表
            _drugqueryQueries.化验query(type, indexs, id, 2, zxr);//各服务器建临时表
            _drugqueryQueries.化验query(type, indexs, id, 3, zxr, ids, item_name);//各服务器开始拉取 
            _drugqueryQueries.化验query(type, indexs, id, 4, zxr);//删除各服务器临时表
            if (type == 1)//检查自动跳过
            {
                _drugqueryQueries.化验query(type, indexs, id, 5, zxr, 0, item_name);//切割化验
            }
            _drugqueryQueries.化验query(type, indexs, id, 6, zxr);//结束
            _homeQueries.SendMail(@$"化验检查拉取提醒", @$"{(type == 1 ? "化验" : "检查")}:{project_name} 拉取结束！", zxr);
        }
        [HttpPost("delete")]
        [AllowAnonymous]
        public void delete(long type, long indexs, int id, long bz, string zxr)
        {
            _drugqueryQueries.化验query(type, indexs, id, bz, zxr);
        }

        [HttpPost("MEDIC_SEARCH_RECORD_ASSAY")]
        [AllowAnonymous]
        public IEnumerable<dynamic> MEDIC_SEARCH_RECORD_ASSAY(int id)
        {
            return _drugqueryQueries.MEDIC_SEARCH_RECORD_ASSAY(id);
        }
        /// <summary>
        /// 需求探索
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPost("DemandExploration")]
        [AllowAnonymous]
        public IEnumerable<dynamic> DemandExploration(int id)
        {
            return _drugqueryQueries.MEDIC_SEARCH_RECORD_ASSAY(id);

        }
    }


}
