﻿using Autofac;
using Microsoft.Extensions.Configuration;
using QueryPlatform.Api.Infrastructure.Queries;
using QueryPlatform.Api.Infrastructure.Queues;

namespace QueryPlatform.Api.Infrastructure.AutofacModules
{
    public class QueriesModule : Autofac.Module
    {
        private readonly IConfiguration configuration;

        public QueriesModule(IConfiguration configuration)
        {
            this.configuration = configuration;
        }

        protected override void Load(ContainerBuilder builder)
        {
            var configConnectionString = configuration["ConnectionStrings:configConnectionString"];
            var Connection151 = configuration["ConnectionStrings:Connection151"];
            var Connection152 = configuration["ConnectionStrings:Connection152"];
            var Connection153 = configuration["ConnectionStrings:Connection153"];
            var Connection154 = configuration["ConnectionStrings:Connection154"];
            var Connection155 = configuration["ConnectionStrings:Connection155"];
            var Connection156 = configuration["ConnectionStrings:Connection156"];
            var Connection158 = configuration["ConnectionStrings:Connection158"];

            builder.RegisterType<HubNotificationQueue>().SingleInstance();
            builder.Register(c => new UserStorage(configConnectionString)).InstancePerLifetimeScope();
            builder.Register(c => new UserQueries(configConnectionString)).InstancePerLifetimeScope();
            builder.Register(c => new ResourceQueries(Connection156, configConnectionString)).InstancePerLifetimeScope();
            builder.Register(c => new DrugqueryQueries(Connection156, configConnectionString)).InstancePerLifetimeScope();
            builder.Register(c => new HomeQueries(configConnectionString, Connection156)).InstancePerLifetimeScope();
            builder.Register(c => new AnalysisQueries(Connection156, configConnectionString)).InstancePerLifetimeScope();
            builder.Register(c => new DirectoryTree()).InstancePerLifetimeScope();
        }
    }
}


