﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;

namespace QueryPlatform.Api.Infrastructure.Filters
{
    public class ArgumentsActionFilter : IActionFilter
    {
        private readonly ILogger<ArgumentsActionFilter> _logger;
        public ArgumentsActionFilter(ILogger<ArgumentsActionFilter> logger)
        {
            _logger = logger;
        }

        public void OnActionExecuted(ActionExecutedContext context)
        {
            if (context.Exception == null)
            {
                object @object = null;
                if (context.Result is ObjectResult)
                    @object = (context.Result as ObjectResult).Value;

                context.Result = new ObjectResult(new OkResponse(@object));
            }
        }

        public void OnActionExecuting(ActionExecutingContext context)
        {
            _logger.LogInformation($"请求地址：{context.HttpContext.Request.Path};请求内容 {JsonConvert.SerializeObject(context.ActionArguments)}");
        }
    }
}
