﻿using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using QueryPlatform.Api.Infrastructure.Queries;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace Test.Web.Host.Model
{
    public class Job : BackgroundService
    {

        private readonly DrugqueryQueries _drugqueryQueries;
        private readonly HomeQueries _homeQueries;
        private readonly ILogger<Job> _logger;
        public Job(ILogger<Job> logger, DrugqueryQueries drugqueryQueries, HomeQueries homeQueries)
        {
            _logger = logger;
            _drugqueryQueries = drugqueryQueries;
            _homeQueries = homeQueries;
        }
        protected override async Task ExecuteAsync(CancellationToken stoppingToken)
        {
            while (!stoppingToken.IsCancellationRequested)
            {
                await new TaskFactory().StartNew(() =>
                {
                    try
                    {
                        var day = DateTime.Now.Day;
                        var time = DateTime.Now.ToString("HH:mm:ss");
                        if (day == 8 && time == "09:39:01")
                        {
                            // _drugqueryQueries.定时执行();
                            _homeQueries.SendMail("定时任务", "人群检索表 化验检查检索表合并成功");
                        }
                    }
                    catch (Exception e)
                    {
                        _homeQueries.SendMail("定时任务", "人群检索表 化验检查检索表合并失败。   错误日志：" + e.ToString());
                        throw;
                    }
                    Thread.Sleep(1 * 1000);
                });
            }
        }
    }
}