﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using System.Linq;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Infrastructure.Middlewares
{
    /// <summary>
    /// 解码中间件
    /// </summary>
    public class DecodeResponseMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly IConfiguration _configuration;

        public DecodeResponseMiddleware(
            RequestDelegate next,
            IConfiguration configuration)
        {
            _next = next;
            _configuration = configuration;
        }

        public async Task Invoke(HttpContext httpContext)
        {
            var metheds = new string[] { "PUT", "POST", "DELETE" };
            if (metheds.Any(w => w.Equals(httpContext.Request.Method)))
            {
                //string privateKey = _configuration["PrivateKey"];

                //var request = httpContext.Request;
                //string secret = request.Headers["secret"];
                //if (!string.IsNullOrEmpty(secret))
                //{
                //    request.EnableBuffering();
                //    //把请求body流转换成字符串
                //    string body = await new StreamReader(request.Body).ReadToEndAsync();
                //    var data = AES.Decrypt(body, secret);
                //    var bytes = Encoding.UTF8.GetBytes(data);
                //    request.Body = new FileBufferingReadStream(new MemoryStream(bytes), 30720);
                //    request.Body.Seek(0, SeekOrigin.Begin);
                //    request.ContentType = "application/json";
                //}
            }
            await _next(httpContext);
        }
    }

    public static class DecodeResponseMiddlewareExtensions
    {
        public static IApplicationBuilder UseDecodeReqResponse(this IApplicationBuilder builder)
        {
            return builder.UseMiddleware<DecodeResponseMiddleware>();
        }
    }
}
