﻿using Dapper;
using Microsoft.Data.SqlClient;
using QueryPlatform.Api.Infrastructure.Modules;
using System;
using System.Collections.Generic;
using System.Data.Common;
using System.Linq;

namespace QueryPlatform.Api.Infrastructure.Queries
{
    public class AnalysisQueries
    {
        private readonly string _Connection156;
        private readonly string _configConnectionString;
        public AnalysisQueries(string Connection156, string configConnectionString)
        {
            _Connection156 = Connection156;
            _configConnectionString = configConnectionString;
        }
        public DbConnection Connection(int ip, string y = "", string t = "")
        {
            if (ip == 156)
            {
                return new SqlConnection((y == "") ? _Connection156 : _Connection156.Replace(y, t));
            }
            if (ip == 181)
            {
                return new SqlConnection((y == "") ? _configConnectionString : _configConnectionString.Replace(y, t));
            }
            return new SqlConnection();
        }
        public DbConnection Connection(int ip, string configConnectionString)
        {
            if (ip == 0)
            {
                return new SqlConnection(configConnectionString);
            }
            return new SqlConnection();
        }
        public IEnumerable<dynamic> JxLx()
        {
            var query = @" SELECT   [id]  ,[Remarks]  FROM [SV_QueryPlatform].[dbo].[AnalyticMethodList]";
            return Connection(181).Query(query).ToList();
        }
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) HosListInquire(int paseIndex, string hos_name, int? hos_id)
        {

            string where = " ";
            if (!string.IsNullOrEmpty(hos_name))
            {
                where = where + " and [HosName] like '%" + hos_name + "%'";
            }
            if (hos_id != null)
            {
                where = where + " and id  =" + hos_id;
            }
            IEnumerable<dynamic> sj = Connection(181).Query($@"
select*FROM(
SELECT ROW_NUMBER() OVER(ORDER BY ts desc,(select  max(ksdate ) from [dbo].[解析任务]  where hos_id =a.编号) desc,
医院等级,解析,Replace(Replace(医院名称,'新系统',''),'老系统','') desc   )AS id,* FROM(
SELECT   
[ID] 编号,
[HosName] 医院名称,
[HosLevel] 医院等级,
[HosType] 医院类型,
[ExecOpenLink] 服务器,
[ExecDatabase] 数据库, 
Replace([Province],' ','') 省份,
Replace([Region],' ','') 市, 
Replace([City],' ','') 区, 
case when isnull([ExecOpenLink],'')!='' and isnull([ExecDatabase],'')!='' 
then isnull(
             (SELECT 
			           concat('',status,
                       case when  ts <>'' and ts is not null then concat(' 提示：',ts) else '' end 
					         )FROM  [dbo].[解析任务] where hos_id =a.id  and ksdate=(select  max(ksdate ) from [dbo].[解析任务]  where hos_id =a.id)) ,'执行完成') 
else null end 解析日志 ,
case 
when (SELECT status FROM  [SV_QueryPlatform].[dbo].[解析任务] where hos_id =a.id and ksdate=(select max(ksdate ) from [dbo].[解析任务] where hos_id =a.id))   is null then 1  
when (SELECT status FROM  [SV_QueryPlatform].[dbo].[解析任务] where hos_id =a.id and ksdate=(select max(ksdate ) from [dbo].[解析任务] where hos_id =a.id))in ('执行完成') then 1 
else 0 end 解析,
case 
when  (SELECT ts FROM  [SV_QueryPlatform].[dbo].[解析任务] where hos_id =a.id and ksdate=(select max(ksdate ) from [dbo].[解析任务]  where hos_id =a.id))   like '%category未分类%' then 1
else 0 end ts
FROM [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital]  A  WHERE A.id<>1 and isnull([ExecDatabase],'')!=''  {where}
)a )b   WHERE id<={paseIndex}*10 and id>({paseIndex} - 1)*10").ToList();
            IEnumerable<dynamic> zon = Connection(181).Query($@"   SELECT  CAST(COUNT(*)AS MONEY)totalCount ,{paseIndex} paseIndex FROM(
                 SELECT  DISTINCT *
                   FROM [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] WHERE id<>1 and ExecOpenLink is not null and ExecDatabase is not null  and
                 ExecOpenLink !='' and ExecDatabase !=''  { where })a").ToList();
            return (sj, zon);
        }
        public void updatezt(int id, int hos_id, string log, string ts)
        {
            Connection(181).Execute(@$" insert into [SV_QueryPlatform].[dbo].[SYS_LOG_解析] ([INDEXS],[hos_code],[LOG],[CreateDate]) select '{id}','{hos_id}','{log}',getdate()");
            Connection(181).Execute(@$"update [SV_QueryPlatform].[dbo].[解析任务] set [updatedate]=getdate(),log='{log}',ts=concat(ts,'','{(ts == null ? "" : ts)}') where hos_id={hos_id} and id={id}");

        }
        public void updateztZ(int id, int hos_id, string status)
        {
            Connection(181).Execute(@$" insert into [SV_QueryPlatform].[dbo].[SYS_LOG_解析] ([INDEXS],[hos_code],[LOG],[CreateDate]) select '{id}','{hos_id}','{status}',getdate()");
            Connection(181).Execute(@$"update [SV_QueryPlatform].[dbo].[解析任务] set [status]='{status}',[updatedate]=getdate() where hos_id={hos_id} and id={id}");

        }
        /// <summary>
        /// 解析执行sql
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="hos_id"></param>
        /// <param name="id"></param>
        /// <param name="hos"></param>
        private void JX_zx(string sql, int hos_id, int id, SYS_Hospital hos)
        {

            服务器 fwq = Connection(181).Query<服务器>($"SELECT   [服务器ip],[数据库账号],[数据库密码] FROM[SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
            // DefaultConnection 
            try
            {
                Connection(0, msConnectionString).Execute(sql, commandTimeout: 60 * 60 * 12);
            }
            catch (Exception ex)
            {

                Connection(181).Execute(@$"update [SV_QueryPlatform].[dbo].[解析任务] set [status]='失败',[updatedate]=getdate() where hos_id={hos_id} and id={id}");
                throw;
            }
        }
        /// <summary>
        /// 解析执行sql返回数字
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="hos_id"></param>
        /// <param name="id"></param>
        /// <param name="hos"></param>
        /// <returns></returns>
        private int JX_zx_int(string sql, int hos_id, int id, SYS_Hospital hos)
        {
            服务器 fwq = Connection(181).Query<服务器>($"SELECT   [服务器ip],[数据库账号],[数据库密码] FROM[SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
            // DefaultConnection
            try
            {
                int num = Connection(0, msConnectionString).Query<int>(sql, 60 * 60 * 12).FirstOrDefault();
                return num;
            }
            catch (Exception)
            {

                Connection(181).Execute(@$"update [SV_QueryPlatform].[dbo].[解析任务] set [status]='失败',[updatedate]=getdate(),log=[status]+{sql} where hos_id={hos_id} and id={id}");
            }
            return 0;
        }
        /// <summary>
        /// 生成一条解析记录
        /// </summary>
        /// <param name="hos_id"></param>
        /// <param name="czr"></param>
        /// <returns></returns>
        public int JX_SCJXJL(int hos_id, string czr)
        {
            var sql = @$" insert into [dbo].[解析任务](  [updatedate], [status], [ksdate], [hos_id], [czr])VALUES(getdate(),'开始解析',getdate(),{hos_id},'{czr}') ";
            Connection(181).Execute(sql, commandTimeout: 60 * 60 * 10);
            return Connection(181).Query<int>($@" select max(id)id from  [dbo].[解析任务]  where hos_id={hos_id} ").FirstOrDefault();

        }
        /// <summary>
        /// 默认
        /// </summary>
        /// <param name="id"></param>
        /// <param name="hos_id"></param>
        public void JX_MR(int id, int hos_id)
        {
            updatezt(id, hos_id, "", null);
        }
        /// <summary>
        /// 更新id org_code m_index
        /// </summary>
        /// <param name="id"></param>
        /// <param name="hos_id"></param>
        public void JX_GXID(int id, int hos_id)
        {
            var sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            SYS_Hospital hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();

            //sql = @$"         update [{hos.ExecDatabase}].[dbo].[ASSAY_REPORT]	 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[DIC_DEPT]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[DIC_DIAG]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[DIC_DRUG]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[DIC_EMP]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[DIC_FEE]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[EXEC_REPORT]	 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[INPAT_DIAG]	 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[INPAT_FEE]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[INPAT_ORDER]	 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[INPAT_REG_INFO] set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[OUT_DIAG]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[OUT_FEE]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[OUT_PRES]		 set org_code={hos_id} where org_code<>{hos_id}
            //                  update [{hos.ExecDatabase}].[dbo].[OUT_REG_INFO]	 set org_code={hos_id} where org_code<>{hos_id}";
            //updatezt(id, hos_id, "修改org_code不等于医院id的数据" + sql.Replace("'", "''"), null);
            //JX_zx(sql, hos_id, id, hos);

            //判断id是否修
            //判断MASTER_INDEX是否修改
            sql = $@"SELECT COUNT(1)id FROM [{hos.ExecDatabase}].[dbo].PUB_PATIENT
                               where MASTER_INDEX is null";
            updatezt(id, hos_id, "判断MASTER_INDEX是否修改" + sql.Replace("'", "''"), null);
            if (JX_zx_int(sql, hos_id, id, hos) > 0 && hos.ExecDatabase.Length == 13)
            {
                sql = $@" IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'PATIENT')
                DROP TABLE [{hos.ExecDatabase}].dbo.PATIENT
                IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'PATIENT_NOTNULL')
                DROP TABLE [{hos.ExecDatabase}].dbo.PATIENT_NOTNULL
                IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'PATIENT_STORE1')
                DROP TABLE [{hos.ExecDatabase}].dbo.PATIENT_STORE1
                IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'PATIENT_STORE2')
                DROP TABLE [{hos.ExecDatabase}].dbo.PATIENT_STORE2
                CREATE TABLE [{hos.ExecDatabase}].dbo.PATIENT (PERSON_ID int,ID_CARD NVARCHAR(max),CARD_ID NVARCHAR(max),NEWPERSON_ID int)
                CREATE TABLE [{hos.ExecDatabase}].dbo.PATIENT_NOTNULL(PERSON_ID int,CODE NVARCHAR(50),NEWPERSON_ID int)
                CREATE TABLE [{hos.ExecDatabase}].dbo.PATIENT_STORE1(PERSON_ID int,CODE NVARCHAR(50),NEWPERSON_ID int)
                CREATE TABLE [{hos.ExecDatabase}].dbo.PATIENT_STORE2(PERSON_ID int,CODE NVARCHAR(50),NEWPERSON_ID int)
                 	CREATE NONCLUSTERED INDEX [INDEX_PATIENT_NOTNULL] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_NOTNULL] ([CODE] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX_PATIENT_STORE1] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_STORE1] ([CODE] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX_PATIENT_STORE2] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_STORE2] ([CODE] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX1_PATIENT_NOTNULL] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_NOTNULL]([PERSON_ID] ASC, [CODE] ASC, [NEWPERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX1_PATIENT_STORE1] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_STORE1] ([PERSON_ID] ASC, [CODE] ASC, [NEWPERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX1_PATIENT_STORE2] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_STORE2] ([PERSON_ID] ASC, [CODE] ASC, [NEWPERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX2_PATIENT] ON  [{hos.ExecDatabase}].[dbo].[PATIENT] ([PERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX2_PATIENT_NOTNULL] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_NOTNULL] ([PERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX2_PATIENT_STORE1] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_STORE1] ([PERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
                CREATE NONCLUSTERED INDEX [INDEX2_PATIENT_STORE2] ON  [{hos.ExecDatabase}].[dbo].[PATIENT_STORE2] ([PERSON_ID] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)";
                updatezt(id, hos_id, "创建需要使用的表" + sql.Replace("'", "''"), null);
                JX_zx(sql, hos_id, id, hos);


                //判断病人表中主索引列是否有值

                sql = @$" SELECT  CASE WHEN MAX(MASTER_INDEX) IS NULL THEN 0 ELSE MAX(MASTER_INDEX) END id  FROM [{hos.ExecDatabase}].[DBO].PUB_PATIENT where MASTER_INDEX is not null; ";
                updatezt(id, hos_id, "判断病人表中主索引列是否有值" + sql.Replace("'", "''"), null);
                int COUNT = JX_zx_int(sql, hos_id, id, hos);

                sql = @$" SELECT  COUNT(1) id  FROM  [{hos.ExecDatabase}].[DBO].PUB_PATIENT where MASTER_INDEX is  null ";
                int COUNT_ROW = JX_zx_int(sql, hos_id, id, hos);
                if (COUNT_ROW != 0)
                {
                    //将病人的医保号和身份证号集中放在一张表中
                    sql = $@"truncate TABLE [{hos.ExecDatabase}].[DBO].PATIENT
                                             truncate TABLE [{hos.ExecDatabase}].[DBO].PATIENT_NOTNULL
                                             truncate TABLE [{hos.ExecDatabase}].[DBO].PATIENT_STORE1
                                             truncate TABLE [{hos.ExecDatabase}].[DBO].PATIENT_STORE2
                                    insert into [{hos.ExecDatabase}].[DBO].PATIENT(PERSON_ID,ID_CARD,CARD_ID,NEWPERSON_ID)
                                    SELECT  TAB.PERSON_ID, CAST(ID_CARD AS NVARCHAR(100))ID_CARD, CARD_ID ,NULL NEWPERSON_ID FROM  
                                    (SELECT PERSON_ID,ID_CARD FROM [{hos.ExecDatabase}].[DBO].PUB_PATIENT  WHERE [MASTER_INDEX] IS NULL ) TAB 
                                    LEFT JOIN (SELECT PERSON_ID, CARD_ID FROM (SELECT DJ.PERSON_ID, CARD_ID FROM [{hos.ExecDatabase}].[DBO].[OUT_REG_INFO] DJ GROUP BY DJ.PERSON_ID, CARD_ID 
                                    UNION 
                                    SELECT DJ.PERSON_ID, CARD_ID FROM [{hos.ExecDatabase}].[DBO].[INPAT_REG_INFO] DJ GROUP BY DJ.PERSON_ID,CARD_ID) TA ) TAB1 
                                    ON TAB.PERSON_ID=TAB1.PERSON_ID GROUP BY TAB.PERSON_ID,ID_CARD,CARD_ID;";
                    updatezt(id, hos_id, "将病人的医保号和身份证号集中放在一张表中" + sql.Replace("'", "''"), null);
                    JX_zx(sql, hos_id, id, hos);
                    //获取最大的master_index的值

                    sql = @$" select case when max(NEWPERSON_ID) is null then 0 else max(NEWPERSON_ID) end id from [{hos.ExecDatabase}].[dbo].[PATIENT]";
                    updatezt(id, hos_id, "获取最大的master_index的值" + sql.Replace("'", "''"), null);
                    int mark = JX_zx_int(sql, hos_id, id, hos);

                    //置空不符合规范的身份证号和医保号
                    //更新无医保号且无身份证号的病人

                    sql = $@"IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'tablea')
                                   DROP TABLE [{hos.ExecDatabase}].dbo.tablea
                                             UPDATE [{hos.ExecDatabase}].[dbo].PATIENT SET ID_CARD = NULL WHERE ID_CARD NOT LIKE '[0-9]%' OR LEN(ID_CARD)<=15  OR ID_CARD  LIKE '%8888%' OR ID_CARD  LIKE '%00000%'
                                       UPDATE [{hos.ExecDatabase}].[dbo].PATIENT SET CARD_ID = NULL WHERE CARD_ID NOT LIKE '[0-9]%' OR LEN(CARD_ID)<6
                                       create table [{hos.ExecDatabase}].[dbo].tablea  (id int primary key identity({COUNT + mark + 1},1),[code] nvarchar(200))
                                       insert into [{hos.ExecDatabase}].[dbo].tablea(code)
                                       select distinct person_id from  [{hos.ExecDatabase}].[dbo].[PATIENT] WHERE ID_CARD IS NULL AND  CARD_ID IS NULL
                                       update [{hos.ExecDatabase}].[dbo].[PATIENT] set NEWPERSON_ID = b.id from [{hos.ExecDatabase}].[dbo].tablea b where [{hos.ExecDatabase}].[dbo].[PATIENT].PERSON_ID = b.code 
                                       insert into [{hos.ExecDatabase}].[dbo].PATIENT_NOTNULL(PERSON_ID,CODE,NEWPERSON_ID)
                                       select PERSON_ID,ID_CARD CODE, NEWPERSON_ID from [{hos.ExecDatabase}].[dbo].PATIENT WHERE NEWPERSON_ID IS NULL
                                       UNION ALL
                                       select PERSON_ID,CARD_ID CODE, NEWPERSON_ID from [{hos.ExecDatabase}].[dbo].PATIENT WHERE NEWPERSON_ID IS NULL
                                             drop table [{hos.ExecDatabase}].[dbo].tablea";
                    updatezt(id, hos_id, "置空不符合规范的身份证号和医保号&&更新无医保号且无身份证号的病人" + sql.Replace("'", "''"), null);
                    JX_zx(sql, hos_id, id, hos);

                    //递归更新身份证或者医保号相同的主索引
                    mark = (mark == 0) ? COUNT : mark;

                    sql = $@"IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'table2')
                          DROP TABLE [{hos.ExecDatabase}].dbo.table2
                                      create table  [{hos.ExecDatabase}].[DBO].table2  (id int primary key identity({mark + 1},1),[code] nvarchar(200))
                                insert into [{hos.ExecDatabase}].[DBO].PATIENT_STORE1(PERSON_ID,CODE,NEWPERSON_ID)select PERSON_ID,CODE, NEWPERSON_ID from [{hos.ExecDatabase}].[DBO].PATIENT_NOTNULL 
                                      DECLARE @COUNT int WHILE 1=1
                             BEGIN
                             truncate table [{hos.ExecDatabase}].[DBO].PATIENT_STORE2
                             insert into [{hos.ExecDatabase}].[DBO].PATIENT_STORE2  (PERSON_ID,CODE,NEWPERSON_ID) select A.PERSON_ID,B.CODE,B.PERSON_ID NEWPERSON_ID from [{hos.ExecDatabase}].[DBO].PATIENT_STORE1 A JOIN  [{hos.ExecDatabase}].[DBO].PATIENT_NOTNULL B ON A.CODE = B.CODE  GROUP BY A.PERSON_ID,B.PERSON_ID,b.CODE 
                             insert into [{hos.ExecDatabase}].[DBO].PATIENT_STORE2  (PERSON_ID,CODE,NEWPERSON_ID) select A.PERSON_ID,B.CODE,B.PERSON_ID NEWPERSON_ID from [{hos.ExecDatabase}].[DBO].PATIENT_STORE2 A JOIN [{hos.ExecDatabase}].[DBO].PATIENT_STORE2 B ON A.NEWPERSON_ID = B.PERSON_ID  GROUP BY A.PERSON_ID,B.PERSON_ID,b.CODE 
                                      SELECT @COUNT=COUNT(1)  FROM   [{hos.ExecDatabase}].[DBO].PATIENT_STORE2  A LEFT JOIN   [{hos.ExecDatabase}].[DBO].PATIENT_STORE1  B ON A.PERSON_ID = B.PERSON_ID and A.NEWPERSON_ID = B.NEWPERSON_ID AND A.CODE = B.CODE WHERE B.PERSON_ID IS NULL 
                             IF @COUNT=0 BREAK
                             truncate table [{hos.ExecDatabase}].[DBO].PATIENT_STORE1
                             INSERT intO [{hos.ExecDatabase}].[DBO].PATIENT_STORE1 (PERSON_ID,CODE,NEWPERSON_ID) SELECT PERSON_ID,CODE,NEWPERSON_ID FROM [{hos.ExecDatabase}].[DBO].PATIENT_STORE2 GROUP BY PERSON_ID,CODE,NEWPERSON_ID 
                                      END  
                             insert into [{hos.ExecDatabase}].[DBO].table2(code) SELECT DISTINCT A.NEWPERSON_ID FROM [{hos.ExecDatabase}].[DBO].PATIENT_STORE2 A ORDER BY NEWPERSON_ID
                             UPDATE [{hos.ExecDatabase}].[DBO].PATIENT_STORE2 SET  NEWPERSON_ID = b.id from [{hos.ExecDatabase}].[DBO].table2 b where [{hos.ExecDatabase}].[DBO].[PATIENT_STORE2].NEWPERSON_ID = b.code  
                             update [{hos.ExecDatabase}].[DBO].[PATIENT] set NEWPERSON_ID = b.NEWPERSON_ID from  (SELECT PERSON_ID,MIN(NEWPERSON_ID) NEWPERSON_ID FROM [{hos.ExecDatabase}].[DBO].PATIENT_STORE2 GROUP BY PERSON_ID) b where [{hos.ExecDatabase}].[DBO].[PATIENT].PERSON_ID = b.PERSON_ID 
                                        drop table [{hos.ExecDatabase}].dbo.table2";
                    updatezt(id, hos_id, "递归更新身份证或者医保号相同的主索引" + sql.Replace("'", "''"), null);
                    JX_zx(sql, hos_id, id, hos);


                    sql = $@"UPDATE [{hos.ExecDatabase}].dbo.PATIENT SET NEWPERSON_ID = B.MASTER_INDEX FROM (SELECT A.NEWPERSON_ID,B.MASTER_INDEX FROM [{hos.ExecDatabase}].dbo.PATIENT A  JOIN [{hos.ExecDatabase}].dbo.PUB_PATIENT B ON A.ID_CARD = B.ID_CARD WHERE B.MASTER_INDEX IS NOT NULL AND B.ID_CARD LIKE '[0-9]%' AND  LEN(B.ID_CARD)>=15  AND B.ID_CARD NOT LIKE '%8888%' AND B.ID_CARD NOT LIKE '%0000%' GROUP BY A.NEWPERSON_ID,B.MASTER_INDEX) B  WHERE PATIENT.NEWPERSON_ID = B.NEWPERSON_ID
                                     UPDATE [{hos.ExecDatabase}].dbo.PATIENT SET NEWPERSON_ID = B.MASTER_INDEX FROM (SELECT A.NEWPERSON_ID,B.MASTER_INDEX FROM [{hos.ExecDatabase}].dbo.PATIENT A  JOIN  ( SELECT B.CARD_ID,MASTER_INDEX FROM [{hos.ExecDatabase}].dbo.[PUB_PATIENT] A LEFT JOIN [{hos.ExecDatabase}].dbo.OUT_REG_INFO B ON A.PERSON_CODE  = B.PERSON_CODE WHERE A.MASTER_INDEX IS NOT NULL  AND A.ID_CARD LIKE '[0-9]%' AND  LEN(A.ID_CARD)>=15  AND A.ID_CARD NOT LIKE '%8888%' AND A.ID_CARD NOT LIKE '%0000%' AND B.CARD_ID  LIKE '[0-9]%' AND  LEN(B.CARD_ID)>=6 AND B.CARD_ID IS NOT NULL UNION SELECT B.CARD_ID,MASTER_INDEX  FROM [{hos.ExecDatabase}].dbo.[PUB_PATIENT] A LEFT JOIN [{hos.ExecDatabase}].dbo.INPAT_REG_INFO B ON A.PERSON_CODE  = B.PERSON_CODE WHERE A.MASTER_INDEX IS NOT NULL AND A.ID_CARD LIKE '[0-9]%' AND  LEN(A.ID_CARD)>=15  AND A.ID_CARD NOT LIKE '%8888%' AND A.ID_CARD NOT LIKE '%0000%' AND B.CARD_ID  LIKE '[0-9]%' AND  LEN(B.CARD_ID)>=6 AND B.CARD_ID IS NOT NULL ) B ON A.CARD_ID = B.CARD_ID GROUP BY A.NEWPERSON_ID,B.MASTER_INDEX ) B  WHERE PATIENT.NEWPERSON_ID = B.NEWPERSON_ID";
                    updatezt(id, hos_id, "同步ID_CARD或医保号相同的病人主索引.." + sql.Replace("'", "''"), null);
                    JX_zx(sql, hos_id, id, hos);

                    sql = $@"UPDATE [{hos.ExecDatabase}].dbo.PUB_PATIENT SET MASTER_INDEX=NEWPERSON_ID FROM (SELECT [PERSON_ID],NEWPERSON_ID FROM [{hos.ExecDatabase}].dbo.PATIENT GROUP BY [PERSON_ID], NEWPERSON_ID) TAB,[{hos.ExecDatabase}].dbo.PUB_PATIENT B WHERE B.PERSON_ID=TAB.PERSON_ID;
                                             ";
                    updatezt(id, hos_id, "将数据更新回病人登记表.." + sql.Replace("'", "''"), null);
                    JX_zx(sql, hos_id, id, hos);
                    sql = $@"DROP TABLE[{hos.ExecDatabase}].dbo.PATIENT
                                     DROP TABLE[{hos.ExecDatabase}].dbo.PATIENT_NOTNULL
                                     DROP TABLE[{hos.ExecDatabase}].dbo.PATIENT_STORE1
                                     DROP TABLE[{hos.ExecDatabase}].dbo.PATIENT_STORE2";
                    updatezt(id, hos_id, "删除临时表.." + sql.Replace("'", "''"), null);
                    JX_zx(sql, hos_id, id, hos);

                    //                    sql = $@"

                    //select *into #id_card解码 from(
                    //SELECT  null MASTER_INDEX, PERSON_ID, CAST(ID_CARD as nvarchar) ID_CARD1 FROM [dbo].[PUB_PATIENT]
                    //union 
                    //select  null MASTER_INDEX, PERSON_ID, CAST(CAST(ID_CARD as varchar)as nvarchar) ID_CARD2  FROM [dbo].[PUB_PATIENT])A

                    //select MASTER_INDEX,PERSON_ID,max(ID_CARD)ID_CARD into #id_card解码2  from(
                    //select MASTER_INDEX,PERSON_ID,case when ID_CARD1 is not null and len(ID_CARD1)>=15 and len(ID_CARD1)<=18 then ID_CARD1
                    //else null end ID_CARD From #id_card解码  )a group by  MASTER_INDEX,PERSON_ID

                    //select distinct MASTER_INDEX,PERSON_ID,
                    //case when  ID_CARD NOT LIKE '[0-9]%' OR LEN(ID_CARD)<=15  OR ID_CARD  LIKE '%8888%' OR ID_CARD  LIKE '%00000%'  then null 
                    //else case when len(ID_CARD) >15 then ID_CARD  when len(ID_CARD) >15 then ID_CARD end
                    //end ID_CARD into #解码后 from #id_card解码2

                    //select * into #已经分配的MASTER_INDEX from #解码后 where MASTER_INDEX is not null and ID_CARD is not null 

                    //select PERSON_ID,a.ID_CARD,case when a.MASTER_INDEX is not null then a.MASTER_INDEX else b.MASTER_INDEX end MASTER_INDEX into #身份证映射MASTER_INDEX   from #解码后 a 
                    //left join (select ID_CARD, max(MASTER_INDEX)MASTER_INDEX from #已经分配的MASTER_INDEX GROUP BY ID_CARD )b on a.ID_CARD=b.ID_CARD

                    //DECLARE @maxMASTER_INDEX int =(select isnull(max(MASTER_INDEX),0)  FROM [dbo].[PUB_PATIENT] )
                    //select*, @maxMASTER_INDEX+( ROW_NUMBER() OVER(PARTITION BY getdate() ORDER BY getdate() ) )MASTER_INDEX into #有身份证MASTER_INDEX空生成MASTER_INDEX from(
                    //select distinct ID_CARD from #身份证映射MASTER_INDEX where ID_CARD is not null and MASTER_INDEX is null)a

                    //update #身份证映射MASTER_INDEX set MASTER_INDEX = b.MASTER_INDEX
                    //from #身份证映射MASTER_INDEX a join #有身份证MASTER_INDEX空生成MASTER_INDEX b on a.ID_CARD=b.ID_CARD where a.MASTER_INDEX is null 

                    //DECLARE @maxMASTER_INDEX1 int   =(select isnull(max(MASTER_INDEX),0)  FROM #身份证映射MASTER_INDEX)
                    //select PERSON_ID, @maxMASTER_INDEX1+( ROW_NUMBER() OVER(PARTITION BY getdate() ORDER BY getdate() ) )MASTER_INDEX into #无身份证MASTER_INDEX空生成MASTER_INDEX from(
                    //select distinct PERSON_ID from #身份证映射MASTER_INDEX where MASTER_INDEX is null)a

                    //update #身份证映射MASTER_INDEX set MASTER_INDEX = b.MASTER_INDEX
                    //from #身份证映射MASTER_INDEX a join #无身份证MASTER_INDEX空生成MASTER_INDEX b on a.PERSON_ID=b.PERSON_ID where a.MASTER_INDEX is null 

                    //update [dbo].[PUB_PATIENT] set MASTER_INDEX=b.MASTER_INDEX
                    //from [dbo].[PUB_PATIENT] a 
                    //join #身份证映射MASTER_INDEX b on a.PERSON_ID=b.PERSON_ID where a.MASTER_INDEX is null 
                    // ";
                    //                updatezt(id, hos_id, "MASTER_INDEX更新", null);
                    //                JX_zx(sql, hos_id, id, hos);

                }
            }
        }
    
        public void JX_DIC_DIAG(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            sql = @$" IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DIC_DIAG_SUMMARY')
			drop table [{hos.ExecDatabase}].[dbo].[DIC_DIAG_SUMMARY];
			CREATE TABLE [{hos.ExecDatabase}].[dbo].[DIC_DIAG_SUMMARY](
		    [ID] [int] IDENTITY(1,1) NOT NULL,
		    [DISEASE_NAME] [nvarchar](max) NULL,
		    [ICD]  [nvarchar](max) NULL,
		    [ICD_CODE]  [nvarchar](50) NULL,
		    [I_DEPT_NAME] [nvarchar](100) NULL,
		    [F_DIAG] [nvarchar](200) NULL,
		    [S_DIAG] [nvarchar](200) NULL
		    );
            IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DIC_DIAG_GATHER')
			drop table [{hos.ExecDatabase}].[dbo].[DIC_DIAG_GATHER];
             CREATE TABLE [dbo].[DIC_DIAG_GATHER](
	         [ID] [int] IDENTITY(1,1) NOT NULL,
		     [DISEASE_NAME] [nvarchar](max) NULL,
		     [ICD_ID]  int NULL,
		     [I_ICD_CODE]  [nvarchar](50) NULL,
		     [I_DEPT_NAME] [nvarchar](100) NULL,
		     [DIAGNOSIS] [nvarchar](200) NULL,
		     [DISEASE] [nvarchar](200) NULL
	          );
		    INSERT intO [{hos.ExecDatabase}].[dbo].[DIC_DIAG_SUMMARY]([DISEASE_NAME],[ICD])select   disease_name,max(icd) from [{hos.ExecDatabase}].[dbo].[OUT_DIAG]where disease_name IS NOT NULL AND disease_name !='' group by disease_name union select   disease_name,max(icd) from [{hos.ExecDatabase}].[dbo].[INPAT_DIAG]where disease_name IS NOT NULL AND disease_name !='' group by disease_name";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);

            //复制DA_Disease这张表
            var fwq = "";
            if (hos.ExecOpenLink != "192.168.18.156")
            {
                fwq = "[192.168.18.156].";
            }
            sql = @$"
                   IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DA_Disease') drop table  [{hos.ExecDatabase}].dbo.DA_Disease;
                         SELECT * into [{hos.ExecDatabase}].dbo.DA_Disease FROM {fwq}[SV_DATA_CONFIG].[dbo].[DA_Disease];
                   IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DA_DISEASE_ICD') drop table [{hos.ExecDatabase}].[dbo].[DA_DISEASE_ICD]; 
                         SELECT * into [{hos.ExecDatabase}].dbo.DA_DISEASE_ICD FROM {fwq}[SV_DATA_CONFIG].[dbo].[DA_DISEASE_ICD];
                   IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DIC_ICD') drop table [{hos.ExecDatabase}].[dbo].[DIC_ICD]; 
                         SELECT * into [{hos.ExecDatabase}].dbo.DIC_ICD FROM {fwq}[SV_DATA_CONFIG].[dbo].[DIC_ICD];";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);

            //匹配诊断
            sql = @$"UPDATE [{hos.ExecDatabase}].[dbo].[DIC_DIAG_SUMMARY]
                     SET ICD_CODE = d.I_ICD,[F_DIAG] = d.I_CLASS_DISEASE,
                     [S_DIAG] = d.I_DISEASE, [I_DEPT_NAME] = d.I_DEPARTMENT  FROM [{hos.ExecDatabase}].[dbo].[DIC_DIAG_SUMMARY] t,
                     [{hos.ExecDatabase}].[dbo].[DA_Disease] d WHERE  t.DISEASE_NAME = d.[HOSPITAL_DISEASE] and(isnull(d.HOSPITAL_DISEASE, '') <> '');
                      
                      insert into  [{hos.ExecDatabase}].[dbo].[DIC_DIAG_GATHER](DISEASE_NAME,ICD_ID, I_ICD_CODE,I_DEPT_NAME,DIAGNOSIS,DISEASE)
	                  select [DISEASE_NAME],d.id ICD_ID,d.icd I_ICD_CODE,[DEPARTMENT] I_DEPT_NAME,[DIAGNOSIS],[DISEASE]  from 
                      (select distinct [DISEASE_NAME] from   [{hos.ExecDatabase}].[dbo].[DIC_DIAG_SUMMARY] ) a 
                      left join [{hos.ExecDatabase}].[dbo].[DA_Disease]  b on a.DISEASE_NAME=b.[HOSPITAL_DISEASE] 
                      left join [{hos.ExecDatabase}].[dbo].[DA_DISEASE_ICD]   c on b.id=c.DISEASE_ID
                      left join [{hos.ExecDatabase}].[dbo].[DIC_ICD] d on c.ICD_ID=d.ID
                      
                   ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);

            //
        }
        public void JX_DIC_FEE(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            sql = @$" IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DIC_FEE_SUMMARY')
			drop table [{hos.ExecDatabase}].[dbo].[DIC_FEE_SUMMARY];

			CREATE TABLE [{hos.ExecDatabase}].[dbo].[DIC_FEE_SUMMARY](
	           [ID] [int] IDENTITY(1,1) NOT NULL,
	           [ITEM_NAME] [nvarchar](200) NULL,
	           [CATEGORY]  [nvarchar](200) NULL,
	           [I_TYPE_NAME] [nvarchar](200) NULL,
	           [MEDIC_AREA] [nvarchar](200) NULL
	           );
            ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);
            var fwq = "";
            if (hos.ExecOpenLink != "192.168.18.156")
            {
                fwq = "[192.168.18.156].";
            }
            //复制DA_Disease这张表 
            sql = @$" INSERT intO [dbo].[DIC_FEE_SUMMARY]([ITEM_NAME],MEDIC_AREA,CATEGORY,I_TYPE_NAME)
       SELECT t2.item_name,t2.medic_area,t2.category,t1.insurance_category FROM {fwq}[DB_SV_Data_Config].dbo.DA_Hos_Category t1 RIGHT JOIN (
            SELECT category,item_name,medic_area FROM    [dbo].[OUT_FEE]  WHERE ITEM_NAME IS NOT NULL AND ITEM_NAME !='' GROUP  BY category,item_name,medic_area
                   UNION
            SELECT category,item_name,medic_area FROM [dbo].INPAT_FEE WHERE ITEM_NAME IS NOT NULL AND ITEM_NAME !='' GROUP  BY category,item_name,medic_area) t2 
         ON t1.category = t2.category";

            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);

        }
        public void JX_ADD_DA_Disease(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            var fwq = "";
            if (hos.ExecOpenLink != "192.168.18.156")
            {
                fwq = "[192.168.18.156].";
            }
            sql = @$" insert into {fwq}[SV_DATA_CONFIG].[dbo].[DA_Disease](HospitalID,[HOSPITAL_DISEASE],[IS_FILTER])
                      select DISTINCT {hos_id} ,DISEASE_NAME ,0 from [{hos.ExecDatabase}].[dbo].[DIC_DIAG_GATHER] A
                      LEFT JOIN [{hos.ExecDatabase}].[dbo].[DA_Disease] B ON A.DISEASE_NAME=B.HOSPITAL_DISEASE WHERE B.ID IS NULL;
            ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);

        }
        public void JX_DIC_DRUG_ATC(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            var fwq = "";
            if (hos.ExecOpenLink != "192.168.18.156")
            {
                fwq = "[192.168.18.156].";
            }
            sql = @$" IF EXISTS(SELECT * FROM [{hos.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'DIC_DRUG_ATC')
			drop table [{hos.ExecDatabase}].[dbo].[DIC_DRUG_ATC];
			CREATE TABLE [dbo].[DIC_DRUG_ATC](
					[ID] [int] IDENTITY(1,1) NOT NULL,
					[ITEM_NAME] [nvarchar](200) NULL,
					[TYPE_NAME] [nvarchar](200) NULL,
					[I_ITEM_NAME] [nvarchar](200) NULL,
					[ATC_CODE] [nvarchar](50) NULL,
					[MEDIC_AREA] [nvarchar](200) NULL
					);
            SELECT * into dbo.DA_Hos_Category FROM {fwq}[DB_SV_Data_Config].[dbo].[DA_Hos_Category]
					INSERT intO [dbo].[DIC_DRUG_ATC](
				    [ITEM_NAME],MEDIC_AREA,TYPE_NAME)
					SELECT DISTINCT ITEM_NAME,MEDIC_AREA,[Keyword]
					FROM [DBO].[OUT_FEE] A,[dbo].[DA_Hos_Category] C
					WHERE A.CATEGORY=C.CATEGORY AND C.insurance_category LIKE '%药%' and a.ITEM_NAME is not null
					UNION 
					SELECT DISTINCT ITEM_NAME,MEDIC_AREA,[Keyword]
					FROM [DBO].[INPAT_FEE] A,[dbo].[DA_Hos_Category] C
					WHERE A.CATEGORY=C.CATEGORY AND C.insurance_category LIKE '%药%' and a.ITEM_NAME is not null
					drop table DA_Hos_Category;
             SELECT * into dbo.DA_Drug FROM {fwq}[SV_DATA_CONFIG].[dbo].[DA_Drug]

			  update [dbo].[DIC_DRUG_ATC] 
			  set I_ITEM_NAME=b.CommonName,ATC_CODE=b.ATC
			  from [dbo].[DIC_DRUG_ATC] a,
			  {fwq}[SV_DATA_CONFIG].[dbo].[DA_Drug] b
			  where   b.CommonName is not null and b.DrugName=a.ITEM_NAME;
			  DROP TABLE DA_Drug";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);


        }
        public void JX_ADD_DA_Drug(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            var fwq = "";
            if (hos.ExecOpenLink != "192.168.18.156")
            {
                fwq = "[192.168.18.156].";
            }
            sql = @$" insert into {fwq}[SV_DATA_CONFIG].[dbo].[DA_Drug](HospitalID,[DrugName],[IsExec],[MEDIC_AREA],[ORIGINALDRUGTYPE])
	                   select DISTINCT {hos_id},ITEM_NAME,NULL,MEDIC_AREA,[TYPE_NAME] from (
	                   SELECT  distinct ITEM_NAME,a.MEDIC_AREA,[TYPE_NAME]
	                   FROM [dbo].[DIC_DRUG_ATC] a
	                   left join (select distinct drugname,medic_area from {fwq}[SV_DATA_CONFIG].[dbo].[DA_Drug] )  b on a.ITEM_NAME=b.DrugName and a.medic_area=b.medic_area
	                   where a.medic_area is  not null  and b.drugname is null 
	                   union 
	                   SELECT  distinct ITEM_NAME,a.MEDIC_AREA,[TYPE_NAME]
	                   FROM [dbo].[DIC_DRUG_ATC] a
	                   left join (select distinct drugname,medic_area from {fwq}[SV_DATA_CONFIG].[dbo].[DA_Drug] )  b on a.ITEM_NAME=b.DrugName
	                   where a.medic_area is  null and b.drugname is null ) m 
            ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            JX_zx(sql, hos_id, id, hos);

        }
        public void JX_DRUG_DATA_QZ(int id, int hos_id)
        {
            var sql = "";
            int num = 0;
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            sql = @$"   select count(1)from [SV_QueryPlatform].[dbo].[权重执行sql] where type ='药品' ";
            num = Connection(181).Query<int>(sql).FirstOrDefault();
            int i = 1;
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            for (i = 1; i < num + 1; i++)
            {
                sql = @$"  select execsql from [SV_QueryPlatform].[dbo].[权重执行sql] where type ='药品' and id={i} ";
                string zxsql = Connection(181).Query<string>(sql).FirstOrDefault();
                updatezt(id, hos_id, zxsql.Replace("'", "''"), null);
                Connection(156).Execute(zxsql, commandTimeout: 60 * 60 * 12);
            }
            sql = @$" update SV_DATA_CONFIG.[dbo].[DA_Drug] set ISEXEC = 0 where ISEXEC is null ;
	                      update SV_DATA_CONFIG.[dbo].[DA_Drug] set iscompletion = 0 where iscompletion is null";
            Connection(156).Query<int>(sql).FirstOrDefault();

        }
        public void JX_DA_DIAGNOSIS_DATA(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156).Query<SYS_Hospital>(sql).FirstOrDefault();
            sql = @$"  UPDATE [SV_DATA_CONFIG].[dbo].[DA_Disease] SET [FILTER_DISEASE] = HOSPITAL_DISEASE where IS_FILTER = 0 ;
	                   update [SV_DATA_CONFIG].[dbo].DA_DISEASE set FILTER_DISEASE = replace(FILTER_DISEASE,CHAR(13),'') where  IS_FILTER = 0 and CHARINDEX(CHAR(13),FILTER_DISEASE) > 0;
	                   update [SV_DATA_CONFIG].[dbo].DA_DISEASE set FILTER_DISEASE = replace(FILTER_DISEASE,CHAR(9),'') where IS_FILTER = 0 and  CHARINDEX(CHAR(19),FILTER_DISEASE) > 0;
	                   update [SV_DATA_CONFIG].[dbo].DA_DISEASE set FILTER_DISEASE = replace(FILTER_DISEASE,CHAR(10),'') where IS_FILTER = 0 and  CHARINDEX(CHAR(10),FILTER_DISEASE) > 0;";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            Connection(156).Execute(sql, commandTimeout: 60 * 60 * 12);

            sql = @$"  select ' update [SV_DATA_CONFIG].[dbo].DA_DISEASE 
          set FILTER_DISEASE = replace(FILTER_DISEASE,'''+[data]+''','''+[REPLACE]+''') 
		  where IS_FILTER = 0 and CHARINDEX('''+[data]+''',FILTER_DISEASE) > 0 ' from 特殊字符替换 ";
            string[] zxsqls = Connection(181).Query<string>(sql).ToArray();
            foreach (var item in zxsqls)
            {
                Connection(156).Execute(item, commandTimeout: 60 * 60 * 12);
            }

            sql = @$"   update  [SV_DATA_CONFIG].[dbo].DA_DISEASE set FILTER_DISEASE = REPLACE( FILTER_DISEASE,substring(FILTER_DISEASE,
                        charindex('(',FILTER_DISEASE),charindex(')',FILTER_DISEASE) - charindex('(',FILTER_DISEASE) +1),'') 
                        where IS_FILTER = 0 and  charindex(')',FILTER_DISEASE) > 0 and charindex('(',FILTER_DISEASE) > 0  and charindex(')',FILTER_DISEASE) >  
                        charindex('(',FILTER_DISEASE) 
                        update  [SV_DATA_CONFIG].[dbo].DA_DISEASE set I_DEPARTMENT = t2.DEPARTMENT,I_CLASS_DISEASE = t2.DIAGNOSIS, 
                        I_ICD = t2.icd,I_DISEASE = t2.DISEASE,IS_EXEC =1 , EXEC_DATE = getdate(),REMARK ='ICD全文匹配' 
                        from SV_DATA_CONFIG.dbo.DA_DISEASE t1 join SV_DATA_CONFIG.dbo.DIC_ICD t2 
                        on t1.filter_disease = t2.DISEASE and t2.STATE = 1 where t1.IS_FILTER = 0;
                        update  [SV_DATA_CONFIG].[dbo].DA_DISEASE set I_DEPARTMENT = t2.DEPARTMENT,I_CLASS_DISEASE = t2.DIAGNOSIS, 
                        I_ICD = t2.icd,I_DISEASE = t2.DISEASE,IS_EXEC =1 , EXEC_DATE = getdate(),REMARK ='ICD全文匹配' 
                        from SV_DATA_CONFIG.dbo.DA_DISEASE t1 join SV_DATA_CONFIG.dbo.DIC_ICD t2 
                        on t1.HOSPITAL_DISEASE = t2.DISEASE and t2.STATE = 1 where t1.IS_FILTER = 0
                        UPDATE  [SV_DATA_CONFIG].[dbo].[DA_Disease] SET    IS_FILTER = 1 WHERE  IS_FILTER = 0
                   ";
            Connection(156).Execute(sql, commandTimeout: 60 * 60 * 12);
        }
        public void JX_DIAGNOSIS_DATA_QZ(int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Query<SYS_Hospital>(sql).FirstOrDefault();
            sql = @$"   insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,2450 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压心脏病伴心力衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,2454 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压肾脏病不伴有肾衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,2460 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压（肾性）%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,2471 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%继发性高血压%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,2472 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%肾血管性高血压%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,26069 as icd_id from dbo.da_disease where 1=1 and (hospital_disease='48 47急性冠周炎') ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33928 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压（原发性）%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33928 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%特发性（原发性）高血压%'  and hospital_disease not like '%?%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33928 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%特发性高血压%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33929 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%原发性高血压%'  and hospital_disease not like '%?%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33930 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压1级%'  and hospital_disease not like '%?%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33930 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压Ⅰ%'  and hospital_disease not like '%?%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33931 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压2%'  and hospital_disease not like '%?%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33931 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压Ⅱ%'  and hospital_disease not like '%?%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33931 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压3%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33933 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压3%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33933 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压Ⅲ%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33934 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%单纯收缩期高血压%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33935 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压急症%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33936 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%难治性高血压%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33937 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%低肾素性高血压%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33938 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压亚急症%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33940 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%肾萎缩伴有高血压%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33941 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压心脏和肾脏病同时伴有(充血性)心力衰竭和肾衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33942 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压心脏和肾脏病伴有(充血性)心力衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33943 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压心脏病不伴有(充血性)心力衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33944 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压性心力衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          insert into da_disease_icd(disease_id,icd_id) select tab.disease_id,tab.icd_id from ( select id as disease_id,33946 as icd_id from dbo.da_disease where 1=1 and ( hospital_disease like '%高血压心脏病伴心力衰竭%'  and hospital_disease not like '%?%'   and hospital_disease not like '%待排%'  ) ) tab left join da_disease_icd t1 on t1.disease_id = tab.disease_id and t1.icd_id = tab.icd_id where t1.id is null
                          update da_disease set i_department='风湿科',i_class_disease='风湿热,未提及心脏受累',i_icd='I00.x01',i_disease='风湿性关节炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '风湿性关节炎%'update da_disease set i_department='风湿科',i_class_disease='风湿热,未提及心脏受累',i_icd='I00.x01',i_disease='风湿性关节炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '风湿性关节炎%' and is_exec is null 
                          update da_disease set i_department='风湿科',i_class_disease='风湿热,未提及心脏受累',i_icd='I00.x01',i_disease='风湿性关节炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '关节炎%'update da_disease set i_department='风湿科',i_class_disease='风湿热,未提及心脏受累',i_icd='I00.x01',i_disease='风湿性关节炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '关节炎%' and is_exec is null 
                          update da_disease set i_department='风湿科',i_class_disease='风湿热,未提及心脏受累',i_icd='I00.x01',i_disease='风湿性关节炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '急性风湿性关节炎%'update da_disease set i_department='风湿科',i_class_disease='风湿热,未提及心脏受累',i_icd='I00.x01',i_disease='风湿性关节炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '急性风湿性关节炎%' and is_exec is null 
                          update da_disease set i_department='风湿科',i_class_disease='脊椎关节强硬',i_icd='M47.822',i_disease='颈椎病',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '颈椎病%'update da_disease set i_department='风湿科',i_class_disease='脊椎关节强硬',i_icd='M47.822',i_disease='颈椎病',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '颈椎病%' and is_exec is null 
                          update da_disease set i_department='风湿科',i_class_disease='脊椎关节强硬',i_icd='M47.822',i_disease='颈椎病',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '颈椎病%'update da_disease set i_department='风湿科',i_class_disease='脊椎关节强硬',i_icd='M47.822',i_disease='颈椎病',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '颈椎病%' and is_exec is null 
                          update da_disease set i_department='风湿科',i_class_disease='其他脊椎病',i_icd='M48.921',i_disease='颈椎退行性病变',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '颈椎退行性病变%'update da_disease set i_department='风湿科',i_class_disease='其他脊椎病',i_icd='M48.921',i_disease='颈椎退行性病变',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '颈椎退行性病变%' and is_exec is null 
                          update da_disease set i_department='骨科',i_class_disease='其他椎间盘疾患',i_icd='M51.202',i_disease='腰椎间盘突出',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '腰椎间盘突出%'update da_disease set i_department='骨科',i_class_disease='其他椎间盘疾患',i_icd='M51.202',i_disease='腰椎间盘突出',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '腰椎间盘突出%' and is_exec is null 
                          update da_disease set i_department='骨科',i_class_disease='腰椎和骨盆关节和韧带脱位,扭伤和劳损',i_icd='S33.501',i_disease='腰部扭伤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '腰部扭伤%'update da_disease set i_department='骨科',i_class_disease='腰椎和骨盆关节和韧带脱位,扭伤和劳损',i_icd='S33.501',i_disease='腰部扭伤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '腰部扭伤%' and is_exec is null 
                          update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '右上肺炎%'update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '右上肺炎%' and is_exec is null 
                          update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '右下肺炎%'update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '右下肺炎%' and is_exec is null 
                          update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '左上肺炎%'update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '左上肺炎%' and is_exec is null 
                          update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '左下肺炎%' and is_exec is null
                          update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '左下肺炎%'update da_disease set i_department='呼吸科',i_class_disease='肺炎,病原体未特指',i_icd='J18',i_disease='肺炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and  filter_disease like '左下肺炎%' and is_exec is null 
                          update da_disease set i_department='呼吸科',i_class_disease='慢性阻塞性肺病',i_icd='J44.103',i_disease='慢性阻塞性肺病伴急性加重',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like 'AECOPD%'update da_disease set i_department='呼吸科',i_class_disease='慢性阻塞性肺病',i_icd='J44.103',i_disease='慢性阻塞性肺病伴急性加重',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like 'AECOPD%' and is_exec is null 
                          update da_disease set i_department='呼吸科',i_class_disease='慢性阻塞性肺病',i_icd='J44.901',i_disease='慢性阻塞性肺病',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like 'COPD%'update da_disease set i_department='呼吸科',i_class_disease='慢性阻塞性肺病',i_icd='J44.901',i_disease='慢性阻塞性肺病',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like 'COPD%' and is_exec is null 
                          update da_disease set i_department='口腔科',i_class_disease='龈炎和牙周疾病',i_icd='K05.203',i_disease='急性牙周炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like 'a牙周炎%'update da_disease set i_department='口腔科',i_class_disease='龈炎和牙周疾病',i_icd='K05.203',i_disease='急性牙周炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like 'a牙周炎%' and is_exec is null 
                          update da_disease set i_department='泌尿外科',i_class_disease='前列腺炎性疾病',i_icd='N41.001',i_disease='急性前列腺炎',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '急性前列腺炎%'  and is_exec is null
                          update da_disease set i_department='泌尿外科',i_class_disease='前列腺炎性疾病',i_icd='N41.101',i_disease='慢性前列腺炎',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '慢性前列腺炎%'  and is_exec is null
                          update da_disease set i_department='泌尿外科',i_class_disease='前列腺炎性疾病',i_icd='N41.901',i_disease='前列腺炎',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '前列腺炎%'  and is_exec is null
                          update da_disease set i_department='普外科',i_class_disease='结肠恶性肿瘤',i_icd='C18.2',i_disease='升结肠恶性肿瘤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '%升结肠恶性肿瘤%'
                          update da_disease set i_department='普外科',i_class_disease='结肠恶性肿瘤',i_icd='C18.3',i_disease='结肠肝曲恶性肿瘤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '%结肠肝曲恶性肿瘤%'
                          update da_disease set i_department='普外科',i_class_disease='结肠恶性肿瘤',i_icd='C18.4',i_disease='横结肠恶性肿瘤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '%横结肠恶性肿瘤%'
                          update da_disease set i_department='普外科',i_class_disease='结肠恶性肿瘤',i_icd='C18.5',i_disease='结肠脾曲恶性肿瘤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '%结肠脾曲恶性肿瘤%'
                          update da_disease set i_department='普外科',i_class_disease='结肠恶性肿瘤',i_icd='C18.6',i_disease='降结肠恶性肿瘤',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '%降结肠恶性肿瘤%'
                          update da_disease set i_department='消化科',i_class_disease='霍乱',i_icd='A00',i_disease='霍乱',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '霍乱%' and filter_disease not like '%接触%' and filter_disease not like '%菌%' and filter_disease not like '%疫苗%'update da_disease set i_department='消化科',i_class_disease='霍乱',i_icd='A00',i_disease='霍乱',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '霍乱%' and filter_disease not like '%接触%' and filter_disease not like '%菌%' and filter_disease not like '%疫苗%' and is_exec is null 
                          update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25',i_disease='胃溃疡',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '胃溃疡%'update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25',i_disease='胃溃疡',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '胃溃疡%' and is_exec is null 
                          update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.301',i_disease='急性胃溃疡',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '急性胃溃疡%'update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.301',i_disease='急性胃溃疡',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '急性胃溃疡%' and is_exec is null 
                          update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.401',i_disease='胃溃疡伴出血',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '胃溃疡伴出血%'update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.401',i_disease='胃溃疡伴出血',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '胃溃疡伴出血%' and is_exec is null 
                          update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.501',i_disease='胃溃疡伴穿孔',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '胃溃疡伴穿孔%'update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.501',i_disease='胃溃疡伴穿孔',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '胃溃疡伴穿孔%' and is_exec is null 
                          update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.701',i_disease='慢性胃溃疡',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '慢性胃溃疡%'update da_disease set i_department='消化科',i_class_disease='胃溃疡',i_icd='K25.701',i_disease='慢性胃溃疡',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and filter_disease like '慢性胃溃疡%' and is_exec is null 
                          update da_disease set i_department='消化科',i_class_disease='胃炎和十二指肠炎',i_icd='K29',i_disease='胃炎和十二指肠炎',is_exec=1,exec_date=getdate(),remark='后台人工处理' where 1=1 and hospital_disease like '胃炎%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x04',i_disease='高血压I期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%'  and hospital_disease like '%高血压1%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x04',i_disease='高血压I期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%'  and hospital_disease like '%高血压I%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x04',i_disease='高血压I期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%' and hospital_disease like '%高血压1级%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x05',i_disease='高血压Ⅱ期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%'  and hospital_disease like '%高血压3%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x05',i_disease='高血压Ⅱ期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%'  and hospital_disease like '%高血压II%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x05',i_disease='高血压Ⅱ期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%' and hospital_disease like '%高血压2级%' and is_exec is null
                          update da_disease set i_department='心内科',i_class_disease='高血压病',i_icd='I10.x06',i_disease='高血压Ⅲ期',is_exec=1,exec_date=getdate() where 1=1 and filter_disease like '高血压%' and hospital_disease like '%高血压3级%' and is_exec is null
                   ";
            Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Execute(sql, commandTimeout: 60 * 60 * 12);
            sql = $@"update SV_DATA_CONFIG.dbo.da_disease set i_department=t2.DEPARTMENT,i_class_disease=t2.DIAGNOSIS,i_icd=t2.ICD,i_disease=t2.DISEASE,is_exec=2,exec_date=getdate(),
                     REMARK = 'sql脚本执行'  FROM SV_DATA_CONFIG.dbo.DA_Disease T1 JOIN (select distinct DEPARTMENT,ICD,diagnosis,disease from SV_DATA_CONFIG.dbo.DIC_ICD where state = 1 ) T2 ON   
                     T1.filter_disease like '%'+t2.disease+'%' and t1.hospital_disease like '%'+t2.disease+'%' where  t1.is_exec is null ;
                     
                     INSERT intO SV_DATA_CONFIG.[dbo].[DA_DISEASE_ICD] (DISEASE_ID,ICD_ID)
			         SELECT A.ID,B.ID FROM SV_DATA_CONFIG.DBO.DA_Disease A
			         JOIN SV_DATA_CONFIG.DBO.DIC_ICD B ON A.I_ICD = B.ICD
			         WHERE  A.IS_EXEC = 2 AND A.I_ICD IS NOT NULL;
                     
                     update SV_DATA_CONFIG.DBO.DA_Disease set is_exec = 1 where IS_EXEC = 2;
                     
                     update SV_DATA_CONFIG.dbo.DA_Disease set IS_EXEC = 0 where IS_EXEC is null ;";

            Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Execute(sql, commandTimeout: 60 * 60 * 12);
        }
        public void JX_REMATCH_DIAG(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();

            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Query<SYS_Hospital>(sql).FirstOrDefault();
            服务器 fwq = Connection(181).Query<服务器>($"SELECT   [服务器ip],[数据库账号],[数据库密码] FROM[SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);

            sql = $@" 
		 UPDATE [dbo].[DIC_DIAG_GATHER] SET [ICD_ID]=T.ICD_ID ,[I_ICD_CODE]=T.I_ICD_CODE ,[I_DEPT_NAME]=T.I_DEPT_NAME ,[DIAGNOSIS]=T.DIAGNOSIS ,[DISEASE]=T.DISEASE   
         FROM (select [DISEASE_NAME],d.id ICD_ID,d.icd I_ICD_CODE,[DEPARTMENT] I_DEPT_NAME,[DIAGNOSIS],[DISEASE]  from 
           (select distinct [DISEASE_NAME] from   [dbo].[DIC_DIAG_GATHER] )a left join [dbo].[DA_Disease]  b on a.DISEASE_NAME=b.[HOSPITAL_DISEASE] 
           left join [dbo].[DA_DISEASE_ICD]   c on b.id=c.DISEASE_ID left  join [dbo].[DIC_ICD] d on c.ICD_ID=d.ID
         WHERE (isnull(B.HOSPITAL_DISEASE,'')<>'')) T
		 WHERE T.[DISEASE_NAME]=[DIC_DIAG_GATHER].[DISEASE_NAME]; 
		  DROP TABLE DA_Disease
		  DROP TABLE DA_DISEASE_ICD
		  DROP TABLE DIC_ICD";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            Connection(0, msConnectionString).Execute(sql, commandTimeout: 60 * 60 * 12);
        }
        public void JX_UPDATE_REG_INFO(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Query<SYS_Hospital>(sql).FirstOrDefault();
            服务器 fwq = Connection(181).Query<服务器>($"SELECT   [服务器ip],[数据库账号],[数据库密码] FROM[SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);

            sql = $@" SELECT REG_ID, [I_DEPT_NAME],DIAGNOSIS intO OUT_TABLE
          FROM  (SELECT M.REG_ID,M.DISEASE_NAME,M.ICD_ID,M.I_ICD_CODE,M.I_DEPT_NAME,M.DIAGNOSIS,M.DISEASE 
               FROM (SELECT REG_ID,DIAG_ID,T.* FROM OUT_DIAG A JOIN
         (SELECT A.* FROM [dbo].[DIC_DIAG_GATHER] A 
                    JOIN (SELECT DISEASE_NAME,MAX(ID) ID  
	           FROM [dbo].[DIC_DIAG_GATHER] WHERE ICD_ID IS NOT NULL
	                GROUP BY DISEASE_NAME) B
                    ON A.ID=B.ID) T
                    ON A.DISEASE_NAME=T.DISEASE_NAME) M JOIN
         (SELECT REG_ID,DIAG_TIME,MIN(DIAG_ID) DIAG_ID        ---一对多的取时间最小且有标准值的诊断
	           FROM OUT_DIAG A JOIN  (SELECT A.* FROM [dbo].[DIC_DIAG_GATHER] A 
                    JOIN (SELECT DISEASE_NAME,MAX(ID) ID      ---一对多的取最大的ID
	           FROM [dbo].[DIC_DIAG_GATHER] WHERE ICD_ID IS NOT NULL
	                GROUP BY DISEASE_NAME) B
                    ON A.ID=B.ID) T
                    ON A.DISEASE_NAME=T.DISEASE_NAME
                    GROUP BY REG_ID,DIAG_TIME) N
                    ON M.DIAG_ID=N.DIAG_ID ) TT

		UPDATE [dbo].[OUT_REG_INFO] SET [I_DEPT_NAME]=NULL,[F_DIAG]=NULL;
         UPDATE [dbo].[OUT_REG_INFO]
    SET    [I_DEPT_NAME] = B.[I_DEPT_NAME],
		   [F_DIAG] = B.DIAGNOSIS
		   FROM OUT_TABLE B WHERE [OUT_REG_INFO].REG_ID = B.REG_ID

		   DROP TABLE OUT_TABLE

   
 

	SELECT REG_ID,[I_DEPT_NAME],DIAGNOSIS intO INPAT_TABLE
	FROM
        (SELECT M.REG_ID,M.DISEASE_NAME,M.ICD_ID,M.I_ICD_CODE,M.I_DEPT_NAME,M.DIAGNOSIS,M.DISEASE 
             FROM (SELECT REG_ID,DIAG_ID,T.* FROM INPAT_DIAG A JOIN
        (SELECT A.* FROM [dbo].[DIC_DIAG_GATHER] A 
                 JOIN (SELECT DISEASE_NAME,MAX(ID) ID 
	         FROM [dbo].[DIC_DIAG_GATHER] WHERE ICD_ID IS NOT NULL
	             GROUP BY DISEASE_NAME) B
                 ON A.ID=B.ID) T
                 ON A.DISEASE_NAME=T.DISEASE_NAME) M JOIN
       (SELECT REG_ID,DIAG_TIME,MIN(DIAG_ID)DIAG_ID FROM INPAT_DIAG A JOIN
       (SELECT A.* FROM [dbo].[DIC_DIAG_GATHER] A 
                 JOIN (SELECT DISEASE_NAME,MAX(ID) ID 
	         FROM [dbo].[DIC_DIAG_GATHER] WHERE ICD_ID IS NOT NULL
	             GROUP BY DISEASE_NAME) B
                 ON A.ID=B.ID) T
                 ON A.DISEASE_NAME=T.DISEASE_NAME
                 GROUP BY REG_ID,DIAG_TIME) N
                 ON M.DIAG_ID=N.DIAG_ID ) T

UPDATE [dbo].[INPAT_REG_INFO] SET [I_DEPT_NAME]=NULL,[F_DIAG]=NULL;
		   UPDATE [dbo].[INPAT_REG_INFO]
    SET    [I_DEPT_NAME] = B.[I_DEPT_NAME],
		   [F_DIAG] = B.DIAGNOSIS
		   FROM INPAT_TABLE B WHERE [INPAT_REG_INFO].REG_ID = B.REG_ID

		   DROP TABLE INPAT_TABLE";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            Connection(0, msConnectionString).Execute(sql, commandTimeout: 60 * 60 * 12);
        }
        public void JX_REMOVE_CARD_TYPE(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Query<SYS_Hospital>(sql).FirstOrDefault();
            服务器 fwq = Connection(181).Query<服务器>($"SELECT   [服务器ip],[数据库账号],[数据库密码] FROM[SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);

            var fwqip = hos.ExecOpenLink=="192.168.18.156"?"" :@$"[{hos.ExecOpenLink}].";

            sql = $@"  
                    INSERT intO DB_SV_DATA_CONFIG.[dbo].[DA_CARD_TYPE]
						(CARDTYPE,[HOS_CODE],update_time)
						SELECT t2.CARD_TYPE,t2.ORG_CODE,getdate()
						FROM   DB_SV_DATA_CONFIG.dbo.[DA_CARD_TYPE] t1
							   RIGHT JOIN (
                               SELECT CARD_TYPE,ORG_CODE
							   FROM {fwqip}[{hos.ExecDatabase}].[DBO].[OUT_REG_INFO] a
							   GROUP  BY a.CARD_TYPE,a.ORG_CODE
							   UNION
							   SELECT CARD_TYPE,ORG_CODE
							   FROM {fwqip}[{hos.ExecDatabase}].[DBO].[INPAT_REG_INFO] b
							   GROUP  BY b.CARD_TYPE,b.ORG_CODE) t2
						   ON t1.CARDTYPE = t2.CARD_TYPE
							WHERE  t1.id  IS NULL and t2.CARD_TYPE is not null; ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Execute(sql, commandTimeout: 60 * 60 * 12);
            sql = $@"UPDATE DB_SV_DATA_CONFIG.[dbo].[DA_CARD_TYPE] SET SOURCE=(case when CARDTYPE LIKE '%农%' then '1'
					    when (CARDTYPE like '%保%' or CARDTYPE like '%合%疗%' or CARDTYPE like '%居民%'or CARDTYPE like '%职工%') then '2' else '0' end) where [SOURCE] is null ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Execute(sql, commandTimeout: 60 * 60 * 12);

            sql = $@" UPDATE [DBO].[OUT_REG_INFO] SET I_CARD_TYPE=
				( CASE WHEN [CARD_TYPE]like '%农%'or [CARD_TYPE] like '%合%疗%' or [CARD_TYPE] like '%保%' or CARD_TYPE like '%居民%' or CARD_TYPE like '%职工%'
				THEN  '医保' ELSE '自费' END )
				 
				UPDATE [DBO].[INPAT_REG_INFO] SET I_CARD_TYPE=
				( CASE WHEN [CARD_TYPE]like '%农%'or [CARD_TYPE] like '%合%疗%' or [CARD_TYPE] like '%保%' or CARD_TYPE like '%居民%' or CARD_TYPE like '%职工%'
				THEN  '医保' ELSE '自费' END )

				UPDATE [DBO].[OUT_REG_INFO] SET I_CARD_TYPE='自费' WHERE CARD_TYPE IS NULL;
				UPDATE [DBO].[INPAT_REG_INFO] SET I_CARD_TYPE='自费' WHERE CARD_TYPE IS NULL; ";
            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            Connection(0, msConnectionString).Execute(sql, commandTimeout: 60 * 60 * 12);
        }
        public void JX_INSERT_CATEGORY(int id, int hos_id)
        {
            var sql = "";
            SYS_Hospital hos = new SYS_Hospital();
            sql = @$"  SELECT  DISTINCT ExecOpenLink , ExecDatabase FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A  WHERE  id ={hos_id}; ";
            hos = Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Query<SYS_Hospital>(sql).FirstOrDefault();
            服务器 fwq = Connection(181).Query<服务器>($"SELECT   [服务器ip],[数据库账号],[数据库密码] FROM[SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
            var fwqip =  "192.168.18.156" ;
            sql = $@"INSERT intO [DB_SV_Data_Config].[dbo].[DA_Hos_Category]
                                ([category],[HospitalID])
                    SELECT t2.category,org_code
                    FROM   [DB_SV_Data_Config].dbo.DA_Hos_Category t1
                           RIGHT JOIN (SELECT category,org_code
                                       FROM   [{hos.ExecOpenLink}].[{hos.ExecDatabase}].[dbo].[OUT_FEE]
                                       GROUP  BY category,org_code
                                       UNION
                                       SELECT category,org_code
                                       FROM    [{hos.ExecOpenLink}].[{hos.ExecDatabase}].[dbo].INPAT_FEE
                                       GROUP  BY category,org_code) t2
                                   ON t1.category = t2.category
                    WHERE  t1.id IS NULL and t2.category is not null;";

            updatezt(id, hos_id, sql.Replace("'", "''"), null);
            int num = Connection(156, "DB_SV_Data_Config", "SV_DATA_CONFIG").Execute(hos.ExecOpenLink == "192.168.18.156"?sql.Replace("[192.168.18.156].",""):sql, commandTimeout: 60 * 60 * 12);
            if (num > 0)
            {
               updatezt(id, hos_id, sql.Replace("'", "''"),@$"您有category未分类，请到156配置库下添加category！！！select*from [192.168.18.156].[DB_SV_Data_Config].[dbo].[DA_Hos_Category] where HospitalID={hos_id}");
            }
            sql = $@"UPDATE [dbo].[OUT_FEE] 
		SET I_TYPE_NAME = B.insurance_category 
		FROM [dbo].[OUT_FEE] t LEFT JOIN [192.168.18.156].DB_SV_DATA_CONFIG.[dbo].[DA_Hos_Category] B 
		ON B.CATEGORY=t.CATEGORY;

		UPDATE [dbo].[INPAT_FEE] 
		SET I_TYPE_NAME = B.insurance_category 
		FROM [dbo].[INPAT_FEE] t LEFT JOIN [192.168.18.156].DB_SV_DATA_CONFIG.[dbo].[DA_Hos_Category] B 
		ON B.CATEGORY=t.CATEGORY; 

		UPDATE [dbo].[OUT_FEE] 
		SET I_TYPE_NAME = B.Keyword
		FROM [dbo].[OUT_FEE] t LEFT JOIN [192.168.18.156].DB_SV_DATA_CONFIG.[dbo].[DA_Hos_Category] B 
		ON B.CATEGORY=t.CATEGORY
		where I_TYPE_NAME = '挂号/诊查费'  or  I_TYPE_NAME = '手术/麻醉费'  or  I_TYPE_NAME = '床位/护理费'

		UPDATE [dbo].[INPAT_FEE] 
		SET I_TYPE_NAME = B.Keyword 
		FROM [dbo].[INPAT_FEE] t LEFT JOIN [192.168.18.156].DB_SV_DATA_CONFIG.[dbo].[DA_Hos_Category] B 
		ON B.CATEGORY=t.CATEGORY
		where I_TYPE_NAME = '挂号/诊查费'  or  I_TYPE_NAME = '手术/麻醉费'  or  I_TYPE_NAME = '床位/护理费'";
            Connection(0, msConnectionString).Execute(hos.ExecOpenLink == "192.168.18.156" ? sql.Replace("[192.168.18.156].", "") : sql, commandTimeout: 60 * 60 * 12);
        }
    }
}
