﻿using System;
using System.Collections.Generic;
using System.IO;

public class DirectoryTree
{
    public class FileSystemItem
    {
        public string Name { get; set; }
        public string Type { get; set; } // 对于文件，这是扩展名；对于文件夹，可以是"Folder"  
        public List<FileSystemItem> Children { get; set; } = new List<FileSystemItem>();

        public FileSystemItem(string name, string type)
        {
            Name = name;
            Type = type;
        }
    }
    public FileSystemItem GetDirectoryTree(string rootPath)
    {
        var rootItem = new FileSystemItem(Path.GetFileName(rootPath), "Folder");
        FillDirectoryTree(rootPath, rootItem);
        return rootItem;
    }
    private void FillDirectoryTree(string path, FileSystemItem parent)
    {
        try
        {
            foreach (var dir in Directory.GetDirectories(path))
            {
                var dirInfo = new DirectoryInfo(dir);
                var dirItem = new FileSystemItem(dirInfo.Name, "Folder");
                parent.Children.Add(dirItem);
                FillDirectoryTree(dir, dirItem); // 递归调用  
            }

            foreach (var file in Directory.GetFiles(path))
            {
                var fileInfo = new FileInfo(file);
                var fileItem = new FileSystemItem(fileInfo.Name, fileInfo.Extension.TrimStart('.'));
                parent.Children.Add(fileItem);
            }
        }
        catch (Exception ex)
        {
            // 处理异常，例如记录日志  
            Console.WriteLine($"Error accessing directory: {ex.Message}");
        }
    }
}