﻿using Dapper;
using DocumentFormat.OpenXml.Wordprocessing;
using HtmlAgilityPack;
using Microsoft.Data.SqlClient;
using NPoco;
using QueryPlatform.Api.Infrastructure.Modules;
using System;
using System.Collections.Generic;
using System.Data.Common;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Web;

namespace QueryPlatform.Api.Infrastructure.Queries
{

    public class DrugqueryQueries
    {
        private readonly string _Connection156;
        private readonly string _configConnectionString;
        public DrugqueryQueries(string Connection156, string configConnectionString)
        {
            _Connection156 = Connection156;
            _configConnectionString = configConnectionString;
        }

        /// <summary>
        /// 查询所有医院
        /// </summary>
        /// <returns></returns>
        public List<SYS_Hospital> showHospitals()
        {
            DbConnection connection156 = new SqlConnection(_Connection156);

            // sys_hospital156找医院
            var sql = @$"SELECT
                         ExecOpenLink ,
                         ExecDatabase
                      FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital]
                      WHERE ExecOpenLink <>'' AND ExecOpenLink IS NOT NULL 
                      AND ExecDatabase <>'' AND ExecDatabase IS NOT NULL 
                      ";
            return connection156.Query<SYS_Hospital>(sql).ToList();


        }
        /// <summary>
        /// 获取到最大的那条记录Complete_MarkId
        /// </summary>
        /// <returns></returns>
        public long Complete_MarkId(long Indexs)
        {
            DbConnection configConnection = new SqlConnection(_configConnectionString);
            return configConnection.Query<long>(@$"select COMPLETE_MARK from  [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where id={Indexs} ").FirstOrDefault();
        }
        public long ASSAY_Complete_MarkId(int id)
        {
            DbConnection configConnection = new SqlConnection(_configConnectionString);
            return configConnection.Query<long>(@$"select COMPLETE_MARK from  [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD_ASSAY] where id={id} ").FirstOrDefault();
        }
        /// <summary>
        ///传入sql 连接 返回long
        /// </summary>
        /// <returns></returns>
        public long Countnum(string sql, DbConnection configConnection)
        {
            long c = configConnection.Query<long>(sql, commandTimeout: 1000000).FirstOrDefault();
            return c;
        }
        public long SqlAdd(SYS_Drugquery sYS_Drugquery, long type, string zxr)
        {
            string peojectName = sYS_Drugquery.peojectName;
            string drugName = "";
            string diseaseName = "";
            string icd = "";
            string lx = "";

            if (type == 1)
            {
                lx = "疾病"; if (sYS_Drugquery.diseaseName != null) foreach (var item in sYS_Drugquery.diseaseName) { diseaseName = string.Join(",", sYS_Drugquery.diseaseName); }
                if (sYS_Drugquery.icd != null) foreach (var item in sYS_Drugquery.icd) { icd = string.Join(",", sYS_Drugquery.icd); }
            }
            else if (type == 2) { lx = "药品"; foreach (var item in sYS_Drugquery.drugName) { drugName = string.Join(",", sYS_Drugquery.drugName); } }
            else if (type == 3) { lx = "材料"; foreach (var item in sYS_Drugquery.materialName) { drugName = string.Join(",", sYS_Drugquery.materialName); } }
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = @$"INSERT into [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD]([HOS_TYPE],[PROJECT_NAME],[GENERIC_NAME],[COMMODITY_NAME],[DISEASE_NAME],[ICD],
                        [COMPLETE_MARK],[search_time],type ,[TYPE1_2],zxr )
                        VALUES(0,'{peojectName}','{drugName}',null,'{diseaseName}',
                        '{icd}',0,getdate(),'{lx}','{sYS_Drugquery.type1_2}','{zxr}')";
            connection.Execute(sql, commandTimeout: 60 * 60 * 5);

            sql = @$"select max(id) from  [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] 
                      where PROJECT_NAME='{peojectName}' and GENERIC_NAME='{drugName}' and DISEASE_NAME='{diseaseName}' 
                        and icd='{icd}' and type='{lx}' and  [TYPE1_2]='{sYS_Drugquery.type1_2}'";
            long num = connection.Query<long>(sql).FirstOrDefault();

            //添加一条查询记录 
            sql = $@"CREATE TABLE [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{num}](
                         	[ID] [int] IDENTITY(1,1) NOT NULL,
                         	[HOS_ID] [int] NULL,
                         	[MASTER_INDEX] [int] NULL,
                         	[BIRTHDAY] [datetime2](7) NULL,
                         	[SEX] [nvarchar](50) NULL,
                         	[PERSON_CODE] [nvarchar](50) NULL,
                         	[PERSON_ID] [int] NULL,
                         	[REG_CODE] [nvarchar](50) NULL,
                         	[REG_ID] [int] NULL,
                         	[REG_SOURCE] [nvarchar](50) NULL,
                         	[REG_TIME] [datetime2](7) NULL,
                            [OUTHOS_TIME] [datetime2](7) NULL,
                         	[AREA_ID] [int] NULL,
                         	[INDEXS] [int] NULL,
                         	[TYPE] [int] NULL,
                         	[DEPT_NAME] [nvarchar](50) NULL,
                         	[MEDIC_AREA] [nvarchar](max) NULL,
                  CONSTRAint [PK_MEDIC_PERSON_INFORMATIONaa_{num}] PRIMARY KEY CLUSTERED 
                 (
                 	[ID] ASC
                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                 ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]  
                ";
            connection.Execute(sql, commandTimeout: 60 * 60 * 5);

            sql = $@"CREATE TABLE [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{num}](
                          	[ID] [int] IDENTITY(1,1) NOT NULL,
                          	[HOS_ID] [int] NULL,
                          	[ITEM_NAME] [nvarchar](500) NULL,
                          	[MEDIC_AREA] [nvarchar](500) NULL,
                          	[TYPE] [int] NULL,
                          	[INDEXS] [nvarchar](50) NULL,
                          	[MEDIC_NAME] [nvarchar](50) NULL
                          ) ON [PRIMARY]";
            connection.Execute(sql, commandTimeout: 60 * 60 * 5);

            return num;
        }
        public void updateCOMPLETE_MARK(long Indexs, long COMPLETE_MARK)
        {
            DbConnection configConnection = new SqlConnection(_configConnectionString);
            if (COMPLETE_MARK == 22)
            {
                configConnection.Execute(@$"
      EXEC	 SV_QueryPlatform_.[dbo].[MEDIC_PERSON_INFORMATION处理] @indexs ={Indexs}
     update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] set COMPLETE_MARK = 22,END_TIME=getdate() where  COMPLETE_MARK != 22 and id= {Indexs}", commandTimeout: 60 * 60 * 5);
            }
            if (COMPLETE_MARK == 21)
            {
                configConnection.Execute(@$"update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] set COMPLETE_MARK=21 where COMPLETE_MARK =0 and id={Indexs}");
            }
        }
        public void Diseasequery(long type1_2, string icd_or_diseaseCondition, long Indexs, long ip, string zxr)
        {
            var where = "";
            long num = 0;
            long CompleteMar = 0;
            DbConnection configConnection = new SqlConnection(_configConnectionString);
            if (ip == 1)
            {
                where = @$"and ExecOpenLink in ('192.168.18.151', '192.168.18.152', '192.168.18.153') ";
            }
            else if (ip == 2)
            {
                where = @$"and ExecOpenLink  in ('192.168.18.154', '192.168.18.155', '192.168.18.156')";
            }
            else if (ip == 3)
            {
                where = @$"and ExecOpenLink  in ('192.168.18.157', '192.168.18.158')";
            }
            else if (ip == 4)
            {
                where = "and ExecOpenLink not in ('192.168.18.151', '192.168.18.152', '192.168.18.153','192.168.18.154', '192.168.18.155', '192.168.18.156','192.168.18.157', '192.168.18.158')";
            }
            List<SYS_Hospital> hos = configConnection.Query<SYS_Hospital>(@$"SELECT ExecOpenLink ,ExecDatabase FROM  [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] 
                 WHERE  ExecOpenLink <>'' AND ExecOpenLink IS NOT NULL AND ExecDatabase <>'' AND ExecDatabase IS NOT NULL {where}", commandTimeout: 1000000).ToList();
            服务器 fwq = new 服务器();
            var msConnectionString = "";
            foreach (var item in hos)
            {
                var fwqsql = $"SELECT  [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where [服务器ip] ='{item.ExecOpenLink}'";
                fwq = configConnection.Query<服务器>(fwqsql).FirstOrDefault();
                msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", item.ExecOpenLink, item.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
                var sql2 = "";
                using (DbConnection conn = new SqlConnection(msConnectionString))
                {
                    //获取MEDIC_SEARCH_RECORD表的id和COMPLETE_MARK 
                    CompleteMar = Complete_MarkId(Indexs);
                    if (CompleteMar == 23)
                    {
                        throw new DomainException("查询失败！！");
                    }
                    if (CompleteMar == 31)
                    {
                        throw new DomainException("查询取消！！");
                    }
                    try
                    {
                        //判断状态 21在执行
                        if (CompleteMar == 21)
                        {
                            if (Countnum($@"SELECT count(*) FROM {item.ExecDatabase}.dbo.SYSOBJECTS WHERE NAME = 'DIC_DIAG_SUMMARY'", conn) > 0)
                            {
                                if (Countnum($@"SELECT count(*) a FROM {item.ExecDatabase}.[dbo].[DIC_DIAG_SUMMARY]  where {icd_or_diseaseCondition} ", conn) > 0)
                                {
                                    sql2 = $@" IF EXISTS(SELECT * FROM [{item.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'MEDIC_PERSON_INFORMATION_{Indexs}')
			                               drop  table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs};
                  					     SELECT C.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,A.REG_CODE,A.REG_ID,1 REG_SOURCE,A.REG_TIME,NULL OUTHOS_TIME, {Indexs}Indexs,a.org_Code hos_id,C.BIRTHDAY,C.SEX,1 TYPE,A.DEPT_NAME 
                                         into [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs} 
                                         FROM  {item.ExecDatabase}.[DBO].OUT_REG_INFO A ,
                  		                 (SELECT DISTINCT REG_CODE FROM {item.ExecDatabase}.[DBO].OUT_DIAG WHERE  {icd_or_diseaseCondition}) B,
                  				         {item.ExecDatabase}.[DBO].PUB_PATIENT C 
                                         WHERE A.REG_CODE=B.REG_CODE AND   A.PERSON_CODE=C.PERSON_CODE
                  					     UNION ALL
                  					     SELECT C.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,A.REG_CODE,A.REG_ID,2 REG_SOURCE,A.INHOS_TIME,A.OUTHOS_TIME,{Indexs},a.org_Code hos_id,C.BIRTHDAY,C.SEX,1 TYPE,A.OUT_DEPT_NAME
                                         FROM {item.ExecDatabase}.[DBO].INPAT_REG_INFO A , 
                                         (SELECT DISTINCT REG_CODE FROM  {item.ExecDatabase}.[DBO].INPAT_DIAG WHERE {icd_or_diseaseCondition}) B,
                  				         {item.ExecDatabase}.[DBO].PUB_PATIENT C
                  					     WHERE A.REG_CODE=B.REG_CODE AND   A.PERSON_CODE=C.PERSON_CODE";
                                    conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                    sql2 = $@" insert into [SV_QueryPlatform_].[dbo].MEDIC_PERSON_INFORMATION_{Indexs} 
                                          ( [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],
                                                 [REG_TIME],OUTHOS_TIME, AREA_ID,[INDEXS],[TYPE],[DEPT_NAME] )
                                         SELECT [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],
                                                 [REG_TIME],OUTHOS_TIME,null AREA_ID,[INDEXS],[TYPE],[DEPT_NAME]  
                                         From [{item.ExecOpenLink}].[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}";
                                    num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                    //LOG($"查询成功，{num}行", $"{ITEM}", Indexs, "查询平台", "");

                                    if (type1_2 == 2)
                                    {
                                        sql2 = $@"IF EXISTS(SELECT * FROM [{item.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'MEDIC_PERSON_INFORMATION_{Indexs}_2')
			                                    drop  table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2;
                                                SELECT A.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,B.REG_CODE,B.REG_ID,1 REG_SOURCE,B.REG_TIME,NULL OUTHOS_TIME,A.BIRTHDAY,A.SEX,2 TYPE, {Indexs} Indexs , b.org_code hos_id,B.DEPT_NAME  into [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2
                                                FROM {item.ExecDatabase}.[DBO].PUB_PATIENT A, {item.ExecDatabase}.[DBO].OUT_REG_INFO B,
                                                (SELECT DISTINCT MASTER_INDEX FROM {item.ExecDatabase}.[DBO].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS= {Indexs} AND HOS_ID =  cast(right('{item.ExecDatabase}',3)as int)) C  
                                                WHERE A.PERSON_CODE=B.PERSON_CODE AND  A.MASTER_INDEX=C.MASTER_INDEX  
                                                UNION ALL
                                                SELECT A.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,B.REG_CODE,B.REG_ID,2 REG_SOURCE,B.INHOS_TIME,B.OUTHOS_TIME,A.BIRTHDAY,A.SEX,2 TYPE,{Indexs} , b.org_code,B.OUT_DEPT_NAME
                                                FROM {item.ExecDatabase}.[DBO].PUB_PATIENT A, {item.ExecDatabase}.[DBO].INPAT_REG_INFO B,
                                                (SELECT DISTINCT MASTER_INDEX FROM {item.ExecDatabase}.[DBO].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS={Indexs} AND HOS_ID =   cast(right('{item.ExecDatabase}',3)as int)) C
                                                WHERE A.PERSON_CODE=B.PERSON_CODE AND A.MASTER_INDEX=C.MASTER_INDEX ;";
                                        conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@"INSERT into [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}]([HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],OUTHOS_TIME,AREA_ID,[INDEXS],[TYPE],[DEPT_NAME])
                                                     select [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],OUTHOS_TIME,null,
                                                    [INDEXS],[TYPE],[DEPT_NAME] 
                                                     From [{item.ExecOpenLink}].[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2";
                                        num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@"  DELETE FROM M  FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}] M  
                                                    INNER JOIN (SELECT * FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS = {Indexs} 
                                                    AND HOS_ID =cast(right('{item.ExecDatabase}',3)as int) AND TYPE = 1) N  
                                                    ON M.INDEXS = N.INDEXS  AND M.HOS_ID = N.HOS_ID  AND M.MASTER_INDEX = N.MASTER_INDEX 
                                                    AND M.PERSON_CODE = N.PERSON_CODE AND M.REG_CODE= N.REG_CODE 
                                                    AND M.REG_SOURCE = N.REG_SOURCE AND M.TYPE = 2 ;";
                                        num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@" drop table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2;";
                                        num = num + conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        // LOG($"查询成功，{num}行", $"{ITEM}", Indexs, "查询平台", "");

                                    }
                                    sql2 = $@" drop table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}; ";
                                    num = num + conn.Execute(sql2, commandTimeout: 60 * 60 * 5);

                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        configConnection.Execute(@$"update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] set COMPLETE_MARK = 23,END_TIME=getdate(),log='{sql2.Replace("'", "''")}' where  COMPLETE_MARK != 22 and id= " + Indexs);
                        HomeQueries home = new HomeQueries(_configConnectionString, _Connection156);
                        home.SendMail(@$"药品/疾病/材料平台提醒", @$"疾病拉取失败 {icd_or_diseaseCondition} 错误日志：{ex.ToString().Replace("'", "''")}", "唐仲阳");

                    }
                }
            }
        }
        public void Drugquery(long typefee, long type1_2, string drugs, string[] drugName, long Indexs, long ip, string zxr)
        {
            var where = "";
            long num = 0;
            long CompleteMar = 0;
            if (ip == 1)
            {
                where = @$"and ExecOpenLink in ('192.168.18.151', '192.168.18.152', '192.168.18.153') ";
            }
            else if (ip == 2)
            {
                where = @$"and ExecOpenLink  in ('192.168.18.154', '192.168.18.155', '192.168.18.156')";
            }
            else if (ip == 3)
            {
                where = @$"and ExecOpenLink  in ('192.168.18.157', '192.168.18.158')";
            }
            else if (ip == 4)
            {
                where = "and ExecOpenLink not in ('192.168.18.151', '192.168.18.152', '192.168.18.153','192.168.18.154', '192.168.18.155', '192.168.18.156','192.168.18.157', '192.168.18.158')";
            }
            DbConnection configConnection = new SqlConnection(_configConnectionString);

            List<SYS_Hospital> hos = configConnection.Query<SYS_Hospital>(@$"SELECT ExecOpenLink ,ExecDatabase FROM  [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] 
                WHERE ExecOpenLink <>'' AND ExecOpenLink IS NOT NULL AND ExecDatabase <>'' AND ExecDatabase IS NOT NULL {where}").ToList();

            服务器 fwq = new 服务器();
            var msConnectionString = "";
            var countsql = 0;
            var sql2 = "";
            var mzb = "";
            var zyb = "";
            if (typefee == 1) { mzb = "OUT_FEE"; zyb = "INPAT_FEE"; }
            if (typefee == 2) { mzb = "OUT_PRES"; zyb = "INPAT_ORDER"; }
            foreach (var item in hos)
            {
                //统计执行的多少家医院
                countsql++;
                var fwqsql = $"SELECT  [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{item.ExecOpenLink}'";
                fwq = configConnection.Query<服务器>(fwqsql).FirstOrDefault();
                msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", item.ExecOpenLink, item.ExecDatabase, fwq.数据库账号, fwq.数据库密码);

                using (DbConnection conn = new SqlConnection(msConnectionString))
                {
                    CompleteMar = Complete_MarkId(Indexs);
                    if (CompleteMar == 23)
                    {
                        throw new DomainException("查询失败！！");
                    }
                    if (CompleteMar == 31)
                    {
                        throw new DomainException("查询停止！！");
                    }
                    try
                    {
                        //判断状态 21在执行
                        if (CompleteMar == 21)
                        {
                            if (Countnum($@"SELECT count(*) FROM {item.ExecDatabase}.dbo.SYSOBJECTS WHERE NAME = 'DIC_FEE_SUMMARY'", conn) > 0)
                            {
                                if (Countnum($@"SELECT count(*) a FROM {item.ExecDatabase}.[dbo].[DIC_FEE_SUMMARY]  where  (I_TYPE_NAME like '%药%' or CATEGORY like '%药%') and {drugs} ", conn) > 0)
                                {
                                    //药品信息查询语句
                                    foreach (var drug in drugName)
                                    {
                                        sql2 = $@"insert into [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] (
                                             [HOS_ID] ,[ITEM_NAME] ,[MEDIC_NAME],[MEDIC_AREA],[INDEXS] )
							      select  cast(right('{item.ExecDatabase}',3)as int) hos_id,ITEM_NAME, 
                                   '{drug}'MEDIC_NAME,medic_area medic_area,{Indexs} INDEXS  from {item.ExecDatabase}.[dbo].[DIC_FEE_SUMMARY] 
                                   WHERE (I_TYPE_NAME like '%药%' or CATEGORY like '%药%') and [ITEM_NAME] like '%{drug}%' GROUP BY ITEM_NAME,MEDIC_AREA ";
                                        conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                    }
                                    if (Countnum($@"SELECT count(*) FROM [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] where hos_id=cast(right('{item.ExecDatabase}',3)as int) and indexs={Indexs}", configConnection) > 0)
                                    {
                                        var sql3 = $@"IF EXISTS(SELECT * FROM [{item.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'MEDIC_PERSON_INFORMATION_{Indexs}')
			                               drop  table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs};
                                    SELECT C.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,A.REG_CODE,A.REG_ID,'1' REG_SOURCE,
                                    	A.REG_TIME,NULL OUTHOS_TIME,B.ID AREA_ID,{Indexs} INDEXS,cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int ) HOS_ID,
                                    	C.BIRTHDAY,C.SEX,1 TYPE,A.DEPT_NAME into [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}
                                    FROM {item.ExecDatabase}.[dbo].OUT_REG_INFO A
                                    JOIN 
                                        (
                                           SELECT DISTINCT REG_CODE,D.ID FROM (select *from {item.ExecDatabase}.[dbo].{mzb} where CATEGORY like '%药%' or ITEM_TYPE like '%药%' ) E 
                                           join  [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] D ON {(typefee == 1 ? "E.ITEM_NAME" : "REPLACE(REPLACE(E.MEDIC_GENERAL_NAME,E.MEDIC_SPEC,''),' ','')")} = D.ITEM_NAME  AND ISNULL(E.MEDIC_AREA,'') = ISNULL(D.MEDIC_AREA,'') AND INDEXS={Indexs} AND HOS_ID = cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int )
                                           where CATEGORY like '%药%' or ITEM_TYPE like '%药%'
                                        )B 
                                    ON  A.REG_CODE = B.REG_CODE
                                    JOIN {item.ExecDatabase}.[dbo].PUB_PATIENT C ON A.PERSON_CODE = C.PERSON_CODE
                                    WHERE A.REG_CODE = B.REG_CODE AND A.PERSON_CODE = C.PERSON_CODE
                                        UNION ALL
                                    SELECT C.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,A.REG_CODE,A.REG_ID,'2' REG_SOURCE,
                                    	A.INHOS_TIME,A.OUTHOS_TIME,B.ID AREA_ID,{Indexs} INDEXS,cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int ) HOS_ID,
                                    	C.BIRTHDAY,C.SEX,1 TYPE,A.OUT_DEPT_NAME 
                                    FROM {item.ExecDatabase}.[dbo].INPAT_REG_INFO A 
                                    JOIN(
                                         SELECT DISTINCT REG_CODE,D.ID FROM (select *from {item.ExecDatabase}.[dbo].{zyb} where CATEGORY like '%药%' or ITEM_TYPE like '%药%' ) E 
                                         JOIN [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] D ON {(typefee == 1 ? "E.ITEM_NAME" : "REPLACE(REPLACE(E.ITEM_NAME,E.MEDIC_SPEC,''),' ','')")} = D.ITEM_NAME 
                                    	AND ISNULL(E.MEDIC_AREA,'') = ISNULL(D.MEDIC_AREA,'') AND INDEXS={Indexs} AND HOS_ID = cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int )
                                         where CATEGORY like '%药%' or ITEM_TYPE like '%药%'
                                        )B 
                                    ON  A.REG_CODE = B.REG_CODE
                                    JOIN {item.ExecDatabase}.[dbo].PUB_PATIENT C ON A.PERSON_CODE = C.PERSON_CODE 
                                    WHERE A.REG_CODE = B.REG_CODE AND A.PERSON_CODE = C.PERSON_CODE
                                       
                                      
                                     
                                    ";

                                        if (conn.Execute(sql3, commandTimeout: 60 * 60 * 5) > 0)
                                        {
                                            sql2 = $@"insert into [SV_QueryPlatform_].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}([HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],OUTHOS_TIME,AREA_ID,[INDEXS],[TYPE],[DEPT_NAME])
                                                  SELECT [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],OUTHOS_TIME, AREA_ID,[INDEXS],[TYPE],[DEPT_NAME]  From [{item.ExecOpenLink}].[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}";
                                            num = configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        }

                                    }
                                    if (type1_2 == 2)
                                    {
                                        sql2 = $@"IF EXISTS(SELECT * FROM [{item.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'MEDIC_PERSON_INFORMATION_{Indexs}_2')
			                                    drop  table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2;
                                                SELECT A.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,B.REG_CODE,B.REG_ID,1 REG_SOURCE,B.REG_TIME,NULL OUTHOS_TIME,A.BIRTHDAY,A.SEX,2 TYPE, {Indexs} Indexs , b.org_code hos_id,B.DEPT_NAME  into [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2
                                                FROM {item.ExecDatabase}.[DBO].PUB_PATIENT A, {item.ExecDatabase}.[DBO].OUT_REG_INFO B,
                                                (SELECT DISTINCT MASTER_INDEX FROM {item.ExecDatabase}.[DBO].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS= {Indexs} AND HOS_ID =  cast(right('{item.ExecDatabase}',3)as int)) C  
                                                WHERE A.PERSON_CODE=B.PERSON_CODE AND  A.MASTER_INDEX=C.MASTER_INDEX
                                                UNION ALL
                                                SELECT A.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,B.REG_CODE,B.REG_ID,2 REG_SOURCE,B.INHOS_TIME,B.OUTHOS_TIME, A.BIRTHDAY,A.SEX,2 TYPE,{Indexs} , b.org_code,B.OUT_DEPT_NAME
                                                FROM {item.ExecDatabase}.[DBO].PUB_PATIENT A, {item.ExecDatabase}.[DBO].INPAT_REG_INFO B,
                                                (SELECT DISTINCT MASTER_INDEX FROM {item.ExecDatabase}.[DBO].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS={Indexs} AND HOS_ID =   cast(right('{item.ExecDatabase}',3)as int)) C
                                                WHERE A.PERSON_CODE=B.PERSON_CODE AND A.MASTER_INDEX=C.MASTER_INDEX;";
                                        conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@"INSERT into [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}]([HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],AREA_ID,[INDEXS],[TYPE],[DEPT_NAME])
                                                     select [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],null,[INDEXS],[TYPE],[DEPT_NAME] From [{item.ExecOpenLink}].[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2";
                                        num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@"  DELETE FROM M  FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}] M  
                                                    INNER JOIN (SELECT * FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS = {Indexs} 
                                                    AND HOS_ID =cast(right('{item.ExecDatabase}',3)as int) AND TYPE = 1) N  
                                                    ON M.INDEXS = N.INDEXS  AND M.HOS_ID = N.HOS_ID  AND M.MASTER_INDEX = N.MASTER_INDEX 
                                                    AND M.PERSON_CODE = N.PERSON_CODE AND M.REG_CODE = N.REG_CODE 
                                                    AND M.REG_SOURCE = N.REG_SOURCE    AND M.TYPE = 2 ;";
                                        num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@" drop table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2;";
                                        num = num + conn.Execute(sql2, commandTimeout: 60 * 60 * 5);

                                    }
                                    sql2 = $@"
                                      IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}') AND type in (N'U'))
                                      drop table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}; 
                                     ";
                                    num = num + conn.Execute(sql2, commandTimeout: 60 * 60 * 5);

                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        configConnection.Execute($"update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] set COMPLETE_MARK = 23,END_TIME=getdate(),log='ex:{ex.ToString()}sql:{sql2.Replace("'", "''")}' where  COMPLETE_MARK != 22 and id= " + Indexs);
                        HomeQueries home = new HomeQueries(_configConnectionString, _Connection156);
                        home.SendMail(@$"药品/疾病/材料平台提醒", @$"药品拉取失败{string.Join(",", drugName)}  错误日志：{ex.ToString().Replace("'", "''")}", zxr);
                    }
                }
            }
        }

        public void 材料query(long typefee, long type1_2, string drugs, string[] drugName, long Indexs, long ip, string zxr)
        {
            var where = "";
            long num = 0;
            long CompleteMar = 0;
            if (ip == 1)
            {
                where = @$"and ExecOpenLink in ('192.168.18.151', '192.168.18.152', '192.168.18.153') ";
            }
            else if (ip == 2)
            {
                where = @$"and ExecOpenLink  in ('192.168.18.154', '192.168.18.155', '192.168.18.156')";
            }
            else if (ip == 3)
            {
                where = @$"and ExecOpenLink  in ('192.168.18.157', '192.168.18.158')";
            }
            else if (ip == 4)
            {
                where = "and ExecOpenLink not in ('192.168.18.151', '192.168.18.152', '192.168.18.153','192.168.18.154', '192.168.18.155', '192.168.18.156','192.168.18.157', '192.168.18.158')";
            }
            DbConnection configConnection = new SqlConnection(_configConnectionString);

            List<SYS_Hospital> hos = configConnection.Query<SYS_Hospital>(@$"SELECT ExecOpenLink ,ExecDatabase FROM  [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] 
                WHERE ExecOpenLink <>'' AND ExecOpenLink IS NOT NULL AND ExecDatabase <>'' AND ExecDatabase IS NOT NULL {where}").ToList();

            服务器 fwq = new 服务器();
            var msConnectionString = "";
            var countsql = 0;
            var sql2 = "";
            var mzb = "";
            var zyb = "";
            if (typefee == 1) { mzb = "OUT_FEE"; zyb = "INPAT_FEE"; }
            if (typefee == 2) { mzb = "OUT_PRES"; zyb = "INPAT_ORDER"; }
            foreach (var item in hos)
            {
                //统计执行的多少家医院
                countsql++;
                var fwqsql = $"SELECT  [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{item.ExecOpenLink}'";
                fwq = configConnection.Query<服务器>(fwqsql).FirstOrDefault();
                msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", item.ExecOpenLink, item.ExecDatabase, fwq.数据库账号, fwq.数据库密码);

                using (DbConnection conn = new SqlConnection(msConnectionString))
                {
                    CompleteMar = Complete_MarkId(Indexs);
                    if (CompleteMar == 23)
                    {
                        throw new DomainException("查询失败！！");
                    }
                    if (CompleteMar == 31)
                    {
                        throw new DomainException("查询停止！！");
                    }
                    try
                    {
                        //判断状态 21在执行
                        if (CompleteMar == 21)
                        {
                            if (Countnum($@"SELECT count(*) FROM {item.ExecDatabase}.dbo.SYSOBJECTS WHERE NAME = 'DIC_FEE_SUMMARY'", conn) > 0)
                            {
                                if (Countnum($@"SELECT count(*) a FROM {item.ExecDatabase}.[dbo].[DIC_FEE_SUMMARY]  where  {drugs} ", conn) > 0)
                                {
                                    //药品信息查询语句
                                    foreach (var drug in drugName)
                                    {
                                        sql2 = $@"insert into [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] (
                                             [HOS_ID] ,[ITEM_NAME] ,[MEDIC_NAME],[MEDIC_AREA],[INDEXS] )
							      select  cast(right('{item.ExecDatabase}',3)as int) hos_id,ITEM_NAME, 
                                   '{drug}'MEDIC_NAME,medic_area medic_area,{Indexs} INDEXS  from {item.ExecDatabase}.[dbo].[DIC_FEE_SUMMARY] 
                                   WHERE [ITEM_NAME] like '%{drug}%' GROUP BY ITEM_NAME,MEDIC_AREA ";
                                        conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                    }
                                    if (Countnum($@"SELECT count(*) FROM [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] where hos_id=cast(right('{item.ExecDatabase}',3)as int) and indexs={Indexs}", configConnection) > 0)
                                    {
                                        var sql3 = $@"IF EXISTS(SELECT * FROM [{item.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'MEDIC_PERSON_INFORMATION_{Indexs}')
			                               drop  table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs};
                                    SELECT C.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,A.REG_CODE,A.REG_ID,'1' REG_SOURCE,
                                    	A.REG_TIME,NULL OUTHOS_TIME,B.ID AREA_ID,{Indexs} INDEXS,cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int ) HOS_ID,
                                    	C.BIRTHDAY,C.SEX,1 TYPE,A.DEPT_NAME into [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}
                                    FROM {item.ExecDatabase}.[dbo].OUT_REG_INFO A
                                    JOIN 
                                        (
                                           SELECT DISTINCT REG_CODE,D.ID FROM (select *from {item.ExecDatabase}.[dbo].{mzb}  ) E 
                                           join  [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] D ON {(typefee == 1 ? "E.ITEM_NAME" : "REPLACE(REPLACE(E.MEDIC_GENERAL_NAME,E.MEDIC_SPEC,''),' ','')")} = D.ITEM_NAME  AND ISNULL(E.MEDIC_AREA,'') = ISNULL(D.MEDIC_AREA,'') AND INDEXS={Indexs} AND HOS_ID = cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int ) 
                                        )B 
                                    ON  A.REG_CODE = B.REG_CODE
                                    JOIN {item.ExecDatabase}.[dbo].PUB_PATIENT C ON A.PERSON_CODE = C.PERSON_CODE
                                    WHERE A.REG_CODE = B.REG_CODE AND A.PERSON_CODE = C.PERSON_CODE
                                        UNION ALL
                                    SELECT C.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,A.REG_CODE,A.REG_ID,'2' REG_SOURCE,
                                    	A.INHOS_TIME,A.OUTHOS_TIME,B.ID AREA_ID,{Indexs} INDEXS,cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int ) HOS_ID,
                                    	C.BIRTHDAY,C.SEX,1 TYPE,A.OUT_DEPT_NAME 
                                    FROM {item.ExecDatabase}.[dbo].INPAT_REG_INFO A 
                                    JOIN(
                                         SELECT DISTINCT REG_CODE,D.ID FROM (select *from {item.ExecDatabase}.[dbo].{zyb}  ) E 
                                         JOIN [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_AREA_{Indexs}] D ON {(typefee == 1 ? "E.ITEM_NAME" : "REPLACE(REPLACE(E.ITEM_NAME,E.MEDIC_SPEC,''),' ','')")} = D.ITEM_NAME 
                                    	AND ISNULL(E.MEDIC_AREA,'') = ISNULL(D.MEDIC_AREA,'') AND INDEXS={Indexs} AND HOS_ID = cast( RIGHT ( '{item.ExecDatabase}', 3 ) AS int ) 
                                        )B 
                                    ON  A.REG_CODE = B.REG_CODE
                                    JOIN {item.ExecDatabase}.[dbo].PUB_PATIENT C ON A.PERSON_CODE = C.PERSON_CODE 
                                    WHERE A.REG_CODE = B.REG_CODE AND A.PERSON_CODE = C.PERSON_CODE
                                       
                                      
                                     
                                    ";

                                        if (conn.Execute(sql3, commandTimeout: 60 * 60 * 5) > 0)
                                        {
                                            sql2 = $@"insert into [SV_QueryPlatform_].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}([HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],OUTHOS_TIME,AREA_ID,[INDEXS],[TYPE],[DEPT_NAME])
                                                  SELECT [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],OUTHOS_TIME, AREA_ID,[INDEXS],[TYPE],[DEPT_NAME]  From [{item.ExecOpenLink}].[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}";
                                            num = configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        }

                                    }
                                    if (type1_2 == 2)
                                    {
                                        sql2 = $@"IF EXISTS(SELECT * FROM [{item.ExecDatabase}].dbo.SYSOBJECTS WHERE NAME = 'MEDIC_PERSON_INFORMATION_{Indexs}_2')
			                                    drop  table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2;
                                                SELECT A.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,B.REG_CODE,B.REG_ID,1 REG_SOURCE,B.REG_TIME,NULL OUTHOS_TIME,A.BIRTHDAY,A.SEX,2 TYPE, {Indexs} Indexs , b.org_code hos_id,B.DEPT_NAME  into [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2
                                                FROM {item.ExecDatabase}.[DBO].PUB_PATIENT A, {item.ExecDatabase}.[DBO].OUT_REG_INFO B,
                                                (SELECT DISTINCT MASTER_INDEX FROM {item.ExecDatabase}.[DBO].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS= {Indexs} AND HOS_ID =  cast(right('{item.ExecDatabase}',3)as int)) C  
                                                WHERE A.PERSON_CODE=B.PERSON_CODE AND  A.MASTER_INDEX=C.MASTER_INDEX
                                                UNION ALL
                                                SELECT A.MASTER_INDEX,A.PERSON_CODE,A.PERSON_ID,B.REG_CODE,B.REG_ID,2 REG_SOURCE,B.INHOS_TIME,B.OUTHOS_TIME, A.BIRTHDAY,A.SEX,2 TYPE,{Indexs} , b.org_code,B.OUT_DEPT_NAME
                                                FROM {item.ExecDatabase}.[DBO].PUB_PATIENT A, {item.ExecDatabase}.[DBO].INPAT_REG_INFO B,
                                                (SELECT DISTINCT MASTER_INDEX FROM {item.ExecDatabase}.[DBO].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS={Indexs} AND HOS_ID =   cast(right('{item.ExecDatabase}',3)as int)) C
                                                WHERE A.PERSON_CODE=B.PERSON_CODE AND A.MASTER_INDEX=C.MASTER_INDEX;";
                                        conn.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@"INSERT into [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}]([HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],AREA_ID,[INDEXS],[TYPE],[DEPT_NAME])
                                                     select [HOS_ID],[MASTER_INDEX],[BIRTHDAY],[SEX],[PERSON_CODE],[PERSON_ID],[REG_CODE],[REG_ID],[REG_SOURCE],[REG_TIME],null,[INDEXS],[TYPE],[DEPT_NAME] From [{item.ExecOpenLink}].[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2";
                                        num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@"  DELETE FROM M  FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}] M  
                                                    INNER JOIN (SELECT * FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{Indexs}] WHERE INDEXS = {Indexs} 
                                                    AND HOS_ID =cast(right('{item.ExecDatabase}',3)as int) AND TYPE = 1) N  
                                                    ON M.INDEXS = N.INDEXS  AND M.HOS_ID = N.HOS_ID  AND M.MASTER_INDEX = N.MASTER_INDEX 
                                                    AND M.PERSON_CODE = N.PERSON_CODE AND M.REG_CODE = N.REG_CODE 
                                                    AND M.REG_SOURCE = N.REG_SOURCE    AND M.TYPE = 2 ;";
                                        num = num + configConnection.Execute(sql2, commandTimeout: 60 * 60 * 5);
                                        sql2 = $@" drop table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}_2;";
                                        num = num + conn.Execute(sql2, commandTimeout: 60 * 60 * 5);

                                    }
                                    sql2 = $@"
                                      IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}') AND type in (N'U'))
                                      drop table [{item.ExecDatabase}].[dbo].MEDIC_PERSON_INFORMATION_{Indexs}; 
                                     ";
                                    num = num + conn.Execute(sql2, commandTimeout: 60 * 60 * 5);

                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        configConnection.Execute($"update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] set COMPLETE_MARK = 23,END_TIME=getdate(),log='ex:{ex.ToString()}sql:{sql2.Replace("'", "''")}' where  COMPLETE_MARK != 22 and id= " + Indexs);
                        HomeQueries home = new HomeQueries(_configConnectionString, _Connection156);
                        home.SendMail(@$"药品/疾病/材料平台提醒", @$"药品拉取失败{string.Join(",", drugName)}  错误日志：{ex.ToString().Replace("'", "''")}", zxr);
                    }
                }
            }
        }
        public long ItemQuery()
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = $@"SELECT  * FROM [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where COMPLETE_MARK<>22 and COMPLETE_MARK<>31 ";
            long count = connection.Query(sql).Count();
            return count;
        } 
        public void 化验拉取(long indexs, long type, string item_name, long ip, int id, int ids)
        {
            DbConnection configConnection = new SqlConnection(_configConnectionString.Replace("SV_QueryPlatform", "SV_QueryPlatform_"));
            var sql = "";
            var where = "";
            if (ip < 9)
            {
                where = @$"and ExecOpenLink ='192.168.18.15{ip}'";
            }
            else if (ip == 9)
            {
                where = "and ExecOpenLink not in ('192.168.18.151', '192.168.18.152', '192.168.18.153','192.168.18.154', '192.168.18.155', '192.168.18.156','192.168.18.157', '192.168.18.158')";
            }
            List<SYS_Hospital> hos = configConnection.Query<SYS_Hospital>(@$"
                    SELECT ExecOpenLink, ExecDatabase
                    	FROM [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] a
                    	JOIN (SELECT DISTINCT HOS_ID FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{ids}] where indexs={indexs})b ON a.id=b.HOS_ID
                    WHERE ExecOpenLink<>'' AND ExecOpenLink IS NOT NULL AND ExecDatabase<>'' AND ExecDatabase IS NOT NULL {where}", commandTimeout: 1000000).ToList();
            foreach (var item in hos)
            {
                //统计执行的多少家医院 
                var fwqsql = $"SELECT  [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{item.ExecOpenLink}'";
                服务器 fwq = configConnection.Query<服务器>(fwqsql).FirstOrDefault();
                var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", item.ExecOpenLink, item.ExecDatabase, fwq.数据库账号, fwq.数据库密码);

                using (DbConnection conn = new SqlConnection(msConnectionString))
                {
                    long CompleteMar = ASSAY_Complete_MarkId(id);
                    if (CompleteMar != 21)
                    {
                        throw new DomainException("查询失败！！");
                    }
                    else
                    {
                        if (type == 1)
                        {
                            sql = @$"
              SELECT a.[MASTER_INDEX], [REPORT_CODE], b.[REG_ID], b.[REG_CODE], [EMP_CODE], [EMP_NAME], [REPORT_TIME], [SPECIMEN_TYPE], [ASSAY_ITEM_CODE], 
           [ASSAY_ITEM_NAME], [ITEM_ENAME], [UNIT], [RESULTS], [REFRANGE], [RESULTSTATUS], a.[REG_SOURCE], [ORG_CODE], [UPLOAD_TIME] into [{item.ExecDatabase}].dbo.ASSAY_REPORT_{indexs}_{id}
	        FROM (select *from msdb.[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}] where HOS_ID=cast(right('{item.ExecDatabase}',3)as int) )a
	        JOIN (SELECT * FROM [{item.ExecDatabase}].[dbo].[ASSAY_REPORT] where {(item_name == "" ? "1=1" : item_name)}  )  b 
	        ON a.REG_CODE=b.REG_CODE AND a.REG_SOURCE=b.REG_SOURCE AND b.ORG_CODE=a.HOS_ID";
                            conn.Execute(sql, commandTimeout: 1000000);
                            sql = @$" insert into[192.168.18.181].[SV_QueryPlatform_].dbo.ASSAY_REPORT_{indexs}_{id}
           ([MASTER_INDEX], [REPORT_CODE], [REG_ID], [REG_CODE], [EMP_CODE], [EMP_NAME], [REPORT_TIME], [SPECIMEN_TYPE], [ASSAY_ITEM_CODE], 
           [ASSAY_ITEM_NAME], [ITEM_ENAME], [UNIT], [RESULTS], [REFRANGE], [RESULTSTATUS], [REG_SOURCE], [ORG_CODE], [UPLOAD_TIME])
           select [MASTER_INDEX], [REPORT_CODE], [REG_ID], [REG_CODE], [EMP_CODE], [EMP_NAME], [REPORT_TIME], [SPECIMEN_TYPE], [ASSAY_ITEM_CODE], 
           [ASSAY_ITEM_NAME], [ITEM_ENAME], [UNIT], [RESULTS], [REFRANGE], [RESULTSTATUS], [REG_SOURCE], [ORG_CODE], [UPLOAD_TIME] 
           From [{item.ExecDatabase}].dbo.ASSAY_REPORT_{indexs}_{id}
            where RESULTS LIKE '%项目%' OR RESULTS LIKE '%结果%' OR RESULTS LIKE '%单位%' OR RESULTS LIKE '%范围%'";
                            conn.Execute(sql, commandTimeout: 1000000);
                            sql = @$"
           insert into [192.168.18.181].[SV_QueryPlatform_].dbo.ASSAY_REPORT_FORMAT_{indexs}_{id}
           ([MASTER_INDEX], [REPORT_CODE], [REG_ID], [REG_CODE], [EMP_CODE], [EMP_NAME], [REPORT_TIME], [SPECIMEN_TYPE], [ASSAY_ITEM_CODE], 
           [ASSAY_ITEM_NAME], [ITEM_ENAME], [UNIT], [RESULTS], [REFRANGE], [RESULTSTATUS], [REG_SOURCE], [ORG_CODE], [UPLOAD_TIME])
            select [MASTER_INDEX], [REPORT_CODE], [REG_ID], [REG_CODE], [EMP_CODE], [EMP_NAME], [REPORT_TIME], [SPECIMEN_TYPE], [ASSAY_ITEM_CODE], 
           [ASSAY_ITEM_NAME], [ITEM_ENAME], [UNIT], [RESULTS], [REFRANGE], [RESULTSTATUS], [REG_SOURCE], [ORG_CODE], [UPLOAD_TIME] 
           From [{item.ExecDatabase}].dbo.ASSAY_REPORT_{indexs}_{id}
           where RESULTS not LIKE '%项目%' and RESULTS not LIKE '%结果%' and RESULTS not LIKE '%单位%' and RESULTS not LIKE '%范围%' ;";
                            conn.Execute(sql, commandTimeout: 60 * 60 * 5);
                            sql = @$" drop table [{item.ExecDatabase}].dbo.ASSAY_REPORT_{indexs}_{id}  ;";
                            conn.Execute(sql, commandTimeout: 1000000);
                        }
                        if (type == 2)
                        {
                            sql = @$"
            insert into [192.168.18.181].[SV_QueryPlatform_].dbo.EXEC_REPORT_{indexs}_{id}
           ([MASTER_INDEX], [REPORT_CODE], [REG_ID], [REG_CODE], [ORDER_ID], [ORDER_CODE], [PATIENT_MEDICALREC], [EXAMINE_NAME], [EXAMINE_SHOW],[EXAMINE_RESULT], [EMP_CODE], [EMP_NAME], [REPORT_TIME],[REG_SOURCE], [ORG_CODE], [UPLOAD_TIME])
           SELECT a.[MASTER_INDEX], [REPORT_CODE], b.[REG_ID], b.[REG_CODE], [ORDER_ID], [ORDER_CODE], [PATIENT_MEDICALREC], [EXAMINE_NAME], [EXAMINE_SHOW], [EXAMINE_RESULT], [EMP_CODE], [EMP_NAME], [REPORT_TIME], a.[REG_SOURCE], [ORG_CODE], [UPLOAD_TIME] 
	       FROM (select *from msdb.[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}] where HOS_ID=cast(right('{item.ExecDatabase}',3)as int) ) a
	       JOIN(SELECT * FROM [{item.ExecDatabase}].[dbo].[EXEC_REPORT] where {(item_name == "" ? "1=1" : item_name)} ) b ON a.REG_CODE=b.REG_CODE AND a.REG_SOURCE=b.REG_SOURCE AND b.ORG_CODE=a.HOS_ID;
                           ";
                            conn.Execute(sql, commandTimeout: 1000000);
                        }
                    }
                }
            }
        }
        public int indexsId(int indexs)
        {
            DbConnection connection = new SqlConnection(_configConnectionString.Replace("SV_QueryPlatform", "SV_QueryPlatform_"));
            var sql = $@"select id,end_time From [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where id ={indexs}";
            MEDIC_SEARCH_RECORD msr = connection.Query<MEDIC_SEARCH_RECORD>(sql, commandTimeout: 60 * 60 * 5).First();//拼接

            int ids = msr.id;

            if (msr.end_time.Year != DateTime.Now.Year || msr.end_time.Month != DateTime.Now.Month)
            {
                ids = int.Parse(msr.end_time.Year.ToString() + msr.end_time.Month.ToString());
            }
            return ids;
        }
        public void 化验query(long type, long indexs, int id, long bz, string zxr, int ids = 0, string item_name = "")
        {
            DbConnection configConnection = new SqlConnection(_configConnectionString);
            List<string> hos = configConnection.Query<string>(@$"
                    SELECT distinct ExecOpenLink
                    	FROM [192.168.18.156].[DB_SV_Data_Config].[dbo].[SYS_Hospital] a
                    WHERE ExecOpenLink<>'' AND ExecOpenLink IS NOT NULL AND ExecDatabase<>'' AND ExecDatabase IS NOT NULL").ToList();
            try
            {
                if (bz == 1)
                {
                    var sql = $@"SELECT distinct REG_CODE,REG_SOURCE,HOS_ID,MASTER_INDEX into [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}] 
                                    FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{ids}] 
                                    WHERE INDEXS={indexs}";
                    configConnection.Execute(sql, commandTimeout: 1000000);
                }
                if (bz == 2)
                {
                    var sql = "";
                    var msConnectionString = "";
                    DbConnection conn = null;
                    foreach (var item in hos)
                    {
                        var fwqsql = $"SELECT  [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{item}'";
                        服务器 fwq = configConnection.Query<服务器>(fwqsql).FirstOrDefault();
                        msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", item, "msdb", fwq.数据库账号, fwq.数据库密码);
                        conn = new SqlConnection(msConnectionString);
                        if (type == 1)
                        {
                            sql = @$" 
                      select * into msdb.[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}] 
                             from [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}]";
                        }
                        if (type == 2)
                        {
                            sql = @$"
                     select * into msdb.[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}] 
                             from [192.168.18.181].[SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}]";
                        }
                        conn.Execute(sql, commandTimeout: 1000000);
                    }
                    msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", "192.168.18.181", "SV_QueryPlatform_", "sa", "Suvalue2016");
                    conn = new SqlConnection(msConnectionString);
                    sql = @$"drop table  [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}]";
                    conn.Execute(sql, commandTimeout: 1000000);
                }
                if (bz == 3)
                {
                    var tasks = new List<Task>();
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 1, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 2, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 3, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 4, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 5, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 6, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 7, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 8, id, ids)));
                    tasks.Add(Task.Factory.StartNew(() => 化验拉取(indexs, type, item_name, 9, id, ids)));
                    Task.WaitAll(tasks.ToArray());
                }
                if (bz == 4)
                {
                    foreach (var item in hos)
                    {
                        var fwqsql = $"SELECT  [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{item}'";
                        服务器 fwq = configConnection.Query<服务器>(fwqsql).FirstOrDefault();
                        var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", item, "msdb", fwq.数据库账号, fwq.数据库密码);
                        var sql = "";
                        using (DbConnection conn = new SqlConnection(msConnectionString))
                        {
                            if (type == 1)
                            {
                                sql = @$"  
                     drop table [dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}]";

                            }
                            if (type == 2)
                            {
                                sql = @$" 
                     drop table[dbo].[MEDIC_PERSON_INFORMATION_化验检查_{indexs}_{id}]";
                            }
                            conn.Execute(sql, commandTimeout: 100000);
                        }

                    }
                }
                if (bz == 5)
                {
                    ASSAYREPORT(indexs, id, item_name);
                }
                if (bz == 6)
                {
                    configConnection.Execute(@$"update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD_ASSAY] 
                                        set COMPLETE_MARK = 22,END_TIME=getdate() where  COMPLETE_MARK not in (23, 22) and id= " + id);
                }
            }
            catch (Exception ex)
            {
                var sql = $"update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD_ASSAY] set COMPLETE_MARK = 23,END_TIME=getdate(),log='步骤{bz} 错误：{ex.ToString().Replace("'", "''").Distinct()}' where id={id}";
                configConnection.Execute(sql);
                HomeQueries home = new HomeQueries(_configConnectionString, _Connection156);
                home.SendMail(@$"化验拉取提醒", @$"{(type == 1 ? "化验" : "检查")} 拉取失败！ indexs:{indexs} id:{id} 报错步骤：{bz} 错误日志：{ex.ToString().Replace("'", "''")}", zxr);
                throw;
            }
        }
        public int SqlAssayAdd(int indexs, string project_name, string[] commodity_name, int type)
        {
            DbConnection connection = new SqlConnection(_configConnectionString.Replace("SV_QueryPlatform", "SV_QueryPlatform_"));
            var sql = @$"
         INSERT into [dbo].[MEDIC_SEARCH_RECORD_ASSAY]([Indexs],[PROJECT_NAME],[COMMODITY_NAME],[COMPLETE_MARK],[search_time],[TYPE],[END_TIME],[log])
         VALUES({indexs},'{project_name}','{string.Join(",", commodity_name)}',21,getdate(),{type},null,null)";
            connection.Execute(sql, commandTimeout: 60 * 60 * 5);

            sql = @$"SELECT  max(id) id FROM[SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD_ASSAY] where Indexs={indexs} and project_name='{project_name}' 
                      and COMMODITY_NAME='{string.Join(",", commodity_name)}' and COMPLETE_MARK=21 and TYPE={type} and END_TIME is null and log is null ";

            int id = connection.Query<int>(sql).FirstOrDefault();
            if (type == 1)
            {
                sql = @$" 
                     CREATE TABLE[dbo].[ASSAY_REPORT_FORMAT_{indexs}_{id}] (
                         [REPORT_ID][BIGint] IDENTITY(1, 1) NOT NULL,
                         [MASTER_INDEX] [int] NULL,
                         [REPORT_CODE][NVARCHAR] (MAX)NULL,
                         [REG_ID][BIGint] NULL,
                         [REG_CODE][NVARCHAR] (100) NULL,
                         [EMP_CODE][NVARCHAR] (MAX)NULL,
                         [EMP_NAME][VARBINARY] (MAX)NULL,
                         [REPORT_TIME][DATETIME] NULL,
                         [SPECIMEN_TYPE][NVARCHAR] (MAX)NULL,
                         [ASSAY_ITEM_CODE][NVARCHAR] (MAX)NULL,
                         [ASSAY_ITEM_NAME][NVARCHAR] (MAX)NULL,
                         [ITEM_ENAME][NVARCHAR] (MAX)NULL,
                         [UNIT][NVARCHAR] (MAX)NULL,
                         [RESULTS][NVARCHAR] (MAX)NULL,
                         [REFRANGE][NVARCHAR] (MAX)NULL,
                         [RESULTSTATUS][NVARCHAR] (MAX)NULL,
                         [REG_SOURCE][int] NULL,
                         [ORG_CODE][int] NOT NULL,
                         [UPLOAD_TIME] [DATETIME] NULL
                        ) ON[PRIMARY] TEXTIMAGE_ON[PRIMARY]
                    CREATE NONCLUSTERED INDEX ASSAY_REPORT_FORMAT_h_m_{indexs}_{id} ON[SV_QueryPlatform_].[dbo].[ASSAY_REPORT_FORMAT_{indexs}_{id}]([MASTER_INDEX],[ORG_CODE])
                    CREATE TABLE[dbo].[ASSAY_REPORT_{indexs}_{id}] (
                         [REPORT_ID][BIGint] IDENTITY(1, 1) NOT NULL,
                         [MASTER_INDEX] [int] NULL,
                         [REPORT_CODE][NVARCHAR] (MAX)NULL,
                         [REG_ID][BIGint] NULL,
                         [REG_CODE][NVARCHAR] (100) NULL,
                         [EMP_CODE][NVARCHAR] (MAX)NULL,
                         [EMP_NAME][VARBINARY] (MAX)NULL,
                         [REPORT_TIME][DATETIME] NULL,
                         [SPECIMEN_TYPE][NVARCHAR] (MAX)NULL,
                         [ASSAY_ITEM_CODE][NVARCHAR] (MAX)NULL,
                         [ASSAY_ITEM_NAME][NVARCHAR] (MAX)NULL,
                         [ITEM_ENAME][NVARCHAR] (MAX)NULL,
                         [UNIT][NVARCHAR] (MAX)NULL,
                         [RESULTS][NVARCHAR] (MAX)NULL,
                         [REFRANGE][NVARCHAR] (MAX)NULL,
                         [RESULTSTATUS][NVARCHAR] (MAX)NULL,
                         [REG_SOURCE][int] NULL,
                         [ORG_CODE][int] NOT NULL,
                         [UPLOAD_TIME] [DATETIME] NULL
                        ) ON[PRIMARY] TEXTIMAGE_ON[PRIMARY]";
            }
            if (type == 2)
            {
                sql = @$"
                    CREATE TABLE [dbo].[EXEC_REPORT_{indexs}_{id}](
                    	[REPORT_ID] [int] IDENTITY(1,1) NOT NULL,
                    	[MASTER_INDEX] [int] NULL,
                    	[REPORT_CODE] [NVarchar](50) NULL,
                    	[REG_ID] [Bigint] NULL,
                    	[REG_CODE] [NVarchar](50) NULL,
                    	[ORDER_ID] [Bigint] NULL,
                    	[ORDER_CODE] [NVarchar](50) NULL,
                    	[PATIENT_MEDICALREC] [NVarchar](MAX) NULL,
                    	[EXAMINE_NAME] [NVarchar](max) NULL,
                    	[EXAMINE_SHOW] [NVarchar](max) NULL,
                    	[EXAMINE_RESULT] [NVarchar](max) NULL,
                    	[EMP_CODE] [NVarchar](20) NULL,
                    	[EMP_NAME] [Varbinary](MAX) NULL,
                    	[REPORT_TIME] [DateTime] NULL,
                    	[REG_SOURCE] [int] NULL,
                    	[ORG_CODE] [int] NOT NULL,
                    	[UPLOAD_TIME] [DateTime] NULL,
                     CONSTRAint [PK_EXEC_REPORT_{indexs}_{id}] PRIMARY KEY CLUSTERED 
                    (
                    	[REPORT_ID] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                    ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]";
            }
            connection.Execute(sql);
            return id;
        }
        /// <summary>
        /// 化验切割
        /// </summary>
        /// <param name="index"></param>
        /// <param name="id"></param>
        /// <param name="item_name"></param>
        public void ASSAYREPORT(long index, int id, string item_name = "")
        {
            DbConnection connection = new SqlConnection(_configConnectionString.Replace("SV_QueryPlatform", "SV_QueryPlatform_"));


            //创建切割数据表
            var sql = @$"SELECT * into dbo.ASSAY_REPORT_TEMP_{index}_{id}  FROM [dbo].ASSAY_REPORT_{index}_{id}";

            //第一层切割
            var sql2 = $@"UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'
','&') prlong('将回车替换&') UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'[','')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,']','')PRlong('将]替换 ')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,' ','`') prlong('将空格替换`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`L','') prlong('将 `L 去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`H','') prlong('将 `H 去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`*','') prlong('将 `* 去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`↑','')prlong('将 `↑去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`高','')prlong('将 `高 去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`↓','')prlong('将 `↓去除') 
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'`低','')prlong('将 `低 去除') 
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'>','')  prlong('将 > 去除') 
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'<','')  prlong('将 < 去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=RIGHT(RESULTS,LEN(RESULTS)-1) WHERE LEFT(RESULTS,1)='`' prlong('将第一个字符为 ` 的去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&0','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&1','&') WHERE RESULTS NOT LIKE '&1`'
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&1`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&2`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&3`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&4`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&5`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&6`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&7`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&8`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&9`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&10`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&11`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&12`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&13`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&14`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&15`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&16`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&17`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&18`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&19`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&20`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&21`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&22`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&23`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&24`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&25`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&26`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&27`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&28`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&29`','&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&30`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&31`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&32`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&33`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&34`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&35`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&36`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&37`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&38`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&39`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&40`','&') 
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&41`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&42`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&43`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&44`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&45`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&46`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&47`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&48`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&49`','&')  
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&50`','&') prlong('将 &1`/2`/3`/4`/5`..... 改为&')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'【互】','')  prlong('将 【互】去除')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`') ---20次
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'``','`')prlong('将 多个连续``` 改为 `')
                        UPDATE dbo.ASSAY_REPORT_TEMP_{index}_{id} SET RESULTS=REPLACE(RESULTS,'&`','&')";

            //函数分列，换行
            var sql3 = $@"SELECT  ORG_CODE,REPORT_ID,a.REG_CODE,
  [dbo].[fGetStrBySplit](RESULTS,0,'`')ITEM_ENAME , 
  [dbo].[fGetStrBySplit](RESULTS,1,'`') RESULTS,
  [dbo].[fGetStrBySplit](RESULTS,2,'`') UNIT,
  [dbo].[fGetStrBySplit](RESULTS,3,'`') REFRANGE  into [dbo].[ASSAY1_{index}_{id}]  FROM (
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,1,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,2,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,3,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,4,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,5,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,6,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,7,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,8,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,9,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,10,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   )a    WHERE  [dbo].[fGetStrBySplit](RESULTS,1,'`') NOT LIKE '%名称%'
   AND  [dbo].[fGetStrBySplit](RESULTS,1,'`')  <>'' AND  [dbo].[fGetStrBySplit](RESULTS,1,'`') IS NOT NULL 
    
	SELECT ORG_CODE,REPORT_ID,a.REG_CODE,
  [dbo].[fGetStrBySplit](RESULTS,0,'`')ITEM_ENAME , 
  [dbo].[fGetStrBySplit](RESULTS,1,'`') RESULTS,
  [dbo].[fGetStrBySplit](RESULTS,2,'`') UNIT,
  [dbo].[fGetStrBySplit](RESULTS,3,'`') REFRANGE into [dbo].[ASSAY2_{index}_{id}]   FROM (
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,11,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,12,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,13,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,14,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,15,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,16,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,17,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,18,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,19,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,20,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   )a    WHERE   [dbo].[fGetStrBySplit](RESULTS,1,'`') NOT LIKE '%名称%'
   AND  [dbo].[fGetStrBySplit](RESULTS,1,'`')  <>'' AND  [dbo].[fGetStrBySplit](RESULTS,1,'`') IS NOT NULL 
    
	  
  SELECT  ORG_CODE,REPORT_ID,a.REG_CODE,
  [dbo].[fGetStrBySplit](RESULTS,0,'`')ITEM_ENAME , 
  [dbo].[fGetStrBySplit](RESULTS,1,'`') RESULTS,
  [dbo].[fGetStrBySplit](RESULTS,2,'`') UNIT,
  [dbo].[fGetStrBySplit](RESULTS,3,'`') REFRANGE  into [dbo].[ASSAY3_{index}_{id}]    FROM (
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,21,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,22,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,23,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,24,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,25,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,26,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,27,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,28,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,29,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,30,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   )a    WHERE   [dbo].[fGetStrBySplit](RESULTS,1,'`') NOT LIKE '%名称%'
   AND  [dbo].[fGetStrBySplit](RESULTS,1,'`')  <>'' AND  [dbo].[fGetStrBySplit](RESULTS,1,'`') IS NOT NULL 


   	  
  SELECT ORG_CODE,REPORT_ID,a.REG_CODE,
  [dbo].[fGetStrBySplit](RESULTS,0,'`')ITEM_ENAME , 
  [dbo].[fGetStrBySplit](RESULTS,1,'`') RESULTS,
  [dbo].[fGetStrBySplit](RESULTS,2,'`') UNIT,
  [dbo].[fGetStrBySplit](RESULTS,3,'`') REFRANGE  into [dbo].[ASSAY4_{index}_{id}]   FROM (
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,31,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,32,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,33,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,34,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,35,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,36,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,37,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,38,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,39,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,40,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   )a    WHERE   [dbo].[fGetStrBySplit](RESULTS,1,'`') NOT LIKE '%名称%'
   AND  [dbo].[fGetStrBySplit](RESULTS,1,'`')  <>'' AND  [dbo].[fGetStrBySplit](RESULTS,1,'`') IS NOT NULL 

   SELECT  ORG_CODE,REPORT_ID,a.REG_CODE,
  [dbo].[fGetStrBySplit](RESULTS,0,'`')ITEM_ENAME , 
  [dbo].[fGetStrBySplit](RESULTS,1,'`') RESULTS,
  [dbo].[fGetStrBySplit](RESULTS,2,'`') UNIT,
  [dbo].[fGetStrBySplit](RESULTS,3,'`') REFRANGE  into [dbo].[ASSAY5_{index}_{id}]   FROM (
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,41,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,42,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,43,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,44,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,45,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,46,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,47,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,48,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,49,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
      UNION
   SELECT ORG_CODE,REPORT_ID,REG_CODE,  [dbo].[fGetStrBySplit](RESULTS,50,'&')RESULTS     FROM dbo.ASSAY_REPORT_TEMP_{index}_{id}  
   )a    WHERE   [dbo].[fGetStrBySplit](RESULTS,1,'`') NOT LIKE '%名称%'
   AND  [dbo].[fGetStrBySplit](RESULTS,1,'`')  <>'' AND  [dbo].[fGetStrBySplit](RESULTS,1,'`') IS NOT NULL 
    prlong('临时数据生成中')

   SELECT * into [dbo].[ASSAY_{index}_{id}] FROM (
   SELECT*FROM [dbo].[ASSAY1_{index}_{id}]
   UNION ALL
   SELECT*FROM [dbo].[ASSAY2_{index}_{id}]
   UNION ALL
   SELECT*FROM [dbo].[ASSAY3_{index}_{id}]
   UNION ALL
   SELECT*FROM [dbo].[ASSAY4_{index}_{id}]
   UNION ALL
   SELECT*FROM [dbo].[ASSAY5_{index}_{id}])a 
   WHERE UNIT not LIKE '单位' 
   AND a.UNIT NOT LIKE '%审核%' 
   AND ITEM_ENAME NOT LIKE '%备注%'
   AND a.ITEM_ENAME NOT LIKE '%标本%'
   AND ITEM_ENAME not LIKE '单位' 
   AND a.ITEM_ENAME NOT LIKE '%审核%' 
   AND UNIT NOT LIKE '%备注%'
   AND a.UNIT NOT LIKE '%标本%';
    prlong('临时数据生成完成');";
            connection.Execute(sql, commandTimeout: 60 * 60 * 5);
            connection.Execute(sql2, commandTimeout: 60 * 60 * 5);
            connection.Execute(sql3, commandTimeout: 60 * 60 * 5);
            var sql4 = @$"SELECT DISTINCT
  STUFF((SELECT ',' + 'b.' + name FROM SysColumns Where id = Object_Id('dbo.ASSAY_REPORT_TEMP_{index}_{id}')  FOR XML PATH('')), 1, 1, '') as tablename
FROM SysColumns a Where id = Object_Id('dbo.ASSAY_REPORT_TEMP_{index}_{id}'); ";
            string zd = connection.Query<string>(sql4).ToList().FirstOrDefault();


            zd = zd.Replace("b.ITEM_ENAME", "a.ITEM_ENAME").Replace("b.RESULTS", "a.RESULTS").Replace("b.UNIT", "a.UNIT").Replace("b.REFRANGE", "a.REFRANGE").Replace("a.RESULTSTATUS", "b.RESULTSTATUS");


            var sql5 = @$" insert into [dbo].[ASSAY_REPORT_FORMAT_{index}_{id}] 
                                     ({zd.Replace("a.", "").Replace("b.", "").Replace("REPORT_ID,", "")} )
                              select {zd.Replace("b.REPORT_ID,", "")}  from  [dbo].[ASSAY_{index}_{id}] A 
                            join dbo.ASSAY_REPORT_TEMP_{index}_{id} B on A.REPORT_ID=B.REPORT_ID";

            connection.Execute(sql5, commandTimeout: 60 * 60 * 5);

            connection.Execute(@$" drop table ASSAY_REPORT_TEMP_{index}_{id}  
                                   drop table ASSAY1_{index}_{id}
                                   drop table ASSAY2_{index}_{id}
                                   drop table ASSAY3_{index}_{id}
                                   drop table ASSAY4_{index}_{id}
                                   drop table ASSAY5_{index}_{id}
                                   drop table ASSAY_{index}_{id}
                                   drop table [dbo].[ASSAY_REPORT_{index}_{id}]
            ", commandTimeout: 60 * 60 * 5);
        }
        public IEnumerable<dynamic> MEDIC_SEARCH_RECORD_ASSAY(int id)
        {
            DbConnection connection = new SqlConnection(_configConnectionString.Replace("SV_QueryPlatform", "SV_QueryPlatform_"));
            var sql = $@"SELECT [ID] 
      ,[PROJECT_NAME]项目名称
      ,[COMMODITY_NAME]查询条件
      ,case  [COMPLETE_MARK] when 21 then '执行中'  when 22 then '执行结束' when 23 then '执行失败' end 状态 
      ,[search_time]开始时间
      ,case [TYPE] when 1 then '化验' when 2 then'检查' end [检查/化验]
      ,[END_TIME] 结束时间
      FROM   [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD_ASSAY] where [Indexs]={id}";

            return connection.Query(sql, commandTimeout: 60 * 60 * 5).ToList(); ;
        }
        public void 定时执行()
        {
            DbConnection configConnection = new SqlConnection(_configConnectionString.Replace("SV_QueryPlatform", "SV_QueryPlatform_"));
            configConnection.Execute($"EXEC [SV_QueryPlatform_].[dbo].[MonthBeginningStatementConsolidation]", commandTimeout: 60 * 60 * 5);
        }


        public async void ATC(string atccode = "", string url = "https://atcddd.fhi.no/atc_ddd_index/")
        {
            var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", "192.168.18.181", "SV_QueryPlatform_Demand", "sa", "Suvalue2016");

            using (DbConnection conn = new SqlConnection(msConnectionString))
            {

                using (var httpClient = new HttpClient())
                {

                    // 发起 HTTP 请求获取页面内容

                    HttpResponseMessage response = httpClient.GetAsync(url).Result;

                    // 确认请求成功
                    if (response.IsSuccessStatusCode)
                    {
                        // 从响应中读取 HTML 内容
                        string htmlContent = response.Content.ReadAsStringAsync().Result;

                        // 使用 HtmlAgilityPack 解析 HTML
                        HtmlDocument htmlDoc = new HtmlDocument();
                        htmlDoc.LoadHtml(htmlContent);

                        var pTags = htmlDoc.DocumentNode.SelectNodes("//div[@id='content']//h3[contains(text(),'ATC code')]/following-sibling::div/p");
                        if (pTags == null)
                        {
                            pTags = htmlDoc.DocumentNode.SelectNodes("//p");
                        }

                        if (pTags != null)
                        {
                            foreach (var pTag in pTags.Where(s => s.SelectNodes("b/a") != null))
                            {
                                // 获取 b 标签内的文本内容和 href 属性
                                if (pTag != null)
                                {
                                    var bTags = pTag.SelectNodes("b/a");
                                    if (bTags != null)
                                    {
                                        foreach (var bTag in bTags)
                                        {
                                            string labelText = bTag.ParentNode.PreviousSibling.InnerText.Trim();

                                            string href = bTag.GetAttributeValue("href", "");
                                            string name = bTag.InnerText.Trim();

                                            Console.WriteLine($"Label Text: {labelText}");
                                            Console.WriteLine($"Href: {href}");
                                            Console.WriteLine($"Name: {name}");
                                            Console.WriteLine();
                                            conn.Execute($"insert into [dbo].[ATC](code,name)select '{labelText}','{name.Replace("'", "''")}' ", commandTimeout: 60 * 60 * 5);
                                            ATC(atccode + "," + labelText, href.Replace("./", "https://atcddd.fhi.no/atc_ddd_index/"));
                                        }
                                    }
                                }
                            }
                        }
                        string[] parts = atccode.Split(',');
                        var tableRows = htmlDoc.DocumentNode.SelectNodes("//div[@id='content']//table//tr[position()>1]");
                        if (tableRows != null)
                        {
                            List<List<string>> tableData = new List<List<string>>();

                            foreach (var row in tableRows)
                            {
                                var rowData = row.Elements("td").Select(td => td.InnerText.Trim().Replace("&nbsp", "").Replace(";", "")).ToList();
                                tableData.Add(rowData);
                            }

                            foreach (var rowData in tableData.Distinct())
                            {
                                conn.Execute(@$"insert into [dbo].[ATCLIST]([ATCCode], [Name], [DDD], [U], [Adm.R], [Note], [ATC1], [ATC2], [ATC3], [ATC4]) select '{rowData[0]}','{rowData[1]}','{rowData[2]}','{rowData[3]}','{rowData[4]}','{rowData[5]}','{parts[1]}','{parts[2]}','{parts[3]}','{parts[4]}'; ", commandTimeout: 60 * 60 * 5);
                                //   Console.WriteLine($"atccode: {atccode}");
                                // Console.WriteLine(string.Join(", ", rowData));
                            }
                             
                        }
                        else
                        {
                            Console.WriteLine("未找到");

                        }

                    }
                }
            }
        }

        public string GetPreviousText(HtmlNode node)
        {
            var prev = node.PreviousSibling;
            while (prev != null && prev.NodeType != HtmlNodeType.Text)
            {
                prev = prev.PreviousSibling;
            }
            return prev?.InnerText ?? "";
        }






        //谷歌翻译
        public static string GetGetRequest(string urlP, string encode)
        {
            if (null == urlP) return null;
            string StrRetP = null;
            Stream dataStream = null;
            try
            {
                HttpWebRequest myHttpWebRequest = (HttpWebRequest)WebRequest.Create(urlP);
                myHttpWebRequest.Timeout = 10000; // 10 secs
                HttpWebResponse Objresponse = (HttpWebResponse)myHttpWebRequest.GetResponse();
                //Encoding enc = Encoding.GetEncoding(1252); // Windows default Code Page
                if (Objresponse.StatusDescription == "OK")
                {//HttpStatusCode.OK
                    dataStream = Objresponse.GetResponseStream();
                    Encoding objE = String.IsNullOrEmpty(encode) ? Encoding.GetEncoding(0) : Encoding.GetEncoding(encode);
                    StreamReader r = new StreamReader(dataStream, objE);
                    StrRetP = r.ReadToEnd();
                }
            }
            catch (Exception e)
            {
                StrRetP = e.Message;
            }
            finally
            {
                if (null != dataStream) dataStream.Close();
            }
            return StrRetP;
        }
        public static string GetMatchString(string text, string pattern, int point)
        {
            if (String.IsNullOrEmpty(text) || String.IsNullOrEmpty(pattern)) return String.Empty;
            Regex rx = new Regex(pattern, RegexOptions.Compiled | RegexOptions.IgnoreCase | RegexOptions.Multiline);
            Match match = rx.Match(text);
            string word = "";
            if (match.Success) word = match.Groups[point].Value;
            return word.Trim();
        }












         
    }
}

