﻿using Dapper;
using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;
using Microsoft.Data.SqlClient;
using PuppeteerSharp;
using QueryPlatform.Api.Infrastructure.Modules;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using System.Threading;
using System.Threading.Tasks;
using static QueryPlatform.Api.Infrastructure.Queries.ResourceQueries;
using Document = DocumentFormat.OpenXml.Wordprocessing.Document;
using Vb = Microsoft.VisualBasic;
namespace QueryPlatform.Api.Infrastructure.Queries
{
    public class ResourceQueries
    {
        private readonly string _Connection156;
        private readonly string _configConnectionString;
        public ResourceQueries(string Connection156, string configConnectionString)
        {
            _Connection156 = Connection156;
            _configConnectionString = configConnectionString;
        }
        /// <summary>
        /// 查询所有项目
        /// </summary>
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) ItemQuery(string name, long paseIndex)
        {
            paseIndex = paseIndex == 0 ? 1 : paseIndex;
            DbConnection connection = new SqlConnection(_configConnectionString);
            var where = "";
            var sql = "";
            if (!string.IsNullOrEmpty(name))
            {
                where = @$" and PROJECT_NAME like '%{name}%'";
            }
            sql = $@"SELECT ID,[PROJECT_NAME],concat(case when [END_TIME]is null then '(已耗时:'else'(耗时:' end, concat(case when [END_TIME]is null then datediff(second,[search_time],getdate())
	  else datediff(second,[search_time],[END_TIME] )end / 3600, '时' , case when [END_TIME]is null then datediff(second,[search_time],getdate())
	  else datediff(second,[search_time],[END_TIME] )end % 3600 / 60, '分' , case when [END_TIME]is null then datediff(second,[search_time],getdate())
	  else datediff(second,[search_time],[END_TIME] )end % 3600 % 60, '秒'),')')[time],	  case when type='疾病' and ICD !='' and DISEASE_NAME !='' then concat('icd：',ICD,'
疾病：',DISEASE_NAME)
 when type='疾病' and ICD !='' and DISEASE_NAME ='' then concat('icd：',ICD)
 when type='疾病' and ICD ='' and DISEASE_NAME !='' then concat('疾病：',DISEASE_NAME)
 when GENERIC_NAME!=''then concat(type,'：',GENERIC_NAME)
end querycriteria, type,GENERIC_NAME, DISEASE_NAME, ICD,  COMPLETE_MARK, search_time 
				 FROM [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where 1=1 {where}  
				 order by search_time desc offset ({paseIndex} - 1)*(10) rows fetch next 10 rows only";
            IEnumerable<dynamic> sj = connection.Query(sql).ToList();
            sql = $@" SELECT  CAST(COUNT(*)AS MONEY)totalCount ,{paseIndex} paseIndex FROM [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where 1=1 {where}";
            IEnumerable<dynamic> zon = connection.Query(sql).ToList();
            return (sj, zon);
        }
        /// <summary>
        /// 停止正在查询项目
        /// </summary>
        public bool CancelProject(int id)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            //确定该项目在执行中
            IEnumerable<dynamic> COMPLETE_MARK = connection.Query("select COMPLETE_MARK FROM [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where COMPLETE_MARK =22 and id=" + id);
            if (COMPLETE_MARK.Count() > 0)
                throw new DomainException("该项目已经执行完毕,不能取消！！！");
            else
                LOG("停止中", "", id, "查询平台", "");
            return connection.Execute(@$"drop table [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{id}]   ;
                                         drop table [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{id}]   ;
                                   update [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] set COMPLETE_MARK = 31 where   COMPLETE_MARK != 22 and id= " + id) > 0 ? true : false;

        }
        public IEnumerable<dynamic> ShowMEDIC_AREA(int id)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = $@"select case when concat(year(end_time),'_',month(end_time))!=concat(year(getdate()),'_',month(getdate())) 
                        then concat(year(end_time),'',month(end_time))  else id end ID From [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where id ={id}";

            int ids = connection.Query<int>(sql, commandTimeout: 60 * 60 * 5).FirstOrDefault();
            IEnumerable<dynamic> sj = connection.Query($@"
                 SELECT DISTINCT REPLACE([MEDIC_AREA],' ','')[MEDIC_AREA] FROM [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{ids}] WHERE INDEXS={id} AND ITEM_NAME IS NOT NULL AND ITEM_NAME<>''").ToList();

            return (sj);
        }
        public IEnumerable<dynamic> ShowITEM_NAME(int id)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = $@"select case when concat(year(end_time),'_',month(end_time))!=concat(year(getdate()),'_',month(getdate())) 
                        then concat(year(end_time),'',month(end_time))  else id end ID From [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where id ={id}";

            int ids = connection.Query<int>(sql, commandTimeout: 60 * 60 * 5).FirstOrDefault();

            IEnumerable<dynamic> sj = connection.Query($@"
                 SELECT DISTINCT  REPLACE([ITEM_NAME],' ','')[ITEM_NAME] FROM [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{ids}] WHERE INDEXS={id} AND ITEM_NAME IS NOT  NULL AND ITEM_NAME<>''  ").ToList();
            return sj;
        }

        public class nffb
        {
            public string n { get; set; }
            public string RS { get; set; }
        }
        public class sexfb
        {
            public string sex { get; set; }
            public string rs { get; set; }
        }
        public class nldfb
        {
            public string 年龄段 { get; set; }
            public string rs { get; set; }
        }
        public class qyfb
        {
            public string classification { get; set; }
            public string hospital { get; set; }
            public string hospitalsSUM { get; set; }
            public string patientSUM { get; set; }
        }
        public class ksrc
        {
            public string dept_name { get; set; }
            public string rc { get; set; }
        }
        public class MEDIC_PERSON_INFORMATION
        {
            public string HOS_ID { get; set; }        // 医院 ID
            public string MASTER_INDEX { get; set; }  // 主索引
            public DateTime BIRTHDAY { get; set; }    // 出生日期
            public string SEX { get; set; }           // 性别
            public string PERSON_CODE { get; set; }   // 个人编号
            public string PERSON_ID { get; set; }     // 个人 ID
            public string REG_CODE { get; set; }      // 登记编码
            public string REG_ID { get; set; }        // 登记 ID
            public string REG_SOURCE { get; set; }    // 登记来源
            public DateTime REG_TIME { get; set; }    // 登记时间
            public string AREA_ID { get; set; }       // 区域 ID
            public string INDEXS { get; set; }        // 索引
            public string TYPE { get; set; }          // 类型
            public string DEPT_NAME { get; set; }     // 科室名称
            public string MEDIC_AREA { get; set; }    // 医疗区域
        }

        string fwq = $@"E:/wwww/testdatasearch/api/wwwroot/export/人群分布报告/";

        string bd = $@"E:\代码\queryPlatform2.0\api\queryPlaform.Api\wwwroot\export\人群分布报告/";
        public async Task<(IEnumerable<dynamic>, IEnumerable<dynamic>, string, string, IEnumerable<dynamic>, IEnumerable<dynamic>, string, IEnumerable<dynamic>)> ProjectReport1
            (int id, string MEDIC_AREA, string ITEM_NAME, string GENERIC_NAME, string PROJECT_NAME, string icd, string DISEASE_NAME, string diz, int xz)
        {
            var where = "";
            if (!string.IsNullOrEmpty(MEDIC_AREA) && !string.IsNullOrEmpty(ITEM_NAME))
            {

                MEDIC_AREA = MEDIC_AREA.Replace("，", ",");
                where = "b.MEDIC_AREA LIKE '%" + MEDIC_AREA.Replace(",", "%' or b.MEDIC_AREA like '%") + "%'";
                ITEM_NAME = ITEM_NAME.Replace("，", ",");
                where += "or b.ITEM_NAME LIKE '%" + ITEM_NAME.Replace(",", "%' or b.ITEM_NAME like '%") + "%'";
            }
            else
            {
                if (!string.IsNullOrEmpty(MEDIC_AREA))
                {
                    MEDIC_AREA = MEDIC_AREA.Replace("，", ",");
                    where = "b.MEDIC_AREA LIKE '%" + MEDIC_AREA.Replace(",", "%' or b.MEDIC_AREA like '%") + "%'";
                }
                else if (!string.IsNullOrEmpty(ITEM_NAME))
                {
                    ITEM_NAME = ITEM_NAME.Replace("，", ",");
                    where = " b.ITEM_NAME LIKE '%" + ITEM_NAME.Replace(",", "%' or b.ITEM_NAME like '%") + "%'";
                }
                else
                {
                    where = " 1=1 ";
                }
            }
            long unixTimeSeconds = DateTimeOffset.UtcNow.ToUnixTimeSeconds();
            DbConnection connection = new SqlConnection(_configConnectionString);
            var sql = $@"select case when concat(year(end_time),'_',month(end_time))!=concat(year(getdate()),'_',month(getdate())) 
                        then concat(year(end_time),'',month(end_time))  else id end ID From [SV_QueryPlatform_].[dbo].[MEDIC_SEARCH_RECORD] where id ={id}";
            int ids = connection.Query<int>(sql, commandTimeout: 60 * 60 * 5).FirstOrDefault();
            var AddQuery = $@" 
                        
                         SELECT a.HOS_ID,MASTER_INDEX,BIRTHDAY,SEX,PERSON_CODE,PERSON_ID,REG_CODE,REG_ID,REG_SOURCE,REG_TIME,AREA_ID,a.INDEXS,a.TYPE,DEPT_NAME,a.MEDIC_AREA into dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds}
                         FROM (select *from [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{ids}] where TYPE = 1 AND INDEXS IN({id})) a
                         left join [SV_QueryPlatform_].[dbo].[MEDIC_AREA_{ids}] b on a.AREA_ID = b.ID AND a.INDEXS=b.INDEXS 
                         where({where}) 
                         ";
            connection.Execute(AddQuery, commandTimeout: 60 * 60 * 5);
            var ShowQuery1 = $@" select *From (  
						 SELECT cast(N as nvarchar(10))+'年'n,isnull(COUNT(*),0)RS FROM (
                         SELECT  DISTINCT  YEAR([REG_TIME])N, HOS_ID,MASTER_INDEX 
                         FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} WHERE TYPE=1   AND INDEXS IN ({id})  AND YEAR(REG_TIME)>=2014 and YEAR(REG_TIME)<=year(getdate())
                         ) S GROUP BY N 
                         UNION ALL 
                         SELECT '2013年之前'N,COUNT(*)RS FROM (
                         SELECT  DISTINCT   HOS_ID,MASTER_INDEX 
                         FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} WHERE TYPE=1 AND INDEXS IN ({id})
                         AND YEAR(REG_TIME)<=2013 ) S )a order by left(n,4)";
            var ShowQuery2 = $@"SELECT '医院区域'classification, PROVINCE hospital,COUNT(DISTINCT case when CODE is not null then code else HOS_ID end)hospitalsSUM,COUNT(*)patientSUM FROM (
						 SELECT DISTINCT HOS_ID,MASTER_INDEX,replace([Province],' ','')PROVINCE,CODE
						 FROM (SELECT  DISTINCT   HOS_ID,MASTER_INDEX
                         FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} WHERE TYPE=1 AND INDEXS IN ({id})) A
						 JOIN [192.168.18.156].[DB_SV_DATA_CONFIG].[DBO].[SYS_HOSPITAL] B ON A.HOS_ID=B.ID    
						 ) N  GROUP BY PROVINCE
						 UNION ALL 
						 SELECT '医院级别'JB,HOSLEVEL,COUNT(DISTINCT case when CODE is not null then code else HOS_ID end ),cast(COUNT(*) AS int)RS FROM (
						 SELECT DISTINCT HOS_ID,MASTER_INDEX,PROVINCE,CODE,
						 CASE WHEN HOSLEVEL LIKE '%三%' THEN '三级' WHEN HOSLEVEL  LIKE '%二%' THEN '二级'
						 ELSE '一级' END HOSLEVEL, 
						 HOSTYPE FROM (SELECT  DISTINCT   HOS_ID,MASTER_INDEX
                         FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} WHERE TYPE=1 AND INDEXS IN ({id})) A
						 JOIN [192.168.18.156].[DB_SV_DATA_CONFIG].[DBO].[SYS_HOSPITAL] B ON A.HOS_ID=B.ID    
						 ) N  GROUP BY HOSLEVEL
						 UNION ALL 
						 SELECT '医院类别'LB,HOSTYPE,COUNT(DISTINCT case when CODE is not null then code else HOS_ID end),cast(COUNT(*) AS int) FROM (
						 SELECT DISTINCT HOS_ID,MASTER_INDEX,CODE,
						 HOSTYPE FROM (SELECT  DISTINCT   HOS_ID,MASTER_INDEX
                         FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} WHERE TYPE=1 AND INDEXS IN({id}) ) A
						 JOIN [192.168.18.156].[DB_SV_DATA_CONFIG].[DBO].[SYS_HOSPITAL] B ON A.HOS_ID=B.ID    
						 ) N  GROUP BY HOSTYPE
						 UNION ALL
						 SELECT '总览'ZL,'医院数',COUNT(DISTINCT case when CODE is not null then code else HOS_ID end),cast(COUNT(*) AS int) FROM (
						 SELECT DISTINCT HOS_ID,MASTER_INDEX,CODE,
						 HOSTYPE FROM (SELECT  DISTINCT   HOS_ID,MASTER_INDEX
                         FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} WHERE TYPE=1 AND INDEXS IN({id}) ) A
						 JOIN [192.168.18.156].[DB_SV_DATA_CONFIG].[DBO].[SYS_HOSPITAL] B ON A.HOS_ID=B.ID ) N ";
            var ShowQuery3 = $@"  select sex , count(concat(hos_id,'_',MASTER_INDEX)) rs from(
    SELECT hos_id,MASTER_INDEX ,MAX(SEX)sex FROM (
    SELECT hos_id,MASTER_INDEX,case when SEX like '%男%' then '男' when SEX like '%女%' then '女' else '未知' end 'SEX'
    FROM dbo.[MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds}] where type=1 and INDEXS in({id})
    )A group by hos_id,MASTER_INDEX
    )a group by sex order by sex";
            var ShowQuery4 = $@"     select 年龄段,count(concat(hos_id,'_',MASTER_INDEX)) rs from(
     select
     case when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=10 then '10岁以内'
          WHEN DATEDIFF(day,BIRTHDAY,REG_TIME)/365 IS NULL THEN '未知'
          when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=11and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=20 then '11-20'
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=21and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=30 then '21-30'
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=31and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=40 then '31-40'
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=41and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=50 then '41-50'
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=51and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=60 then '51-60'
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=61and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=70 then '61-70'
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=71 then '71岁以上' end '年龄段',
 case when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=10 then 1
          WHEN DATEDIFF(day,BIRTHDAY,REG_TIME)/365 IS NULL THEN 9
          when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=11and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=20 then 2
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=21and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=30 then 3
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=31and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=40 then 4
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=41and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=50 then 5
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=51and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=60 then 6
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=61and DATEDIFF(day,BIRTHDAY,REG_TIME)/365 <=70 then 7
    	  when DATEDIFF(day,BIRTHDAY,REG_TIME)/365 >=71 then 8 end 'px',
    	 hos_id, MASTER_INDEX 
      from (
    SELECT hos_id,MASTER_INDEX,min(REG_TIME)REG_TIME,min(BIRTHDAY)BIRTHDAY
    FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} where type=1 and INDEXS in({id})
    group by hos_id,MASTER_INDEX
     ) a  
     )a group by 年龄段,px order by px";
            var ShowQuery5 = $@"    SELECT isnull(DEPT_NAME,'未知')DEPT_NAME ,count(distinct CONCAT(hos_id,'_',MASTER_INDEX,'_',REG_SOURCE,'_',REG_CODE))rc
    FROM dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds} where type=1 and INDEXS in({id})
	group by isnull(DEPT_NAME,'未知')
	order by count(distinct CONCAT(hos_id,'_',MASTER_INDEX,'_',REG_SOURCE,'_',REG_CODE))desc";
            List<nffb> yearfb = connection.Query<nffb>(ShowQuery1, commandTimeout: 60 * 60 * 5).ToList();
            List<qyfb> dqfb = connection.Query<qyfb>(ShowQuery2, commandTimeout: 60 * 60 * 5).ToList();
            List<sexfb> ShowQuery3s = connection.Query<sexfb>(ShowQuery3, commandTimeout: 60 * 60 * 5).ToList();
            List<nldfb> ShowQuery4s = connection.Query<nldfb>(ShowQuery4, commandTimeout: 60 * 60 * 5).ToList();
            List<ksrc> ShowQuery5s = connection.Query<ksrc>(ShowQuery5, commandTimeout: 60 * 60 * 5).ToList();
            connection.Execute($"drop table dbo.MEDIC_PERSON_INFORMATION_存储过程表{unixTimeSeconds}", commandTimeout: 60 * 60 * 5);
            var condition = "";
            if (!string.IsNullOrEmpty(icd)) condition = condition + @"
ICD：[" + icd + ']';
            if (!string.IsNullOrEmpty(DISEASE_NAME)) condition = condition + @" 
疾病名称：[" + DISEASE_NAME + ']';
            if (!string.IsNullOrEmpty(ITEM_NAME))
            {
                condition = condition + @"
药品名称：[" + ITEM_NAME + ']';
            }
            else if (!string.IsNullOrEmpty(GENERIC_NAME))
            {
                condition = condition + @"
药品名称：[" + GENERIC_NAME + ']';
            }
            if (!string.IsNullOrEmpty(MEDIC_AREA)) condition = condition + @"
产地：[" + MEDIC_AREA + ']';











            string filePath = $"{diz}/export/模板.html"; //$"E:/C盘文件/桌面/非小细胞癌药品分布.html"; //$"{diz}/export/模板.html"// 指定文件路径
            var htmlContent = "";
            string mb = @"<tr>
                    <td   width='65%' bgcolor='#ffffff' style='background: #ffffff'>
                 		<p style='text-align: center; font-weight: bold;'><font color='#000000'><font face='宋体'><font size='2' style='font-size: 12pt'><span lang='zh-CN'>{nf}</span></font></font></font></p>
                        </td>
                 	<td width='35%' bgcolor='#ffffff' style='background: #ffffff'>
                 		<p style='text-align: center; '><font face='宋体'><font size='2' style='font-size: 12pt'><span lang='zh-CN'><font face='宋体'>{rs}</font></span></font></font></p>
                 	</td>
 
                          </tr> ";
            string yearfbhtmlfh = "";
            string sexfbhtmlfh = "";
            string nldfbhtmlfh = "";
            string flhtmlfh = "";
            string kshtmlfh = "";
            string yys = dqfb.Where(w => w.classification == "总览").FirstOrDefault().hospitalsSUM;
            string zrs = double.Parse(dqfb.Where(w => w.classification == "总览").FirstOrDefault().patientSUM).ToString("N0");



            foreach (var item in yearfb)
            {
                yearfbhtmlfh = yearfbhtmlfh + mb.Replace("{nf}", item.n).Replace("{rs}", double.Parse(item.RS).ToString("N0"));
            }
            foreach (var item in ShowQuery3s)
            {
                sexfbhtmlfh = sexfbhtmlfh + mb.Replace("{nf}", item.sex).Replace("{rs}", double.Parse(item.rs).ToString("N0"));
            }
            foreach (var item in ShowQuery4s)
            {
                nldfbhtmlfh = nldfbhtmlfh + mb.Replace("{nf}", item.年龄段).Replace("{rs}", double.Parse(item.rs).ToString("N0"));
            }
            // 读取文件内容
            using (StreamReader reader = new StreamReader(filePath))
            {
                htmlContent = reader.ReadToEnd();
            }

            mb = @"
                 <tr>
                 	<td rowspan='{hbdyg}' width='28%' bgcolor='#ffffff' style='background: #ffffff'>
                 	<p align='right' ><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{fl}</font></span></font></font></p> 
                    </td>
                 	<td width='17%' bgcolor='#ffffff' style='background: #ffffff'>
                 		<p align='right' ><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{hos}</font></span></font></font></p>
                 	</td>
                 	<td width='17%' bgcolor='#ffffff' style='background: #ffffff'>
                 		<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{hoss}</font></span></font></font></p>
                 	</td>
                 	<td width='37%' bgcolor='#ffffff' style='background: #ffffff'>
                 		<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{hzs}</font></span></font></font></p>
                 	</td>
                 </tr>";
            var mb2 = @"
                    <tr>
                    	<td width='17%' bgcolor='#ffffff' style='background: #ffffff'>
                    		<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{hos}</font></span></font></font></p>
                    	</td>
                    	<td width='17%' bgcolor='#ffffff' style='background: #ffffff'>
                    		<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{hoss}</font></span></font></font></p>
                    	</td>
                    	<td>
                    		<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{hzs}</font></span></font></font></p>
                    	</td>
                    </tr>";
            var ksmb = @" 
             <tr>
				<td width='63%' bgcolor='#ffffff' style='background: #ffffff'>
					<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{dept_name}</font></span></font></font></p>
				</td>
                <td width='36%' bgcolor='#ffffff' style='background: #ffffff'>
					<p align='right'><font face='宋体'><font size='2' style='font-size: 13pt'><span lang='zh-CN'><font face='宋体'>{rc}</font></span></font></font></p>
				</td> 
			</tr>";
            // 现在你可以使用htmlContent变量中的HTML代码
            foreach (var item in dqfb.Select(s => s.classification).Distinct())
            {
                long num = 0;
                var sl = dqfb.Where(w => w.classification == item).ToList();
                foreach (var item1 in sl)
                {
                    num = num + 1;
                    if (num == 1)
                    {
                        flhtmlfh = flhtmlfh + mb.Replace("{hbdyg}", sl.Count().ToString()).Replace("{fl}", item1.classification).Replace("{hos}", item1.hospital).Replace("{hoss}", item1.hospitalsSUM).Replace("{hzs}", double.Parse(item1.patientSUM).ToString("N0"));
                    }
                    else
                    {
                        flhtmlfh = flhtmlfh + mb2.Replace("{hbdyg}", sl.Count().ToString()).Replace("{fl}", item1.classification).Replace("{hos}", item1.hospital).Replace("{hoss}", item1.hospitalsSUM).Replace("{hzs}", double.Parse(item1.patientSUM).ToString("N0"));
                    }
                }
            }
            foreach (var item in ShowQuery5s)
            {
                kshtmlfh = kshtmlfh + ksmb.Replace("{dept_name}", item.dept_name).Replace("{rc}", double.Parse(item.rc).ToString("N0"));
            }
            htmlContent = htmlContent.Replace("{tablesj}", flhtmlfh).Replace("{xmname}", PROJECT_NAME).Replace("{cxgjz}", condition).Replace("{nffb}", yearfbhtmlfh).Replace("{nldfb}", nldfbhtmlfh).Replace("{sexfb}", sexfbhtmlfh).Replace("{zhzs}", zrs).Replace("{zyys}", yys).Replace("{kstable}", kshtmlfh);

            if (xz == 1)
            {
                string aa = await ConvertToPdf(htmlContent, PROJECT_NAME);
                return (yearfb, dqfb, condition, PROJECT_NAME, ShowQuery3s, ShowQuery4s, aa, ShowQuery5s);
            }
            return (yearfb, dqfb, condition, PROJECT_NAME, ShowQuery3s, ShowQuery4s, null, ShowQuery5s);

        }



        /// <summary>
        /// /
        /// </summary>
        /// <returns></returns>
        /// 
        public string HtmlToWord(string html, string xmname)
        {
            // 创建一个 Word 文档
            string filePath = $@"{fwq}{xmname}人群分布{DateTime.Now.ToString("yyyyMMddHHmmss") + new Random().Next(1000, 9999).ToString()}.";

            using (WordprocessingDocument doc = WordprocessingDocument.Create(filePath + "docx", WordprocessingDocumentType.Document))
            {
                // 添加一个空的 MainDocumentPart
                MainDocumentPart mainPart = doc.AddMainDocumentPart();

                // 创建一个新的文档
                mainPart.Document = new Document();
                Body body = mainPart.Document.AppendChild(new Body());

                // 读取 HTML 文件内容
                // string html = File.ReadAllText(htmlFilePath);

                // 处理 CSS 样式
                Regex regex = new Regex("<style[^>]*>(.*?)</style>", RegexOptions.Singleline);
                Match match = regex.Match(html);
                if (match.Success)
                {
                    string css = match.Groups[1].Value;
                    StyleDefinitionsPart stylePart = mainPart.AddNewPart<StyleDefinitionsPart>();
                    using (StreamWriter writer = new StreamWriter(stylePart.GetStream()))
                    {
                        writer.Write(css);
                    }
                }

                // 将 HTML 转换为 OpenXml 内容
                AlternativeFormatImportPart altPart = mainPart.AddAlternativeFormatImportPart(AlternativeFormatImportPartType.Xhtml);
                using (Stream stream = altPart.GetStream())
                using (StreamWriter writer = new StreamWriter(stream))
                {
                    writer.Write(html);
                }

                // 插入转换后的内容到 Word 文档中
                AltChunk altChunk = new AltChunk();
                altChunk.Id = mainPart.GetIdOfPart(altPart);
                body.AppendChild(altChunk);

                // 保存 Word 文档
                mainPart.Document.Save();

                string outfilepath = @$"https://lsk.suvalue.com/api/export/export/人群分布报告/{filePath.Replace($@"{fwq}", "")}";
                return outfilepath + "pdf";
            }
        }

        [Obsolete]
        public string ConvertHtmlToPdf(string html, string xmname)
        {
            string filePath = $@"{fwq}{xmname}人群分布{DateTime.Now.ToString("yyyyMMddHHmmss") + new Random().Next(1000, 9999).ToString()}.";
            // 创建一个 PDF 对象
            var pdf = new IronPdf.HtmlToPdf();

            // 加载 HTML 文件
            //var html = File.ReadAllText(htmlFilePath);

            // 设置渲染选项
            pdf.PrintOptions.CssMediaType = IronPdf.PdfPrintOptions.PdfCssMediaType.Print;
            pdf.PrintOptions.PaperSize = IronPdf.PdfPrintOptions.PdfPaperSize.A4;
            pdf.PrintOptions.MarginTop = 10;
            pdf.PrintOptions.MarginBottom = 10;
            pdf.PrintOptions.MarginLeft = 10;
            pdf.PrintOptions.MarginRight = 10;

            // 将 HTML 渲染为 PDF
            var pdfDoc = pdf.RenderHtmlAsPdf(html);

            // 保存 PDF 文件
            pdfDoc.SaveAs(filePath + "pdf");
            string outfilepath = @$"https://lsk.suvalue.com/api/export/export/人群分布报告/{filePath.Replace($@"{fwq}", "")}";
            return outfilepath + "pdf";
        }

        public async System.Threading.Tasks.Task<string> ConvertToPdf(string html, string xmname)
        {

            string filePath = $@"{fwq}{xmname}人群分布{DateTime.Now.ToString("yyyyMMddHHmmss") + new Random().Next(1000, 9999).ToString()}.";
            File.WriteAllText(filePath + "html", html);
            await new BrowserFetcher().DownloadAsync(BrowserFetcher.DefaultChromiumRevision);
            var launchOptions = new LaunchOptions { Headless = true };
            using (var browser = await Puppeteer.LaunchAsync(launchOptions))
            using (var page = await browser.NewPageAsync())
            {
                try
                {

                    Console.WriteLine("aaa PDF");
                    await page.GoToAsync(filePath + "html");
                    Console.WriteLine("Before saving PDF");
                    await page.PdfAsync(filePath + "pdf");
                    Console.WriteLine("After saving PDF");
                }
                catch (Exception e)
                {

                    throw;
                }

            }
            string outfilepath = @$"https://lsk.suvalue.com/api/export/export/人群分布报告/{filePath.Replace($@"{fwq}", "")}";
            return outfilepath + "pdf";

        }

        /// <summary>
        /// 创建流水表
        /// </summary>
        public bool EstablishFlowDatabaseTable(string PROJECT_NAME, string sql, int id, string remarks)
        {
            long id2 = long.Parse($"{id.ToString()}{DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2)}{DateTime.Now.Month}{DateTime.Now.Day}{DateTime.Now.Hour}{DateTime.Now.Minute}{DateTime.Now.Second}");
            DbConnection connection = new SqlConnection(_configConnectionString);
            long isfilter = 1;
            if (connection.Query($@"select * from [SV_QueryPlatform].[dbo].[FlowReservoirStatus] where tableName = '{PROJECT_NAME}' and indexs={id}").Count() > 0)
            {
                throw new DomainException(PROJECT_NAME + "流水库表已存在！");
            }
            else
            {
                if (string.IsNullOrEmpty(sql))
                {
                    isfilter = 0;
                    DrugqueryQueries _drugqueryQueries = new DrugqueryQueries(_Connection156, _configConnectionString);
                    int ids = _drugqueryQueries.indexsId(id);
                    sql = $"SELECT distinct MASTER_INDEX,hos_id  FROM [SV_QueryPlatform_].[dbo].[MEDIC_PERSON_INFORMATION_{ids}] WHERE indexs = {id} and TYPE = 1";
                }

                sql = Vb.Strings.Replace(sql, "from", @$" into [SV_QueryPlatform].[dbo].[{PROJECT_NAME.Replace(" ", "")}] from", 1, -1, Vb.CompareMethod.Text);

                if (connection.Execute($@"INSERT INTO[SV_QueryPlatform].[dbo].[FlowReservoirStatus]([tableName] ,[createDate] ,[state],indexs,isfilter,[sql],remarks) 
                        select'{PROJECT_NAME}', getdate(), 0,'{id2}' ,{isfilter},'{sql}','{remarks}'") > 0 ? true : false)
                {
                    return connection.Execute(sql.Replace("''","'")) > 0 ? true : false;
                }
                else
                {
                    throw new DomainException("创建 [SV_QueryPlatform].[dbo].[" + PROJECT_NAME + "]流水库表失败");
                }
            }
        }
        /// <summary>
        /// 查询日志
        /// </summary> 
        public IEnumerable<dynamic> ShowLog(long indexs, string tableName)
        {
            using (DbConnection connection = new SqlConnection(_configConnectionString))
            {
                var logs = connection.Query<SYS_LOG>($@"select * FROM [SV_QueryPlatform].[dbo].[SYS_LOG] where indexs={indexs}").ToList();
                //医院数
                var hoscount = connection.Query<PUBPATIENT>($@"select case when HOS_ID>=112 and HOS_ID<=138 then 112 else HOS_ID end HOS_ID ,MASTER_INDEX from[dbo].[{tableName}]").ToList().Select(h => h.HOS_ID).Distinct().Count();
                logs = logs.Where(w => w.INDEXS == indexs & w.type != "执行中" & !w.LOG.Contains("创建")).ToList();

                //已执行的医院数
                var run = (from r in logs
                           group r by r.LOG into log
                           select new
                           {
                               排序 = log.Key.Contains("PUB_PATIENT") ? 1 : (log.Key.Contains("REG") ? 2 : (log.Key.Contains("OUT") ? 3 : (log.Key.Contains("INPAT") ? 4 : (log.Key.Contains("OPS") ? 5 : 6)))),
                               操作内容 = log.Key.Replace(" ", ""),
                               已执行医院数 = log.Select(s => s.HOS_CODE).Distinct().Count(),
                               失败医院数 = log.Where(w => !w.type.Contains("成功")).Select(s => s.HOS_CODE).Distinct().Count(),
                               耗时间 = ((TimeSpan)(log.Select(sq => sq.CreateDate).Max() - log.Select(sq => sq.CreateDate).Min())).TotalMinutes,
                               执行进度 = Math.Round(Convert.ToDecimal(log.Select(s => s.HOS_CODE).Distinct().Count() / Convert.ToDecimal(hoscount)) * 100, 2),
                               预计结束时间 = ((log.Select(s => s.HOS_CODE).Distinct().Count() / hoscount) == 1 ? 0 : ((TimeSpan)(log.Select(sq => sq.CreateDate).Max() - log.Select(sq => sq.CreateDate).Min())).TotalMinutes / (log.Select(s => s.HOS_CODE).Distinct().Count() == 1 ? 2 : log.Select(s => s.HOS_CODE).Distinct().Count())) * (hoscount - log.Select(s => s.HOS_CODE).Distinct().Count())
                           }).ToList().OrderBy(o => o.排序);


                return run.Select(o => new
                {
                    o.操作内容,
                    o.已执行医院数,
                    o.失败医院数,
                    耗时间 = "已耗时：" + Math.Round(o.耗时间) + "分钟",
                    执行进度 = o.执行进度.ToString() + "%",
                    预计结束时间 = o.预计结束时间 == 0 ? "已结束" : DateTime.Now.AddMinutes(o.预计结束时间).ToString()

                });
                //                return connection.Query($@"      SELECT case when log like '%OUT_PRES%' then 'OUT_PRES'when log like '%OUT_FEE%' then 'OUT_FEE'when log like '%INPAT_FEE%' then 'INPAT_FEE'when log like '%INPAT_ORDER%' then  'INPAT_ORDER'ELSE LOG END 操作内容,
                // DATEDIFF( Minute,MIN(CreateDate),MAX(CreateDate))[耗时间(分)],count(  hos_code) 已执行医院数 ,count(distinct  hos_code) 已执行医院数1,
                // concat(count(hos_code)/cast((select  count(distinct hos_id) from [dbo].[{tableName}] )as money)*100,'','%') 执行进度,
                // case when ( count(hos_code)/cast((select  count(distinct hos_id) from [dbo].[{tableName}] )as money) )=1 then 0  else ((DATEDIFF( Minute,MIN(CreateDate),MAX(CreateDate))/cast((case when count(hos_code)=1 then 2 else count(hos_code) end  -1 )as money))* ((cast((select  count(distinct hos_id) from [dbo].[{tableName}] )as money))-count(hos_code))) end [预计结束时间(分)], 
                // sum(case when type not like '%成功%' then 1 else 0 end )失败医院数
                //  FROM [SV_QueryPlatform].[dbo].[SYS_LOG] where indexs={indexs} and type <>'执行中' and log not like '%创建%'
                //group by case when log like '%OUT_PRES%' then 'OUT_PRES'when log like '%OUT_FEE%' then 'OUT_FEE'when log like '%INPAT_FEE%' then 'INPAT_FEE'when log like '%INPAT_ORDER%' then  'INPAT_ORDER'ELSE LOG END 
                //order by count(hos_code) desc,DATEDIFF( Minute,MIN(CreateDate),MAX(CreateDate))").ToList();
            }
        }
        /// <summary>
        /// 查询流水表
        /// </summary>
        public (IEnumerable<dynamic>, IEnumerable<dynamic>) QueryFlowDatabase(long paseIndex)
        {
            using (DbConnection connection = new SqlConnection(_configConnectionString))
            {
                return (connection.Query($@"SELECT * FROM [SV_QueryPlatform].[dbo].[FlowReservoirStatus]  order by id desc offset ({paseIndex} - 1)*(10) rows fetch next 10 rows only").ToList(), connection.Query($@"SELECT   COUNT(*),CAST(COUNT(*)AS MONEY)totalCount ,{paseIndex} paseIndex FROM [SV_QueryPlatform].[dbo].[FlowReservoirStatus]  ").ToList());
            }
        }
        /// <summary>
        /// 日志
        /// </summary>
        public void LOG(string LOG, string hos_code, long indexs, string type, string sql)
        {
            using (DbConnection connection = new SqlConnection(_configConnectionString))
            {
                sql = sql.Replace("'", "''");
                connection.Execute($@"INSERT INTO[SV_QueryPlatform].[dbo].[SYS_LOG]([INDEXS] ,hos_code,[createDate] ,[LOG],type,[错误sql]) 
                                        select'{indexs}','{hos_code}', getdate(),'{LOG}','{type}','{sql}'");
            }
        }
        /// <summary>
        /// sql查询
        /// </summary>
        public string[] ShowSql(string TableName, long sqlint)
        {
            using (DbConnection connection = new SqlConnection(_configConnectionString))
            {
                var sql = $@" SELECT sql FROM  [SV_QueryPlatform].[dbo].[Execute_SQL] WHERE type=1 AND TableName ='{TableName}' ";
                string[] A = connection.Query<string>(sql).ToArray();
                return A;
            }
        }
        /// <summary>
        /// 创建流水库
        /// </summary>
        public bool CreateAFlow_Library(string DatabaseName, long indexs)
        {
            DatabaseName = DatabaseName.Replace(" ", "");
            //建立流水库脚本 
            using (DbConnection connection = new SqlConnection(_configConnectionString))
            {
                var sql = $@"CREATE DATABASE [DB_{DatabaseName}] CONTAINMENT = NONE ON  PRIMARY ( NAME = N'DB_{DatabaseName}', FILENAME = N'e:\database\DB_{DatabaseName}.mdf' , SIZE = 1454080KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB ) LOG ON ( NAME = N'DB_{DatabaseName}_log', FILENAME = N'e:\database\DB_{DatabaseName}_log.ldf' , SIZE = 388544KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)ALTER DATABASE [DB_{DatabaseName}] SET COMPATIBILITY_LEVEL = 120
                                      IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
                                      EXEC [DB_{DatabaseName}].[dbo].[sp_fulltext_database] @action = 'enable'
                                      ALTER DATABASE [DB_{DatabaseName}] SET ANSI_NULL_DEFAULT OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET ANSI_NULLS OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET ANSI_PADDING OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET ANSI_WARNINGS OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET ARITHABORT OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET AUTO_CLOSE OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET AUTO_SHRINK OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET AUTO_UPDATE_STATISTICS ON 
                                      ALTER DATABASE [DB_{DatabaseName}] SET CURSOR_CLOSE_ON_COMMIT OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET CURSOR_DEFAULT  GLOBAL
                                      ALTER DATABASE [DB_{DatabaseName}] SET CONCAT_NULL_YIELDS_NULL OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET NUMERIC_ROUNDABORT OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET QUOTED_IDENTIFIER OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET RECURSIVE_TRIGGERS OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET  DISABLE_BROKER 
                                      ALTER DATABASE [DB_{DatabaseName}] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET DATE_CORRELATION_OPTIMIZATION OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET TRUSTWORTHY OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET ALLOW_SNAPSHOT_ISOLATION OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET PARAMETERIZATION SIMPLE 
                                      ALTER DATABASE [DB_{DatabaseName}] SET READ_COMMITTED_SNAPSHOT OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET HONOR_BROKER_PRIORITY OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET RECOVERY FULL
                                      ALTER DATABASE [DB_{DatabaseName}] SET  MULTI_USER 
                                      ALTER DATABASE [DB_{DatabaseName}] SET PAGE_VERIFY CHECKSUM  
                                      ALTER DATABASE [DB_{DatabaseName}] SET DB_CHAINING OFF 
                                      ALTER DATABASE [DB_{DatabaseName}] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF ) 
                                      ALTER DATABASE [DB_{DatabaseName}] SET TARGET_RECOVERY_TIME = 0 SECONDS 
                                      ALTER DATABASE [DB_{DatabaseName}] SET DELAYED_DURABILITY = DISABLED 
                                      ALTER DATABASE [DB_{DatabaseName}] SET  READ_WRITE  ";
                connection.Execute(sql);
                if (connection.Query("select name from dbo.sysdatabases where name='DB_" + DatabaseName + "'").Count() > 0 ? true : false)
                {
                    try
                    {
                        LOG($@"创建DB_{DatabaseName} 流水库成功！", "", indexs, "", "");
                        sql = $@"     CREATE TABLE [DB_{DatabaseName}].[dbo].[ASSAY_REPORT](
                                 	[REPORT_ID] [bigint]  IDENTITY(1,1) NOT NULL,
                                 	[REPORT_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[REPORT_TIME] [datetime] NULL,
                                 	[SPECIMEN_TYPE] [nvarchar](max) NULL,
                                 	[ASSAY_ITEM_CODE] [nvarchar](max) NULL,
                                 	[ASSAY_ITEM_NAME] [nvarchar](max) NULL,
                                 	[ITEM_ENAME] [nvarchar](max) NULL,
                                 	[UNIT] [nvarchar](max) NULL,
                                 	[RESULTS] [nvarchar](max) NULL,
                                 	[REFRANGE] [nvarchar](max) NULL,
                                 	[RESULTSTATUS] [nvarchar](max) NULL,
                                 	[REG_SOURCE] [int] NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                  CONSTRAINT [PK_ASSAY_REPORT] PRIMARY KEY CLUSTERED 
                                 (
                                 	[REPORT_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[EXEC_REPORT](
                                 	[REPORT_ID] [bigint]IDENTITY(1,1)  NOT NULL,
                                 	[REPORT_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[ORDER_ID] [bigint] NULL,
                                 	[ORDER_CODE] [nvarchar](max) NULL,
                                 	[PATIENT_MEDICALREC] [nvarchar](max) NULL,
                                 	[EXAMINE_NAME] [nvarchar](max) NULL,
                                 	[EXAMINE_SHOW] [nvarchar](max) NULL,
                                 	[EXAMINE_RESULT] [nvarchar](max) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[REPORT_TIME] [datetime] NULL,
                                 	[REG_SOURCE] [int] NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                  CONSTRAINT [PK_EXEC_REPORT] PRIMARY KEY CLUSTERED 
                                 (
                                 	[REPORT_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[INPAT_DIAG](
                                 	[DIAG_ID] [bigint]IDENTITY(1,1)  NOT NULL,
                                 	[DIAG_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[ICD] [nvarchar](max) NULL,
                                 	[DISEASE_NAME] [nvarchar](max) NULL,
                                 	[REMARKS] [nvarchar](max) NULL,
                                 	[TYPE] [nvarchar](max) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[DIAG_TIME] [datetime] NULL,
                                 	[CURE_STATUS] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                  CONSTRAINT [PK_INPAT_DIAG] PRIMARY KEY CLUSTERED 
                                 (
                                 	[DIAG_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[INPAT_FEE](
                                 	[CHARGE_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[CHARGE_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[CATERY] [nvarchar](max) NULL,
                                 	[ITEM_TYPE] [nvarchar](max) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[ITEM_NAME] [nvarchar](max) NULL,
                                 	[UNITPRICE] [money] NULL,
                                    [QUANTITY] [money] NULL,
                                 	[CATEGORY] [nvarchar](max) NULL,
                                 	[UNIT] [nvarchar](max) NULL,
                                 	[FEE] [money] NULL,
                                 	[CHARGE_TIME] [datetime] NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[DEPT_CODE] [nvarchar](max) NULL,
                                 	[DEPT_NAME] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[I_TYPE_NAME] [nvarchar](max) NULL,
                                 	[MEDIC_AREA] [nvarchar](max) NULL,
                                 	 EXEC_DEPT_CODE NVARCHAR(max)null,
                                 	 EXEC_DEPT_NAME NVARCHAR(max)null,
                                 	 EXEC_EMP_CODE NVARCHAR(max)null,
                                 	 EXEC_EMP_NAME varbinary(max) NULL
                                  CONSTRAINT [PK_INPAT_FEE] PRIMARY KEY CLUSTERED 
                                 (
                                 	[CHARGE_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[INPAT_ORDER](
                                 	[ORDER_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[ORDER_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[MEDICAL_ORDER_TYPE] [nvarchar](max) NULL,
                                 	[ITEM_TYPE] [nvarchar](max) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[ITEM_NAME] [nvarchar](max) NULL,
                                 	[SKINTEST] [nvarchar](max) NULL,
                                 	[MEDI_SPEC] [nvarchar](max) NULL,
                                 	[EACH_DOSE] [nvarchar](max) NULL,
                                 	[MEDI_DOSE_UNIT] [nvarchar](max) NULL,
                                 	[MEDIC_USE_QUANTITY] [nvarchar](max) NULL,
                                 	[MEDI_USE_UNIT] [nvarchar](max) NULL,
                                 	[MEDIC_USE_PLAN] [nvarchar](max) NULL,
                                 	[MEDIC_USE_MODE] [nvarchar](max) NULL,
                                 	[MEDIC_QUANTITY] [nvarchar](max) NULL,
                                 	[UNITPRICE] [money] NULL,
                                 	[MEDICAL_ORDER_DAYS] [nvarchar](max) NULL,
                                 	[INTAKE_START_TIME] [datetime] NULL,
                                 	[INTAKE_END_TIME] [datetime] NULL,
                                 	[INTAKE_DATES] [int] NULL,
                                 	[REMARKS] [nvarchar](max) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[MEDIC_AREA] [nvarchar](max) NULL,
                                  CONSTRAINT [PK_INPAT_ORDER] PRIMARY KEY CLUSTERED 
                                 (
                                 	[ORDER_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[INPAT_REG_INFO](
                                 	[REG_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[PERSON_ID] [bigint] NULL,
                                 	[PERSON_CODE] [nvarchar](100) NULL,
                                 	[IN_DEPT_CODE] [nvarchar](max) NULL,
                                 	[IN_DEPT_NAME] [nvarchar](max) NULL,
                                 	[WARD_NAME] [nvarchar](max) NULL,
                                 	[EMP_CODE_INCHARGE] [nvarchar](max) NULL,
                                 	[EMP_NAME_INCHARGE] [varbinary](max) NULL,
                                 	[EMP_CODE_RESIDENT] [nvarchar](max) NULL,
                                 	[EMP_NAME_RESIDENT] [varbinary](max) NULL,
                                 	[INHOS_TIME] [datetime] NULL,
                                 	[OUTHOS_TIME] [datetime] NULL,
                                 	[CARD_TYPE] [nvarchar](max) NULL,
                                 	[CARD_ID] [nvarchar](max) NULL,
                                 	[HEIGHT] [nvarchar](max) NULL,
                                 	[WEIGHT] [nvarchar](max) NULL,
                                 	[INHOS_STATUS] [nvarchar](max) NULL,
                                 	[OUTHOS_STATUS] [nvarchar](max) NULL,
                                 	[F_DIAG] [nvarchar](max) NULL,
                                 	[I_DEPT_NAME] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[I_CARD_TYPE] [nvarchar](max) NULL,
                                 	[WAISTLINE] [nvarchar](max) NULL,
                                 	[TOTAL_FEE] [money] NULL,
                                 	[PAY_FEE] [money] NULL,
                                 	 OUT_DEPT_CODE NVARCHAR(max) null,
                                 	 OUT_DEPT_NAME NVARCHAR(max)null,
                                 	 SOURCE NVARCHAR(max)null
                                  CONSTRAINT [PK_INPAT_REG_INFO] PRIMARY KEY CLUSTERED 
                                 (
                                 	[REG_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[OPS_INFO](
                                 	[OPS_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[OPS_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[ORDER_ID] [bigint] NULL,
                                 	[ORDER_CODE] [nvarchar](max) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[ITEM_NAME] [nvarchar](max) NULL,
                                 	[PODX] [nvarchar](max) NULL,
                                 	[RESULTS] [nvarchar](max) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[OPS_LEVEL] [nvarchar](max) NULL,
                                 	[WOUND_LEVEL] [nvarchar](max) NULL,
                                 	[START_TIME] [datetime] NULL,
                                 	[END_TIME] [datetime] NULL,
                                 	[F_HELPER] [varbinary](max) NULL,
                                 	[S_HELPER] [varbinary](max) NULL,
                                 	[F_ANAESTHESIA] [varbinary](max) NULL,
                                 	[S_ANAESTHESIA] [varbinary](max) NULL,
                                 	[DEPT_CODE] [nvarchar](max) NULL,
                                 	[DEPT_NAME] [nvarchar](max) NULL,
                                 	[CURE_STATUS] [nvarchar](max) NULL,
                                 	[ANESTHESIA_METHOD] [nvarchar](max) NULL,
                                 	[ELECTIVE_SURGERY] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[ICD_9_CM] [nvarchar](max) NULL,
                                 	[I_ITEM_NAME] [nvarchar](max) NULL,
                                 	[I_ICD_9_CM] [nvarchar](max) NULL,
                                  CONSTRAINT [PK_OPS_INFO] PRIMARY KEY CLUSTERED 
                                 (
                                 	[OPS_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[OUT_DIAG](
                                 	[DIAG_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[DIAG_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[ICD] [nvarchar](max) NULL,
                                 	[DISEASE_NAME] [nvarchar](max) NULL,
                                 	[DIAG_TIME] [datetime] NULL,
                                 	[REMARKS] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                  CONSTRAINT [PK_OUT_DIAG] PRIMARY KEY CLUSTERED 
                                 (
                                 	[DIAG_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[OUT_FEE](
                                 	[CHARGE_ID] [bigint]IDENTITY(1,1)  NOT NULL,
                                 	[CHARGE_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[CATERY] [nvarchar](max) NULL,
                                 	[ITEM_TYPE] [nvarchar](max) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[ITEM_NAME] [nvarchar](max) NULL,
                                 	[UNITPRICE] [money] NULL,
                                    [CATEGORY] [nvarchar](max) NULL,
                                 	[QUANTITY] [money] NULL,
                                 	[UNIT] [nvarchar](max) NULL,
                                 	[FEE] [money] NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[DEPT_CODE] [nvarchar](max) NULL,
                                 	[DEPT_NAME] [nvarchar](max) NULL,
                                 	[CHARGE_TIME] [datetime] NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[I_TYPE_NAME] [nvarchar](max) NULL,
                                 	[MEDIC_AREA] [nvarchar](max) NULL,
                                 	 EXEC_DEPT_CODE NVARCHAR(max)null,
                                 	 EXEC_DEPT_NAME NVARCHAR(max)null,
                                 	 EXEC_EMP_CODE NVARCHAR(max)null,
                                 	 EXEC_EMP_NAME varbinary(max) NULL
                                  CONSTRAINT [PK_OUT_FEE] PRIMARY KEY CLUSTERED 
                                 (
                                 	[CHARGE_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[OUT_PRES](
                                 	[PRES_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[PRES_CODE] [nvarchar](max) NULL,
                                 	[REG_ID] [bigint] NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[GROUPNO] [nvarchar](max) NULL,
                                 	[NO] [nvarchar](max) NULL,
                                 	[PRES_TIME] [datetime] NULL,
                                 	[PRES_TYPE] [nvarchar](max) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[ITEM_CODE] [nvarchar](max) NULL,
                                 	[MEDIC_CLASS] [nvarchar](max) NULL,
                                 	[MEDIC_GENERAL_NAME] [nvarchar](max) NULL,
                                 	[MEDIC_NAME] [nvarchar](max) NULL,
                                 	[MEDIC_TYPE] [nvarchar](max) NULL,
                                 	[MEDIC_SPEC] [nvarchar](max) NULL,
                                 	[MEDIC_AREA] [nvarchar](max) NULL,
                                 	[MEDIC_USE_QUANTITY] [nvarchar](max) NULL,
                                 	[MEDIC_USE_UNIT] [nvarchar](max) NULL,
                                 	[MEDIC_USE_CODE] [nvarchar](max) NULL,
                                 	[MEDIC_USE_MODE] [nvarchar](max) NULL,
                                 	[MEDIC_DAYS] [nvarchar](max) NULL,
                                 	[MEDIC_QUANTITY] [nvarchar](max) NULL,
                                 	[MEDIC_UNIT] [nvarchar](max) NULL,
                                 	[SKINTEST] [nvarchar](max) NULL,
                                 	[MEDIC_REMARK] [nvarchar](max) NULL,
                                 	[MEDIC_INSUREANCE_TYPE] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                  CONSTRAINT [PK_OUT_PRES] PRIMARY KEY CLUSTERED 
                                 (
                                 	[PRES_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[OUT_REG_INFO](
                                 	[REG_ID] [bigint] IDENTITY(1,1) NOT NULL,
                                 	[REG_CODE] [nvarchar](100) NULL,
                                 	[PERSON_ID] [bigint] NULL,
                                 	[PERSON_CODE] [nvarchar](100) NULL,
                                 	[REG_TIME] [datetime] NULL,
                                 	[REG_EMP_CODE] [nvarchar](max) NULL,
                                 	[REG_EMP_NAME] [varbinary](max) NULL,
                                 	[DEPT_CODE] [nvarchar](max) NULL,
                                 	[DEPT_NAME] [nvarchar](max) NULL,
                                 	[EMP_CODE] [nvarchar](max) NULL,
                                 	[EMP_NAME] [varbinary](max) NULL,
                                 	[CARD_TYPE] [nvarchar](max) NULL,
                                 	[CARD_ID] [nvarchar](max) NULL,
                                 	[REG_TYPE] [nvarchar](max) NULL,
                                 	[F_DIAG] [nvarchar](max) NULL,
                                 	[I_DEPT_NAME] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[I_CARD_TYPE] [nvarchar](max) NULL,
                                 	[TOTAL_FEE] [money] NULL,
                                 	[PAY_FEE] [money] NULL,
                                  CONSTRAINT [PK_OUT_REG_INFO] PRIMARY KEY CLUSTERED 
                                 (
                                 	[REG_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 SET ANSI_PADDING OFF
                                 SET ANSI_NULLS ON
                                 SET QUOTED_IDENTIFIER ON
                                 SET ANSI_PADDING ON
                                 CREATE TABLE [DB_{DatabaseName}].[dbo].[PUB_PATIENT](
                                 	[PERSON_ID] [bigint]IDENTITY(1,1)  NOT NULL,
                                 	[PERSON_CODE] [nvarchar](100) NULL,
                                 	[SEX] [nvarchar](max) NULL,
                                 	[BIRTHDAY] [datetime] NULL,
                                 	[MARRIED] [nvarchar](max) NULL,
                                 	[PROVINCE] [nvarchar](max) NULL,
                                 	[CITY] [nvarchar](max) NULL,
                                 	[COUNTY] [nvarchar](max) NULL,
                                 	[OCCUPATION] [nvarchar](max) NULL,
                                 	[BLOOD] [nvarchar](max) NULL,
                                 	[ID_CARD] [varbinary](max) NULL,
                                 	[NATION] [nvarchar](max) NULL,
                                 	[NATIONALITY] [nvarchar](max) NULL,
                                 	[ORG_CODE] [int] NOT NULL,
                                 	[UPLOAD_TIME] [datetime] NULL,
                                 	[EDUCATIONAL_LEVEL] [nvarchar](max) NULL,
                                 	[MASTER_INDEX] nvarchar(MAX)NULL,
                                  CONSTRAINT [PK_PUB_PATIENT] PRIMARY KEY CLUSTERED 
                                 (
                                 	[PERSON_ID] ASC
                                 )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                                 ) ON [PRIMARY]
                                 
                                 SET ANSI_PADDING ON ";
                        connection.Execute(sql);
                        LOG($@"创建DB_{DatabaseName} 流水库表结构成功！", "", indexs, "", "");
                        sql = $@"     CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[ASSAY_REPORT]
                                 (
                                 	[REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[ASSAY_REPORT]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[EXEC_REPORT]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[EXEC_REPORT]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[INPAT_FEE]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[INPAT_FEE]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[INPAT_ORDER]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[INPAT_ORDER]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[INPAT_REG_INFO]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_PERSON_ID] ON[DB_{DatabaseName}].[dbo].[INPAT_REG_INFO]
                                 (
                                 
                                    [PERSON_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_PERSON_CODE] ON[DB_{DatabaseName}].[dbo].[INPAT_REG_INFO]
                                 (
                                 
                                    [PERSON_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[OPS_INFO]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[OPS_INFO]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[OUT_DIAG]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[OUT_DIAG]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[INPAT_DIAG]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[INPAT_DIAG]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[OUT_FEE]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[OUT_FEE]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[OUT_PRES]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_REG_ID] ON[DB_{DatabaseName}].[dbo].[OUT_PRES]
                                 (
                                 
                                    [REG_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 CREATE NONCLUSTERED INDEX[IX_PERSON_ID] ON[DB_{DatabaseName}].[dbo].[OUT_REG_INFO]
                                 (
                                 
                                    [PERSON_ID] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_REG_CODE] ON[DB_{DatabaseName}].[dbo].[OUT_REG_INFO]
                                 (
                                 
                                    [REG_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_PERSON_CODE] ON[DB_{DatabaseName}].[dbo].[OUT_REG_INFO]
                                 (
                                 
                                    [PERSON_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 SET ANSI_PADDING ON
                                 CREATE NONCLUSTERED INDEX[IX_PERSON_CODE] ON[DB_{DatabaseName}].[dbo].[PUB_PATIENT]
                                 (
                                 
                                    [PERSON_CODE] ASC
                                 )WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON[PRIMARY]
                                 ALTER DATABASE[DB_{DatabaseName}] SET READ_WRITE";
                        connection.Execute(sql);
                        LOG($@"创建DB_{DatabaseName} 流水库索引成功！", "", indexs, "", "");
                        return connection.Execute($"UPDATE [SV_QueryPlatform].[dbo].[FlowReservoirStatus] SET state =1 ,DatabaseName='DB_{DatabaseName}' WHERE  indexs={indexs}") > 0 ? true : false;
                    }
                    catch (Exception)
                    {
                        LOG($@"创建DB_{DatabaseName} 流水库操作时出错！", "", indexs, "", "");
                        throw new DomainException($@"创建DB_{DatabaseName} 流水库操作时出错！");
                    }
                }
                return false;
            }
        }
        //public void CheckTimeout()
        //{
        //    using (DbConnection connection = new SqlConnection(_configConnectionString)) // DefaultConnection
        //    {
        //        string[] id = connection.Query<string>("select ID from [SV_QueryPlatform].[dbo].[FlowReservoirStatus] where[state] = 2 and DATEDIFF(HOUR, DataPullTime, getdate()) >3").ToArray();

        //        foreach (var item in id)
        //        {
        //            connection.Execute($@" update [dbo].[FlowReservoirStatus] set state= 4 where id={item}");
        //        }
        //    }
        //}
        public DbConnection Connection(long ip, string y = "", string t = "")
        {
            if (ip == 156)
            {
                return new SqlConnection((y == "") ? _Connection156 : _Connection156.Replace(y, t));
            }
            if (ip == 181)
            {
                return new SqlConnection((y == "") ? _configConnectionString : _configConnectionString.Replace(y, t));
            }
            return new SqlConnection();
        }
        public DbConnection Connection(long ip, string configConnectionString)
        {
            if (ip == 0)
            {
                return new SqlConnection(configConnectionString);
            }
            return new SqlConnection();
        }
        public class zx_
        {
            public long indexs { get; set; }
            public string biao { get; set; }
            public string sql { get; set; }
            public string item { get; set; }
            public string conn { get; set; }

        }
        /// <summary>
        /// 拉取病人表
        /// </summary>
        public void PullData(long indexs, string DatabaseName, string tableName, string biao)
        {
            List<List<zx_>> zx_s = new List<List<zx_>>();
            List<zx_> zx = new List<zx_>();
            //Console.WriteLine(ip+""+ biao);
            var sql = "";
            //var where = @$"and ExecOpenLink in ('{ip}')";
            sql = @$"  select A.*from(
  SELECT  DISTINCT  case when   a.id>=112 and a.id<=138 then '112' else  ID end  'id',
                    case when   a.id>=112 and a.id<=138 then '192.168.18.152' else  ExecOpenLink end  'ExecOpenLink',
                    case when   a.id>=112 and a.id<=138 then 'HOS_631337112' else  ExecDatabase end  'ExecDatabase'
              FROM  [DB_SV_Data_Config].[dbo].[SYS_Hospital] A
                     JOIN [192.168.18.181].[SV_QueryPlatform].[dbo].[{tableName}] B ON A.ID = B.HOS_ID
					 )A
 LEFT JOIN ( SELECT  *  FROM [192.168.18.181].[SV_QueryPlatform].[dbo].[SYS_LOG]  WHERE   INDEXS = {indexs}
                                         AND LOG = '{biao}' and type ='执行中'
                               ) C ON A.ID = CAST(LEFT(RIGHT(C.hos_code, 4),3) AS int)
              WHERE  hos_code IS NULL  
order by NEWID()";//// {where}
            List<SYS_Hospital> hospitals = Connection(156).Query<SYS_Hospital>(sql).ToList();
            Dictionary<string, object> pairs = new Dictionary<string, object>();
            var tasks = new List<System.Threading.Tasks.Task>();
            foreach (var hos in hospitals)
            {
                //   Console.WriteLine("'" + ip + "','" + hos.ExecDatabase + "','" + biao + "'");

                pairs.Clear();
                // 存在  // 不存在
                pairs.TryAdd($"@{nameof(hos.ExecOpenLink)}", hos.ExecOpenLink);
                pairs.TryAdd($"@{nameof(hos.ExecDatabase)}", hos.ExecDatabase);
                pairs.TryAdd($"@{nameof(indexs)}", indexs);
                pairs.TryAdd($"@{nameof(DatabaseName)}", DatabaseName);
                pairs.TryAdd($"@{nameof(tableName)}", tableName);
                pairs.TryAdd($"@{nameof(biao)}", biao);
                var ITEM = "[@ExecOpenLink].[@ExecDatabase]";
                //拉取病人表
                Connection(181).Execute($"UPDATE [SV_QueryPlatform].[dbo].[FlowReservoirStatus] SET state =2 ,DataPullTime=getdate() WHERE  indexs={indexs} and tableName='{tableName.Replace(" ", "")}'");
                //try
                //{
                //long rs = QueryPatient(tableName);
                sql = ShowSql($"{biao}", 2)[0];
                if (hos.ExecDatabase == "HOS_631337112")
                {
                    sql = sql.Replace("HOS_ID=CAST(RIGHT('@ExecDatabase',3)as int)", "HOS_ID>=112 and HOS_ID<=138");
                    sql = sql.Replace("ORG_CODE=CAST(RIGHT('@ExecDatabase',3)as int)", "ORG_CODE>=112 and ORG_CODE<=138");
                }
                foreach (var item1 in pairs)
                {
                    ITEM = ITEM.Replace(item1.Key, item1.Value.ToString());
                    sql = sql.Replace(item1.Key, item1.Value.ToString());
                }
                服务器 fwq = Connection(181).Query<服务器>($"SELECT [服务器ip],[数据库账号],[数据库密码] FROM [SV_QueryPlatform].[dbo].[服务器] where[服务器ip] ='{hos.ExecOpenLink}'").FirstOrDefault();
                var msConnectionString = string.Format("Server={0};Database={1};User ID={2};Password={3};Trusted_Connection=False;", hos.ExecOpenLink, hos.ExecDatabase, fwq.数据库账号, fwq.数据库密码);
                ///  zx(indexs, biao, sql, ITEM, msConnectionString);
                zx.Add(new zx_() { indexs = indexs, sql = sql, biao = biao, item = ITEM, conn = msConnectionString });
                int zxs = 10;
                if (biao != "PUB_PATIENT")
                {
                    if (biao == "OUT_REG_INFO" || biao == "INPAT_REG_INFO")
                    {
                        zxs = 8;
                    }
                    else if (biao == "INPAT_FEE" || biao == "INPAT_ORDER" || biao == "ASSAY_REPORT" || biao == "OUT_PRES" || biao == "OUT_FEE"|| biao.Contains("dbz"))
                    {
                        zxs = 1;
                    }
                    else
                    {
                        zxs = 2;
                    }
                }
                if (zx.Count == zxs)
                {
                    // 如果达到了，将当前组添加到分组数据中，并创建一个新的组  
                    zx_s.Add(zx);
                    zx = new List<zx_>();// 创建新的空组  
                }

                //}
                //catch (Exception e)
                //{
                //    LOG($"{biao}", ITEM, indexs, "错误", $"报错sql:{sql}错误日志:{e}");
                //    PullData(indexs, DatabaseName, tableName, biao, ip);//跳过错误执行未执行的医院
                //}
                Connection(181).Execute($"UPDATE [SV_QueryPlatform].[dbo].[FlowReservoirStatus] SET DataPullTime=getdate() WHERE  indexs={indexs} and tableName='{tableName}'");
            }
            if (zx.Count > 0)
            {
                // 如果达到了，将当前组添加到分组数据中，并创建一个新的组  
                zx_s.Add(zx);
                zx = new List<zx_>();// 创建新的空组  
            }

            foreach (var item in zx_s.OrderByDescending(o => o.Count()))
            {
                foreach (var item1 in item)
                {
                    tasks.Add(System.Threading.Tasks.Task.Factory.StartNew(() => zxcz(item1)));
                }
                System.Threading.Tasks.Task.WaitAll(tasks.ToArray());
            }
        }


        //控制每次执行sql条数
        // private static SemaphoreSlim semaphoreZX = new SemaphoreSlim(0, 2);
        private void zxcz(zx_ zx)
        {
            //  semaphoreZX.WaitAsync();
            long num = 0;
            Exception e = null;
            LOG($"{zx.biao}", zx.item, zx.indexs, "执行中", "");
            try
            {
                num = Connection(0, zx.conn).Execute(zx.sql, commandTimeout: 60 * 60 * 60 * 5);
                Connection(0, zx.conn).Close();
            }
            catch (Exception ex)
            {
                e = ex;
                num = -1;
            }
            finally
            {
                // semaphoreZX.Release();
            }

            if (num != -1)
            {
                LOG($"{zx.biao}", zx.item, zx.indexs, "成功", zx.sql);
            }
            else
            {
                LOG($"{zx.biao}", zx.item, zx.indexs, "错误", $"报错sql:{zx.sql}错误日志:{e}");
            }

        }
        public void pullstate(long indexs, string tableName)
        {
            Connection(181).Execute(@$"
delete  [SV_QueryPlatform].[dbo].[SYS_LOG]  from  [SV_QueryPlatform].[dbo].[SYS_LOG] a
join 
( 
SELECT  
a.INDEXS,a.hos_code, a.log, a.type
FROM (select *from [SV_QueryPlatform].[dbo].[SYS_LOG] where indexs ={indexs} and type='执行中')a
left join (select *from [SV_QueryPlatform].[dbo].[SYS_LOG] where indexs ={indexs} and type='成功 ') b on a.hos_code=b.hos_code  and a.log=b.LOG 
where b.type is null
) b on a.hos_code=b.hos_code and a.LOG=b.log and a.INDEXS=b.indexs
where a.indexs ={indexs} and a.type='执行中';

UPDATE [SV_QueryPlatform].[dbo].[FlowReservoirStatus] SET state =10 ,DataPullTime=getdate() WHERE  indexs={indexs} and tableName='{tableName.Replace(" ", "")}'");
        }
        private void 执行加日志(long indexs, string biao, string sql, string ITEM)
        {
            Connection(181).Execute(sql, commandTimeout: 60 * 60 * 60 * 5);
            LOG($"{biao}", ITEM, indexs, "成功", sql);
        }
        /// <summary>
        /// 多线程拉取病人表
        /// </summary>
        /// <param name="indexs"></param>
        /// <param name="DatabaseName"></param>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public void PullData(long indexs, string DatabaseName, string tableName, int dbz = 0)
        {
            //写一个 人群表查询人数
            // long rs = QueryPatient(tableName);
            //  long xfwqrs = xingfqrs(tableName);
            DatabaseName = DatabaseName.Replace(" ", "");
            tableName = tableName.Replace(" ", "");
            var data = new List<List<string>>
                {
                    new List<string>{"PUB_PATIENT"},
                    new List<string>{"OUT_REG_INFO","INPAT_REG_INFO"},
                    new List<string>{"ASSAY_REPORT","INPAT_DIAG","OPS_INFO","INPAT_FEE","EXEC_REPORT","OUT_DIAG","INPAT_ORDER","OUT_PRES","OUT_FEE"},
                };
            if (dbz == 1)
            {
                data = new List<List<string>>
                {
                    new List<string>{"PUB_PATIENT"},
                    new List<string>{"OUT_REG_INFO","INPAT_REG_INFO"},
                    new List<string>{ "dbz_OUT_DIAG", "dbz_INPAT_DIAG", "dbz_OUT_FEE", "dbz_INPAT_FEE"},
                };
            }
            // var fwqdata = 标准库fwq().Select(s => s.服务器ip);
            var tasks = new List<System.Threading.Tasks.Task>();
            foreach (var item in data)
            {
                foreach (var biao in item)
                {
                    //foreach (var ip in fwqdata)
                    //{
                    tasks.Add(System.Threading.Tasks.Task.Factory.StartNew(() => PullData(indexs, DatabaseName, tableName, biao//, ip
                        )));
                    // }
                }
                System.Threading.Tasks.Task.WaitAll(tasks.ToArray());
            }
            //修复执行错误方法
            try
            {
                //PullData修复超时错误(indexs);
            }
            catch (Exception e)
            {
                LOG($"修复超时错误", "修复超时错误", indexs, "修复失败", $"报错:{e}");
            }
            finally
            {
                var sql = @$"UPDATE @DBName.dbo.PUB_PATIENT 
SET MASTER_INDEX = CONCAT(MASTER_INDEX, '_', ORG_CODE), PERSON_CODE = CONCAT(PERSON_CODE, '_', ORG_CODE)
FROM @DBName.dbo.PUB_PATIENT;

                UPDATE @DBName.dbo.OUT_REG_INFO
                SET PERSON_CODE = CONCAT(PERSON_CODE, '_', ORG_CODE),REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.OUT_REG_INFO
                SET PERSON_ID = B.PERSON_ID
FROM @DBName.dbo.PUB_PATIENT B
WHERE @DBName.dbo.OUT_REG_INFO.PERSON_CODE = B.PERSON_CODE AND @DBName.dbo.OUT_REG_INFO.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.OUT_DIAG
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.OUT_DIAG
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.OUT_REG_INFO B
WHERE @DBName.dbo.OUT_DIAG.REG_CODE = B.REG_CODE AND @DBName.dbo.OUT_DIAG.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.OUT_PRES
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.OUT_PRES
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.OUT_REG_INFO B
WHERE @DBName.dbo.OUT_PRES.REG_CODE = B.REG_CODE AND @DBName.dbo.OUT_PRES.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.OUT_FEE
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.OUT_FEE
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.OUT_REG_INFO B
WHERE @DBName.dbo.OUT_FEE.REG_CODE = B.REG_CODE AND @DBName.dbo.OUT_FEE.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.INPAT_REG_INFO
                SET PERSON_CODE = CONCAT(PERSON_CODE, '_', ORG_CODE),REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.INPAT_REG_INFO
                SET PERSON_ID = B.PERSON_ID
FROM @DBName.dbo.PUB_PATIENT B
WHERE @DBName.dbo.INPAT_REG_INFO.PERSON_CODE = B.PERSON_CODE AND @DBName.dbo.INPAT_REG_INFO.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.INPAT_DIAG
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.INPAT_DIAG
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.INPAT_REG_INFO B
WHERE @DBName.dbo.INPAT_DIAG.REG_CODE = B.REG_CODE AND @DBName.dbo.INPAT_DIAG.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.INPAT_ORDER
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.INPAT_ORDER
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.INPAT_REG_INFO B
WHERE @DBName.dbo.INPAT_ORDER.REG_CODE = B.REG_CODE AND @DBName.dbo.INPAT_ORDER.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.INPAT_FEE
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.INPAT_FEE
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.INPAT_REG_INFO B
WHERE @DBName.dbo.INPAT_FEE.REG_CODE = B.REG_CODE AND @DBName.dbo.INPAT_FEE.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.OPS_INFO
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.OPS_INFO
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.INPAT_REG_INFO B
WHERE @DBName.dbo.OPS_INFO.REG_CODE = B.REG_CODE AND @DBName.dbo.OPS_INFO.ORG_CODE = B.ORG_CODE;

                UPDATE @DBName.dbo.EXEC_REPORT
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.EXEC_REPORT
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.OUT_REG_INFO B
WHERE @DBName.dbo.EXEC_REPORT.REG_CODE = B.REG_CODE AND @DBName.dbo.EXEC_REPORT.ORG_CODE = B.ORG_CODE AND REG_SOURCE = 1;
                UPDATE @DBName.dbo.EXEC_REPORT
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.INPAT_REG_INFO B
WHERE @DBName.dbo.EXEC_REPORT.REG_CODE = B.REG_CODE AND @DBName.dbo.EXEC_REPORT.ORG_CODE = B.ORG_CODE AND REG_SOURCE = 2;

                UPDATE @DBName.dbo.ASSAY_REPORT
                SET REG_CODE = CONCAT(REG_CODE, '_', ORG_CODE);
                UPDATE @DBName.dbo.ASSAY_REPORT
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.OUT_REG_INFO B
WHERE @DBName.dbo.ASSAY_REPORT.REG_CODE = B.REG_CODE AND @DBName.dbo.ASSAY_REPORT.ORG_CODE = B.ORG_CODE AND REG_SOURCE = 1;
                UPDATE @DBName.dbo.ASSAY_REPORT
                SET REG_ID = B.REG_ID
FROM @DBName.dbo.INPAT_REG_INFO B
WHERE @DBName.dbo.ASSAY_REPORT.REG_CODE = B.REG_CODE AND @DBName.dbo.ASSAY_REPORT.ORG_CODE = B.ORG_CODE AND REG_SOURCE = 2; ".Replace("@DBName", DatabaseName);
                //    Connection(181).Execute(sql, commandTimeout: 60 * 60 * 60 * 5);//拉取完成
            }

            Connection(181).Execute($"UPDATE [SV_QueryPlatform].[dbo].[FlowReservoirStatus] SET state =5 WHERE  indexs={indexs} and tableName='{tableName.Replace(" ", "")}'");//拉取完成
        }
        //       public void PullData修复超时错误(long indexs)
        //       {
        //           DbConnection connection = new SqlConnection(_configConnectionString);
        //           //读取错误日志
        //           var sql = @$"select [ID], [INDEXS], hos_code ,
        //[LOG], [CreateDate], [type], REPLACE( REPLACE([错误sql] ,'[192.168.18.181].',''),REPLACE(hos_code,SUBSTRING(hos_code,1,CHARINDEX('[H',hos_code)-1),''),hos_code)  from (
        //select [ID], [INDEXS], [hos_code] ,[LOG], 
        //[CreateDate], [type], REPLACE(left([错误sql],CHARINDEX('错误日志',[错误sql])-1),'报错sql:','')[错误sql] FROM [SV_QueryPlatform].[dbo].[SYS_LOG] 
        //where indexs={indexs} and type='错误')a";
        //           var log = connection.Query<SYS_LOG>(sql).ToList();
        //           var 错误log = log.Where(s => s.type == "错误");
        //           //foreach 错误sql
        //           foreach (var item in 错误log.OrderBy(o => o.LOG))
        //           {//错误日志修复
        //               System.Threading.Tasks.Task.Factory.StartNew(() => PullData修复超时错误(item.IP, item.HOS, item.id, item.错误sql));
        //           }
        //       }
        //       public void PullData修复超时错误(string ip, string hos, int id, string sql)
        //       {
        //           long num = Connection(181).Execute(sql, commandTimeout: 60 * 60 * 60 * 5);
        //           if (num > 0) { Connection(181).Execute(@$"update [SV_QueryPlatform].[dbo].[SYS_LOG] set type='成功' where id ={id}", commandTimeout: 60 * 60 * 60 * 5); }
        //       }
        public long QueryPatient(string tableName)
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            var rs = connection.Query<PUBPATIENT>($@"SELECT distinct HOS_ID,MASTER_INDEX FROM [SV_QueryPlatform].[dbo].[{tableName}]").Count();
            return rs;
        }
        public List<服务器> 标准库fwq()
        {
            DbConnection connection = new SqlConnection(_configConnectionString);
            return connection.Query<服务器>($@"SELECT * FROM [SV_QueryPlatform].[dbo].[服务器] where type='标准库'").ToList();

        }
    }
}


