﻿using Microsoft.AspNetCore.SignalR;
using Microsoft.Extensions.Logging;
using QueryPlatform.Api.Infrastructure.Hubs;
using QueryPlatform.Infra;
using System.Collections.Concurrent;
using System.Threading.Tasks;

namespace QueryPlatform.Api.Infrastructure.Queues
{

    public class HubNotificationQueue
    {
        private readonly IJsonConverter _converter;
        private readonly ILogger<HubNotificationQueue> _logger;
        private IHubContext<NotificationHub> _hubContext;
        private BlockingCollection<Notification> _queue;
        public HubNotificationQueue(
            IJsonConverter converter,
            ILogger<HubNotificationQueue> logger,
            IHubContext<NotificationHub> hubContext)
        {
            _converter = converter;
            _logger = logger;
            _hubContext = hubContext;
            _queue = new BlockingCollection<Notification>();
            Task.Factory.StartNew(() => Consumer());
        }

        public void Send(Notification message)
        {
            _queue.TryAdd(message);
        }

        private void Consumer()
        {
            foreach (var item in _queue.GetConsumingEnumerable())
            {
                _logger.LogInformation("ConectionId GroupName：{ConectionId}；消息推送：{Method}；内容：{Body}", item.UserId.ToString(), item.Method, _converter.Serialize(item.Body));
                _hubContext.Clients.Group(item.UserId.ToString()).SendAsync(item.Method, item.Body);
            }
        }
    }
}
