﻿using System.Collections.Generic;

public enum Status
{
    Ok = 200,
    Failed = 501,
    Warn = 403,
    TokenInvalid = 401,
    PramError = 400,
}
public abstract class ApiResponse
{
    public ApiResponse() { }
    public ApiResponse(Status status)
        : this()
    {
        Status = status;
    }
    public Status Status { get; set; }
}
public class UnauthorizedResponse : ApiResponse
{
    public UnauthorizedResponse()
    {
        Status = Status.TokenInvalid;
        Message = "Token无效";
    }

    public string Message { get; set; }
}
public class ParameterErrorResponse : ApiResponse
{
    public ParameterErrorResponse()
    {
        Errors = new Dictionary<string, string>();
        Status = Status.PramError;
        Message = "参数无效";
    }
    public Dictionary<string, string> Errors { get; set; }

    public string Message { get; set; }

    public string Instance { get; set; }
}
public class longernalServerErrorResponse : ApiResponse
{
    public longernalServerErrorResponse()
    {
        Status = Status.TokenInvalid;
        Message = "Token无效";
    }
    public object Developer { get; set; }

    public string Message { get; set; }

    public string Instance { get; set; }
}
public class DomainErrorResponse : ApiResponse
{

    public string Message { get; set; }

    public string Instance { get; set; }
}
public class OkResponse : ApiResponse
{
    public OkResponse(object data)
    {
        Status = Status.Ok;
        Data = data;
    }
    public object Data { get; set; }
}
public class DoubleSubmitResponse : ApiResponse
{
    public DoubleSubmitResponse()
    {
        Status = Status.Warn;
        Message = "网络拥挤，请稍后重试";
    }
    public string Message { get; set; }
}