﻿using System.Collections.Generic;
using System.Linq;

public static partial class UtilExtensions
{
    public static SortedDictionary<Tkey, TValue> SortedDictionary<Tkey, TValue>(this Dictionary<Tkey, TValue> pairs)
    {
        SortedDictionary<Tkey, TValue> dic = new SortedDictionary<Tkey, TValue>();
        foreach (var item in pairs)
        {
            dic.Add(item.Key, item.Value);
        }
        return dic;
    }

    public static string JoinUrlArgument<Tkey, TValue>(this SortedDictionary<Tkey, TValue> pairs)
    {
        return string.Join("&", pairs.Select(w => $"{w.Key}={w.Value}"));
    }
}

