﻿using System;
using System.Security.Cryptography;
using System.Text;


public static partial class UtilExtensions
{
    public static string RemoveLineBreak(this string text)
    {
        return text.Replace("\n", "");
    }

    public static string RemoveEnter(this string text)
    {
        return text.Replace("\r", "");
    }
    public static string Md5Encrypt(this string text, string charset = "utf-8")
    {
        var sb = new StringBuilder(32);
        MD5 md5 = new MD5CryptoServiceProvider();
        var bytes = md5.ComputeHash(Encoding.GetEncoding(charset).GetBytes(text));
        foreach (var t1 in bytes)
        {
            sb.Append(t1.ToString("x").PadLeft(2, '0'));
        }

        return sb.ToString();
    }
    /// <summary>
    /// 分隔 移除空项
    /// </summary>
    /// <param name="text"></param>
    /// <param name="separator"></param>
    /// <returns></returns>
    public static string[] SplitRemoveEmpty(this string text, params string[] separator)
    {
        if (string.IsNullOrEmpty(text))
            return Array.Empty<string>();
        return text.Split(separator, StringSplitOptions.RemoveEmptyEntries);
    }

    /// <summary>
    /// 转换long32数组
    /// </summary>
    /// <param name="array"></param> 
    /// <returns></returns>
    public static int[] Tolong32Arrary(this string[] array)
    {
        return Array.ConvertAll(array, t => Convert.ToInt32(t));
    }

    /// <summary>
    /// 不区分大小写比较
    /// </summary>
    /// <param name="text"></param>
    /// <param name="compare"></param>
    /// <returns></returns>
    public static bool EqualsIgnoreCase(this string text, string compare)
    {
        return text.Equals(compare, StringComparison.InvariantCultureIgnoreCase);
    }

    /// <summary>
    /// 不区分大小写替换
    /// </summary>
    /// <param name="text"></param>
    /// <param name="compare"></param>
    /// <returns></returns>
    public static string ReplaceIgnoreCase(this string text, string oldValue, string newValue)
    {
        return text.Replace(oldValue, newValue, StringComparison.OrdinalIgnoreCase);
    }
}