﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Serialization;
using System;
using System.Globalization;

namespace QueryPlatform.Infra
{
    public class IsoDateTimeConverterContent : IsoDateTimeConverter
    {
        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            if (value is DateTime)
            {
                DateTime dateTime = (DateTime)value;
                if (dateTime == default(DateTime)
                    || dateTime == DateTime.MinValue
                    || dateTime.ToString("yyyy-MM-dd") == "1970-01-01"
                    || dateTime.ToString("yyyy-MM-dd") == "1900-01-01")
                {
                    writer.WriteValue("");
                    return;
                }
            }
            base.WriteJson(writer, value, serializer);
        }

        //public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        //{
        //    return base.ReadJson(reader, objectType, existingValue, serializer);
        //}
        public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)
        {
            if (string.IsNullOrWhiteSpace(reader.Value?.ToString())) return null;

            var formats = new string[]
               {
                 "yyyyMMddHHmmss",
                 "yyyyMMddHHmmss",
                 "yyyy-MM-dd HH:mm:ss",
                 "yyyy-MM-dd H:mm:ss",
                 "yyyy年MM月dd日 HH时mm分ss秒" ,
                 "yyyyMdHHmmss",
                 "yyyy年M月d日 H时mm分ss秒",
                 "yyyy.M.d H:mm:ss",
                 "yyyy.MM.dd HH:mm:ss",
                 "yyyy-MM-dd",
                 "yyyyMMdd",
                 "yyyy/MM/dd",
                 "yyyy/M/d",
                 "yyyy-MM",
                 "yyyy/MM",
                 "yyyy/M",
               };

            DateTime.TryParseExact(reader.Value?.ToString(), formats, CultureInfo.InvariantCulture, DateTimeStyles.None, out DateTime now1);

            return now1;

            //return base.ReadJson(reader, objectType, existingValue, serializer);
        }
    }
    public class LowercaseContractResolver : DefaultContractResolver
    {
        protected override string ResolvePropertyName(string propertyName)
        {
            return propertyName.ToLower();
        }
    }
    public class UppercaseContractResolver : DefaultContractResolver
    {
        protected override string ResolvePropertyName(string propertyName)
        {
            return propertyName.ToUpper();
        }
    }
}
