﻿using FluentScheduler;
using Microsoft.Extensions.DependencyInjection;
using System;

namespace Performance.Api
{
    public class JobRegistry : Registry
    {
        public JobRegistry(IServiceProvider provider)
        {
            //Schedule<ExtractDataJob>().ToRunNow().AndEvery(1).Days().At(23, 0);
            //Schedule<ExtractDataJob>().ToRunEvery(1).Days().At(23, 0);
            Schedule(() => provider.GetService<ExtractGenerateJob>()).ToRunEvery(1).Days().At(23, 00);
            //Schedule(() => provider.GetService<ClearLoggerJob>()).ToRunNow().AndEvery(60).Seconds();
            Schedule(() => provider.GetService<ClearLoggerJob>()).ToRunNow().AndEvery(1).Days().At(3, 00);
            Schedule(() => provider.GetService<BackgroundJob>()).ToRunNow().AndEvery(10).Seconds();
            Schedule(() => provider.GetService<AutoSyncConfigJob>()).ToRunEvery(1).Days().At(0, 00);
        }
    }
}
