﻿using System;
using System.IO;
using System.Security.Cryptography;
using System.Text;
using XC.RSAUtil;

namespace Performance.Api
{
    public class LimitInformation
    {
        public DateTime ExpirationTime { get; set; }
        public string Remark { get; internal set; }
    }
    public class FunctionLimit
    {
        public static LimitInformation Limit { get; } = new LimitInformation();
        public static void Init(NLog.Logger logger)
        {
            string message = "此网站的验证证书有问题，验证证书已过期或还未生效，请及时联系供应厂商进行维护升级。";
            var filePath = Path.Combine(Environment.CurrentDirectory, "secret.key");
            logger.Info(filePath);
            if (!File.Exists(filePath))
            {
                Limit.ExpirationTime = DateTime.MinValue;
                Limit.Remark = message;
                return;
            }
            string content = ReadLimitContent(filePath, logger);
            logger.Info(content);
            if (string.IsNullOrEmpty(content))
            {
                Limit.ExpirationTime = DateTime.MinValue;
                Limit.Remark = message;
                return;
            }
            var timestamp = ConvertToExpiration(content);
            if (timestamp == 0)
            {
                Limit.ExpirationTime = DateTime.MinValue;
                Limit.Remark = message;
                return;
            }

            Limit.ExpirationTime = (new DateTime(1970, 1, 1, 8, 0, 0, DateTimeKind.Unspecified)).AddSeconds(timestamp);
            Limit.Remark = Limit.ExpirationTime > DateTime.Now ? "已授权开放使用！" : message;
        }

        private static long ConvertToExpiration(string content)
        {
            long result = 0;
            try
            {
                var bigDataRsa = new RsaPkcs8Util(Encoding.UTF8, "", privateKey, 2048);
                var timestamp = bigDataRsa.DecryptBigData(content, RSAEncryptionPadding.Pkcs1);
                long.TryParse(timestamp, out result);
                return result;
            }
            catch (Exception) { }
            return result;
        }

        private static string ReadLimitContent(string filePath, NLog.Logger logger)
        {
            var content = "";
            try
            {
                using (FileStream stream = new FileStream(filePath, FileMode.Open))
                using (StreamReader reader = new StreamReader(stream))
                {
                    content = reader.ReadToEnd();
                }
            }
            catch (Exception ex) { logger.Error(ex); }
            return content;
        }

        private static string privateKey = @"-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC/XTloNsKshhr/
GC34GSQqKxiojkSWBZ+Xe3SxryqrYjx8yyjdrTgBq8lXOO9xtu+jr3XcFwHhFsq5
iK8qwRZQhinASjOFroeszrn0dbuLMT3ad+pCfdkXKcOwmCifHWLqODn0JXmPnTx5
8F1JD954J1Es8ugyJ6S77T0iPezmHvPgxV0Cn4E7Lg2114LwBgy1Kgb5S/b3pz5P
MQKECPRqK69SRIzUU7Nvw1LrqjK9OF5ZWYdGBlCBpRvbd0RIrgJ3NzAUCrE5t3Y+
KI3UM02FhoGzWM0j8oC/P6GGkNL8bY5JMR2TGWfUiB1UUjT+Y2hCCl0tfZUBWPDu
NVeqB9dxAgMBAAECggEAGOU56LLnFKbFsFYm9NXgfJPqu1L23UWSA5UOE2ekd3Nq
RxnvERfN53m/0dcYX4TbHEJhZOahWfUrHoQHtdo02vj5SYjdtxCDmhmy23jNk0gu
sdNT6J6StY67ZKgG8NxT2ADEmVyeue5MxdhdannkCWGkD+LyDkRWDBTLFT9VKIK4
dV22NdL7uvIYH+dP8fUYm6sM65+fAcPwj5bVPhCI90TjJo93e2/aBtzaMjdrRcfY
r8AaRMuY8m/QDvVhIaurki1JxG+Qwz4gT5eWhI8qUwGsxti92/Mz+B3oT8X+AhP0
tEsRNxu+BrDeb6qM3JpYaR4UbJIFLljVWRFRa67L+QKBgQD1f1eoh6YbMXI9c3Ty
3u5YRawVRG47MtuMDu94PqUKjo57evQEaOvtwPYADR1G1qFDRJbSbTsVhXEH5YaA
SuYdNYBNYJzPkD6Du+gwFqiemolKbMb2bTGtdci4FEZIcHS8u+FaARtAJuUWqtTY
KMqyu95JTcLrHYBnlynWwy+QdwKBgQDHjQVZGIOH2WW6OG7wHHicc7SxjRiBTADk
aIJAM1JJlgTHZ4o9v47DBOPAT7MCcbI8Ln+/kbJgdNMFC3SyPpzNHtvRp48dNXxx
liGtLys8GBaBEDzI0jmXb5nZXLk5DfwZEOQ57T4TbYjuBlwjY/FQl+7HWUKgwEt8
AvPjefb5VwKBgQC+YisQv2HJ5Oa7UTZ4wvoD6sQxGgiCUEaCr3J2xd4n+bX1fLyQ
Tu3oS6R7FbCGpxwYlrCAL8WKQxoNDarpAyzBqiP93da+ARb6AldmM6xAk4e09/a0
VKoZ4yXt24tF0jA1zV5N9l2zunYexgyaNcg8JAWWw39N5msV6ty/eE8CsQKBgQCi
IfI2cbRsrDX7F98LOBbHBzvJBtriMt6GtmMdxpUVNM6tNXMcuIdF7LMfjaHkWnx2
aVFiVP6ZYFITxzsJl9XO00PHFF0zXkG+CD1UeP6n1Opz8r1wbV5drE9UTAIyWSp7
Mz470oadQmH/AyvZlVp8IPXhAqUf9x1dpQiDypTgAQKBgQDLeiwRRG6SxnZDddDK
RNKJaMz1q0GM3KPC4MuM8gPkWBRnrGZ67J3bTpgPYVVFxxyIspDG6miMATfZXnDF
OKst4raozj7kX5ghZRZCI2okvFEipVkBSwPdAB20mx5DENXOtpr2h+V/57AgD8Ua
UGTpnMMY2uONH/H/mMPny8D5LA==
-----END PRIVATE KEY-----";
    }
}
