﻿using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class CostTransferResponse
    {
        public int Id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int AllotId { get; set; }

        /// <summary>
        /// 申请者核算单元类型
        /// </summary>
        public string ApplicantUnitType { get; set; }

        /// <summary>
        /// 申请者科室
        /// </summary>
        public string ApplicantDepartment { get; set; }

        /// <summary>
        /// 审核者核算单元类型
        /// </summary>
        public string AdoptedUnitType { get; set; }

        /// <summary>
        /// 审核者科室
        /// </summary>
        public string AdoptedDepartment { get; set; }

        /// <summary>
        /// 0 未审核 1 部分审核 2 全部审核 
        /// </summary>
        public int Status { get; set; }

        public int AdminStatus { get; set; }

        public decimal AmountSum { get; set; }

        public List<Option> Items { get; set; }
    }


    public class CommonResponse
    {
        public string deparment { get; set; }
        public string unitType { get; set; }
        public List<TitleValue> account { get; set; }

        public List<Common> Data { get; set; }
    }

    public class Common
    {
        public string Source { get; set; }
        public string Category { get; set; }
        public decimal? Ratio { get; set; }
    }

    public class Option : cost_transfer_item
    {
        public string[] options { get; set; }
        public string ApplicantDepartment { get; set; }
        public string AdoptedDepartment { get; set; }
    }

}
