﻿using Performance.DtoModels.Request;
using Performance.EntityModels;
using Performance.Infrastructure.Models;
using System;
using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class GatherResponse
    {
        public List<Heads> Heads { get; set; }
        public List<Dictionary<string, object>> Datas { get; set; }
        public int CurrentPage { get; set; }
        public int TotalPages { get; set; }
        public int PageSize { get; set; }
        public int TotalCount { get; set; }
    }
    public class GatherInfo
    {
        public List<Heads> Heads { get; set; }
        public List<GatherInfoRequest> Datas { get; set; }
        public int CurrentPage { get; set; }
        public int TotalPages { get; set; }
        public int PageSize { get; set; }
        public int TotalCount { get; set; }
    }

    public class GatherDropResponse
    {
        public string Value { get; set; }

        public List<GatherDropResponse> Children { get; set; }
    }

    public class GatherRequest
    {
        public string Source { get; set; }
        public string Category { get; set; }
    }

    public class GatherTotalRequest
    {
        public string Department { get; set; }
        public string Source { get; set; }
        public string Category { get; set; }
        public string CreateTime { get; set; }
        public string AuditTime { get; set; }
        public string States { get; set; }
        public string Remark { get; set; }
    }
    public class Gather: PersonParamsRequest
    {

        public int AllotId { get; set; }
        /// <summary>
        /// 用户Id
        /// </summary>
        public int UserId { get; set; }
        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }
        /// <summary>
        /// 来源
        /// </summary>
        public string Source { get; set; }
        /// <summary>
        /// 核算项目
        /// </summary>
        public string Category { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public string Status { get; set; }
        /// <summary>
        /// 失败理由
        /// </summary>
        public string Remark { get; set; }
    }
    public class GatherInfoRequest
    {
        public int UserId { get; set; }
        public string Source { get; set; }
        public string CreateTime { get; set; }
        public string Department { get; set; }
        public string DoctorName { get; set; }
        public string PersonnelNumber { get; set; }
        public GatherInfoFee[] Detail { get; set; }

    }
    public class GatherInfoFee
    {
        public string Category { get; set; }

        public decimal? Fee { get; set; }
    }
}
