﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 行政后勤
    /// </summary>
    public class PerSheetDataReadLogisticsEmployee : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                Dictionary<string, object> dic = new Dictionary<string, object>
                {
                    { nameof(PerDataLogisticsEmployee.RowNumber), r}
                };

                foreach (var item in ExcelReadConfig.LogisticsEmployee)
                {
                    if (NopiSevice.TryGetPoint(perHeader, item.Description, out int point))
                    {
                        object @object = row.GetCell(point).GetValue();
                        if (item.IsNumber)
                            @object = ConvertHelper.ToDecimalOrNull(@object);

                        if (dic.Keys.Contains(item.Field))
                            dic[item.Field] = @object;
                        else
                            dic.Add(item.Field, @object);
                    }
                }

                var employee = JsonHelper.Deserialize<PerDataLogisticsEmployee>(dic);

                if (!string.IsNullOrEmpty(employee.AccountingUnit) && !string.IsNullOrEmpty(employee.FitPeople))
                    dataList.Add(employee);
            }

            return dataList;
        }
    }
}
