﻿using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.IdentityModel.Tokens;
using System;
using System.Text;
using System.Threading.Tasks;

namespace Performance.Api.Configurations
{
    public static class AuthenticationConfig
    {
        public static void AddAuthenticationConfiguration(this IServiceCollection services, IConfiguration configuration)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            var signingKey = new SymmetricSecurityKey(Encoding.UTF8.GetBytes(Consts.Secret));

            //services.Configure<JwtOptions>(options =>
            //{
            //    options.Issuer = Consts.Issuer;
            //    options.Audience = Consts.Audience;
            //    options.SigningCredentials = new SigningCredentials(signingKey, SecurityAlgorithms.HmacSha256);
            //});

            services.AddAuthentication(options =>
            {
                options.DefaultAuthenticateScheme = JwtBearerDefaults.AuthenticationScheme;
                options.DefaultChallengeScheme = JwtBearerDefaults.AuthenticationScheme;
            })
            .AddJwtBearer(options =>
            {
                options.TokenValidationParameters = new TokenValidationParameters
                {
                    ValidateIssuer = true,
                    ValidIssuer = Consts.Issuer,
                    ValidateAudience = true,
                    ValidAudience = Consts.Audience,
                    ValidateIssuerSigningKey = true,
                    IssuerSigningKey = signingKey,
                    ValidateLifetime = true,
                    ClockSkew = TimeSpan.Zero,
                };
                options.Events = new JwtBearerEvents()
                {
                    OnMessageReceived = context =>
                    {
                        var accessToken = context.Request.Query["access_token"];
                        var path = context.HttpContext.Request.Path;
                        if (!string.IsNullOrEmpty(accessToken) && (path.StartsWithSegments("/performance/allotLogHub")))
                        {
                            context.Token = accessToken;
                        }
                        return Task.CompletedTask;
                    }
                };
            });
        }
    }

    //public class JwtOptions
    //{
    //    /// <summary>
    //    /// Issuer jwt签发者
    //    /// </summary>
    //    public string Issuer { get; set; }

    //    /// <summary>
    //    /// Subject jwt所面向的用户
    //    /// </summary>
    //    public string Subject { get; set; }

    //    /// <summary>
    //    /// Audience 接收jwt的一方
    //    /// </summary>
    //    public string Audience { get; set; }

    //    /// <summary>
    //    /// Not Before 定义在什么时间之前,该jwt是不可以用的
    //    /// </summary>
    //    public DateTime NotBefore => DateTime.Now;

    //    /// <summary>
    //    /// Expiration Time jwt的过期时间,必须大于签发时间
    //    /// </summary>
    //    public DateTime Expiration => IssuedAt.Add(ValidFor);

    //    /// <summary>
    //    /// Issued At jwt的签发时间
    //    /// </summary>
    //    public DateTime IssuedAt => DateTime.Now;

    //    /// <summary>
    //    /// Set the timespan the token will be valid for (default is 10 min)
    //    /// </summary>
    //    public TimeSpan ValidFor { get; set; } = TimeSpan.FromMinutes(120);


    //    /// <summary>
    //    /// The signing key to use when generating tokens.
    //    /// </summary>
    //    public SigningCredentials SigningCredentials { get; set; }
    //}

}
