﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class SecondAuditRequest
    {
        /// <summary> 二次绩效Id </summary>
        public int SecondId { get; set; }

        /// <summary> 审核结果 1、审核通过 2、驳回 </summary>
        public int IsPass { get; set; }

        /// <summary> 备注 </summary>
        public string Remark { get; set; }
    }
    public class SecondAuditRequestValidator : AbstractValidator<SecondAuditRequest>
    {
        public SecondAuditRequestValidator()
        {
            RuleFor(x => x.SecondId).NotNull().NotEmpty().GreaterThan(0);
            RuleFor(x => x.IsPass).NotNull().NotEmpty().InclusiveBetween(1, 2);
            RuleFor(x => x.Remark).NotNull().NotEmpty();
        }
    }
}
