﻿using Performance.DtoModels.Request;
using Performance.EntityModels;
using Performance.Infrastructure.Models;
using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class GatherResponse
    {
        public List<Heads> Heads { get; set; }
        public List<GatherTotalRequest> Datas { get; set; }
        public int CurrentPage { get; set; }
        public int TotalPages { get; set; }
        public int PageSize { get; set; }
        public int TotalCount { get; set; }
    }
    public class GatherInfo
    {
        public List<Heads> Heads { get; set; }
        public List<GatherInfoRequest> Datas { get; set; }
        public int CurrentPage { get; set; }
        public int TotalPages { get; set; }
        public int PageSize { get; set; }
        public int TotalCount { get; set; }
    }

    public class GatherDropResponse
    {
        public string Label { get; set; }

        public string Value { get; set; }

        public List<GatherDropResponse> Children { get; set; }
    }

    public class GatherRequest
    {
        public string Source { get; set; }
        public string Category { get; set; }
    }

    public class GatherTotalRequest
    {
        public int ID { get; set; }
        public string Department { get; set; }
        public string Source { get; set; }
        public decimal Fee { get; set; }
    }
    public class GatherInfoRequest
    {
        public string Source { get; set; }
        public string Department { get; set; }
        public string DoctorName { get; set; }
        public string PersonnelNumber { get; set; }
        public List<GatherInfoFee> Detail { get; set; }

    }
    public class GatherInfoFee
    {
        public string Category { get; set; }

        public decimal? Fee { get; set; }
    }
}
