﻿using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Performance.Services
{
    public static class NopiSevice
    {
        //public static string GetCellStringValue(ICell cell)
        //{
        //    if (cell != null)
        //    {
        //        try
        //        {
        //            switch (cell.CellType)
        //            {
        //                case CellType.Numeric:
        //                    return cell.NumericCellValue.ToString().Replace("0", "");
        //                case CellType.String:
        //                    return cell.StringCellValue.ToString().Replace("0", "");
        //                case CellType.Formula:
        //                    cell.SetCellType(CellType.String);
        //                    return cell.StringCellValue.ToString().Replace("0", "");
        //            }
        //        }
        //        catch (Exception ex)
        //        {
        //            //throw ex;
        //        }
        //    }
        //    return null;
        //}
        //public static decimal? GetCellValue(ICell cell)
        //{
        //    if (cell != null)
        //    {
        //        try
        //        {
        //            switch (cell.CellType)
        //            {
        //                case CellType.Numeric:
        //                    return ConvertHelper.ToDecimalOrNull(cell.NumericCellValue);
        //                case CellType.String:
        //                    return ConvertHelper.ToDecimalOrNull(cell.StringCellValue);
        //                case CellType.Formula:
        //                    return ConvertHelper.ToDecimalOrNull(cell.NumericCellValue);
        //            }
        //        }
        //        catch (Exception ex)
        //        {
        //            //throw ex;
        //        }
        //    }
        //    return null;
        //}

        public static string GetValue(this ICell cell)
        {
            if (cell != null)
            {
                try
                {
                    switch (cell.CellType)
                    {
                        case CellType.Numeric:
                            return cell?.NumericCellValue.ToString();
                        case CellType.String:
                            return cell?.StringCellValue?.ToString() ?? "";
                        case CellType.Formula:
                            cell?.SetCellType(CellType.String);
                            return cell?.StringCellValue?.ToString();
                        case CellType.Boolean:
                            return cell?.BooleanCellValue.ToString();
                        case CellType.Unknown:
                        case CellType.Blank:
                        case CellType.Error:
                            return string.Empty;
                    }
                }
                catch (Exception)
                {
                    //throw ex;
                }
            }
            return null;
        }

        public static bool TryGetPoint(List<PerHeader> headers, string title, out int point)
        {
            var x = headers.FirstOrDefault(p => p.CellValue == title)?.PointCell;
            point = x.HasValue ? x.Value : 0;
            return x.HasValue;
        }

        //public static DateTime? GetCellDatetimeValue(ICell cell)
        //{
        //    if (cell != null)
        //    {
        //        if (cell.CellType == CellType.Numeric)
        //        {
        //            if (HSSFDateUtil.IsCellDateFormatted(cell))
        //            {
        //                return cell.DateCellValue;
        //            }
        //        }
        //        else if (cell.CellType == CellType.String)
        //        {
        //            var reg = @"(19|20)\d{2}(-|/)[01]?\d(-|/)[0123]?\d( [012]?\d\:\d{2}\:\d{2})?";
        //            if (!string.IsNullOrEmpty(cell.StringCellValue) && Regex.Match(cell.StringCellValue.Trim(), reg).ToString() == cell.StringCellValue.Trim())
        //                return ConvertHelper.To<DateTime>(cell.StringCellValue);
        //        }
        //    }
        //    return null;
        //}
    }
}
