﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 无执行科室医院收入
    /// </summary>
    public class PerSheetDataReadBillIncome : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 5,
            HeaderLastRowNum = 5,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 6,
            AccountingUnit = new List<AccountingUnit>
            {
                //核算单元（医技组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = -1,
                    UnitType = "医技组",
                    DeptCellNum = 2,
                    FactorRow = 3,
                },
                //核算单元（医生组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 0,
                    UnitType = "医生组",
                    DeptCellNum = 2,
                    FactorRow = 2,
                },
                //核算单元（护理组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 1,
                    UnitType = "护理组",
                    DeptCellNum = 2,
                    FactorRow = 1,
                }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            //循环 当前有几个核算单元
            foreach (var unit in Point.AccountingUnit)
            {
                if (unit.UnitType == "医技组") continue;

                //查询除了 核算单元  科室名称 有效数据列头位置
                var vhead = perHeader.Where(t => !Point.AccountingUnit.Select(p => p.AccountingUnitCellNum).Contains(t.PointCell)
                    && !Point.AccountingUnit.Select(p => p.DeptCellNum).Contains(t.PointCell)).OrderBy(t => t.PointCell);

                for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
                {
                    var row = sheet.GetRow(r);
                    if (row == null) continue;
                    for (int c = 0; c < vhead.Count(); c++)
                    {
                        var athead = vhead.ElementAt(c);
                        //var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                        var cellValue = ConvertHelper.ToDecimalOrNull(row.GetCell(athead.PointCell).GetValue());
                        if (!cellValue.HasValue || cellValue.Value == 0)
                            continue;
                        PerData data = new PerData
                        {
                            RowNumber = r,
                            SignID = athead.SignID,
                            AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value).GetValue(),
                            Department = row.GetCell(unit.DeptCellNum.Value).GetValue(),
                            TypeName = athead?.CellValue,
                            CellValue = cellValue,
                            //Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                            UnitType = unit.UnitType, //手动匹配
                            FactorValue = ConvertHelper.ToDecimalOrNull(sheet.GetRow(unit.FactorRow.Value).GetCell(athead.PointCell).GetValue()),
                            IsFactor = true,
                        };
                        dataList.Add(data);
                    }
                }
            }
            var tunit = Point.AccountingUnit[0];
            var rownum = sheet.LastRowNum + 1;
            var technicianRow = sheet.GetRow(4);
            if (technicianRow != null)
            {
                //查询除了 核算单元  科室名称 有效数据列头位置
                var vhead = perHeader.Where(t => !Point.AccountingUnit.Select(p => p.AccountingUnitCellNum).Contains(t.PointCell)
                    && !Point.AccountingUnit.Select(p => p.DeptCellNum).Contains(t.PointCell)).OrderBy(t => t.PointCell);
                for (int c = 0; c < vhead.Count(); c++)
                {
                    var athead = vhead.ElementAt(c);
                    var cellValue = technicianRow.GetCell(athead.PointCell).StringCellValue;
                    if (string.IsNullOrEmpty(cellValue))
                        continue;
                    PerData data = new PerData
                    {
                        RowNumber = rownum,
                        SignID = athead.SignID,
                        AccountingUnit = cellValue,
                        Department = cellValue,
                        TypeName = athead?.CellValue,
                        CellValue = (dataList.Select(t => (PerData)t)?.Where(t => t.TypeName == athead.CellValue).Sum(t => t.CellValue) ?? 0) / 2,
                        //Annotation = technicianRow.GetCell(athead.PointCell)?.CellComment?.String?.String,
                        UnitType = tunit.UnitType, //手动匹配
                        FactorValue = ConvertHelper.ToDecimalOrNull(sheet.GetRow(tunit.FactorRow.Value).GetCell(athead.PointCell)?.ToString()),
                        IsFactor = true,
                    };
                    dataList.Add(data);
                }
            }
            return dataList;
        }
    }
}
