﻿using MySql.Data.MySqlClient;
using Oracle.ManagedDataAccess.Client;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Performance.Subsidy.Services.Repository
{
    public class ConnectionFactory
    {
        private readonly string _connectionString;

        public ConnectionFactory(string connectionString)
        {
            _connectionString = connectionString;
        }
        public IDbConnection CreateDefault()
        {
            return new MySqlConnection(_connectionString);
        }

        public IDbConnection Create(int type, string connectionString)
        {
            try
            {
                switch (type)
                {
                    case (int)DatabaseType.MySQL:
                        return new MySqlConnection(connectionString);
                    case (int)DatabaseType.SqlServer:
                        return new SqlConnection(connectionString);
                    case (int)DatabaseType.Oracle:
                        return new OracleConnection(connectionString);
                    default:
                        throw new ArgumentException("DatabaseType类型不支持");
                }
            }
            catch (Exception ex)
            {
                throw;
            }
        }

    }
}
