﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ModModuleRequest
    {
        /// <summary> 绩效模块Id </summary>
        public Nullable<int> ModuleId { get; set; }

        /// <summary> 医院Id </summary>
        public Nullable<int> HospitalId { get; set; }

        public Nullable<int> TypeId { get; set; }

        /// <summary>
        /// 数据库地址
        /// </summary>
        public Nullable<int> ConfigId { get; set; }

        /// <summary> 类型 </summary>
        public Nullable<int> SheetType { get; set; }

        /// <summary> 绩效模块 </summary>
        public string ModuleName { get; set; }

        /// <summary> 描述 </summary>
        public string Description { get; set; }

        /// <summary>
        /// 当前脚本类型 1 收入整表  2 单项数据提取
        /// </summary>
        public List<int> ExecuteType { get; set; }


        public int PageNum { get; set; }

        public int PageSize { get; set; }
    }

    public class ModModuleRequestValidator : AbstractValidator<ModModuleRequest>
    {
        public ModModuleRequestValidator()
        {
            RuleSet("Query", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().NotEmpty().GreaterThan(0);
            });

            RuleSet("Add", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.ModuleName).NotNull().NotEmpty();
                RuleFor(x => x.SheetType).NotNull().NotEmpty();
            });

            RuleSet("Edit", () =>
            {
                RuleFor(x => x.ModuleId).NotNull().NotEmpty().GreaterThan(0);
            });
        }
    }
}
