﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// 二次分配请求
    /// </summary>
    public class AgainAllotRequest
    {
        /// <summary>
        /// 二次分配ID
        /// </summary>
        public int AgainAllotID { get; set; }
    }

    public class AgainAllotRequestValidator : AbstractValidator<AgainAllotRequest>
    {
        public AgainAllotRequestValidator()
        {
            RuleSet("Generate", () =>
            {
                RuleFor(x => x.AgainAllotID).NotNull().GreaterThan(0);
            });
        }
    }
}
