//-----------------------------------------------------------------------
// <copyright file=" per_apr_amount.cs">
// * FileName: per_apr_amount.cs
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// per_apr_amount Repository
    /// </summary>
    public partial class PerforPerapramountRepository : PerforRepository<per_apr_amount>
    { 
        public List<view_per_apr_amount> GetFullAmount(Func<per_apr_amount, bool> predicate)
        {
            var employees = this.context.Set<per_employee>().AsEnumerable();
            var amounts = this.context.Set<per_apr_amount>().Where(predicate);

            var res = amounts.Join(employees,
               outer => new { outer.AllotId, outer.PersonnelNumber },
               inner => new { AllotId = inner.AllotId ?? 0, inner.PersonnelNumber },
               (outer, inner) => new view_per_apr_amount
               {
                   Id = outer.Id,
                   AllotId = outer.AllotId,
                   PersonnelNumber = outer.PersonnelNumber,
                   DoctorName = outer.DoctorName,
                   PerforType = outer.PerforType,
                   Amount = outer.Amount,
                   AccountingUnit = inner.AccountingUnit,
                   UnitType = inner.UnitType,
                   TypeInDepartment = outer.TypeInDepartment,
                   Status = outer.Status,
                   AuditTime = outer.AuditTime,
                   AuditUser = outer.AuditUser,
                   CreateDate = outer.CreateDate,
                   CreateUser = outer.CreateUser,
                   Remark = outer.Remark,
                   IsVerify = outer.IsVerify,
                   VerifyMessage = outer.VerifyMessage,
               });
            return res.ToList() ?? new List<view_per_apr_amount>();
        }
    }
}
