//-----------------------------------------------------------------------
// <copyright file=" im_specialunit.cs">
// * FileName: 特殊科室核算.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 特殊科室核算
    /// </summary>
    [Table("im_specialunit")]
	public class im_specialunit
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> SheetID { get; set; }
    
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    
        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }
    
        /// <summary>
        /// 人数
        /// </summary>
        public Nullable<decimal> Number { get; set; }
    
        /// <summary>
        /// 量化指标
        /// </summary>
        public string QuantitativeIndicators { get; set; }
    
        /// <summary>
        /// 数量
        /// </summary>
        public Nullable<decimal> Quantity { get; set; }
    
        /// <summary>
        /// 量化指标绩效分值
        /// </summary>
        public Nullable<decimal> QuantitativeIndicatorsValue { get; set; }
    
        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoringAverage { get; set; }
    
        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }
    
        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }
    }
}
