//-----------------------------------------------------------------------
// <copyright file=" res_compute.cs">
// * FileName: .cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 
    /// </summary>
    [Table("res_compute")]
	public class res_compute
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }
    
        /// <summary>
        /// sheet页id
        /// </summary>
        public Nullable<int> SheetID { get; set; }
    
        /// <summary>
        /// 核算单元类型（医技科室、临床科室等）
        /// </summary>
        public string AccountType { get; set; }
    
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    
        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }
    
        /// <summary>
        /// 人员姓名
        /// </summary>
        public string EmployeeName { get; set; }
    
        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }
    
        /// <summary>
        /// 工号
        /// </summary>
        public string JobNumber { get; set; }
    
        /// <summary>
        /// 绩效合计(来自科室经济测算表)
        /// </summary>
        public Nullable<decimal> PerforTotal { get; set; }
    
        /// <summary>
        /// 核算单元医生数量(来自科室经济测算表)
        /// </summary>
        public Nullable<decimal> Number { get; set; }
    
        /// <summary>
        /// 人均绩效(来自科室经济测算表)
        /// </summary>
        public Nullable<decimal> Avg { get; set; }
    
        /// <summary>
        /// 效率绩效(需计算)
        /// </summary>
        public Nullable<decimal> Efficiency { get; set; }
    
        /// <summary>
        /// 规模绩效(需计算)
        /// </summary>
        public Nullable<decimal> Scale { get; set; }
    
        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }
    
        /// <summary>
        /// 发放系数(来自人员名单)
        /// </summary>
        public Nullable<decimal> Grant { get; set; }
    
        /// <summary>
        /// 应发管理绩效(需计算，科主任护士长独有)
        /// </summary>
        public Nullable<decimal> ShouldGiveFee { get; set; }
    
        /// <summary>
        /// 绩效合计(需计算)
        /// </summary>
        public Nullable<decimal> PerforSumFee { get; set; }
    
        /// <summary>
        /// 考核对分率(来自人员名单)
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }
    
        /// <summary>
        /// 医院奖罚(来自人员名单)
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }
    
        /// <summary>
        /// 其他绩效(来自人员名单)
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }
    
        /// <summary>
        /// 应发绩效(需计算)
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }
    
        /// <summary>
        /// 出勤率(来自人员名单)
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }
    
        /// <summary>
        /// 参加工作时间(来自人员名单)
        /// </summary>
        public Nullable<DateTime> WorkTime { get; set; }
    
        /// <summary>
        /// 绩效基础金额(计算)
        /// </summary>
        public Nullable<decimal> BaiscNormValue { get; set; }
    
        /// <summary>
        /// 年资系数(来自人员名单)
        /// </summary>
        public Nullable<decimal> WorkYear { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }
    
        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> Workload { get; set; }
    
        /// <summary>
        /// 实发绩效
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }
    
        /// <summary>
        /// 变更日志
        /// </summary>
        public string ChangeLog { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public string Remark { get; set; }
    }
}
