﻿using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services.AllotCompute
{

    /// <summary>
    /// 绩效标准数据
    /// </summary>
    public class BaiscNormService : IAutoInjection
    {
        /// <summary>
        /// 绩效标准计算 主任 副主任 护士长
        /// </summary>
        /// <param name="computes"></param>
        /// <returns></returns>
        public List<res_baiscnorm> ComputeAvg(List<res_baiscnorm> baiscnormList, List<im_accountbasic> accountbasicList, List<ComputeResult> computes)
        {
            var keyList = new[]
            {
                //绩效基数平均值项目
                new { Reference = PerforType.临床主任 , UnitType = UnitType.医生组},
                new { Reference = PerforType.护士长, UnitType = UnitType.护理组  },
                new { Reference = PerforType.医技主任, UnitType = UnitType.医技组  },
            };
            foreach (var item in keyList)
            {
                var count = accountbasicList.Where(t => t.UnitType == (int)item.UnitType).Sum(t => t.DoctorDirectorNumber);
                var dataList = computes.Where(t => t.UnitType == item.UnitType.ToString());
                var baiscnorm = new res_baiscnorm
                {
                    PositionName = EnumHelper.GetDescription(item.Reference),
                    TotelNumber = count,
                    TotelValue = dataList?.Sum(t => t.BaiscNormPerforTotal),
                    AvgValue = dataList?.Sum(t => t.BaiscNormPerforTotal) / count
                };
                baiscnormList.Add(baiscnorm);
            }
            return baiscnormList;
        }

        /// <summary>
        /// 院领导、行政中层、行政工勤 平均值
        /// </summary>
        /// <param name="computes"></param>
        /// <returns></returns>
        public List<res_baiscnorm> ComputeOtherAvg(List<res_baiscnorm> baiscnormList, List<ComputeResult> computes, List<im_employee> empolyeeList)
        {
            var keyList = new[]
            {
                //行政绩效平均值项目
                new { type = AccountUnitType.行政中层, reference = PerforType.行政中层 },
                new { type = AccountUnitType.行政工勤, reference = PerforType.行政工勤 },
                new { type = AccountUnitType.行政高层, reference = PerforType.行政高层 },
            };

            foreach (var item in keyList)
            {
                var count = empolyeeList.Count(t => t.AccountType == item.type.ToString());
                if (count > 0)
                {
                    var dataList = computes.Where(t => t.AccountType == item.type.ToString());
                    var baiscnorm = new res_baiscnorm
                    {
                        PositionName = EnumHelper.GetDescription(item.reference),
                        TotelNumber = count,
                        TotelValue = dataList.Sum(t => t.GiveFee),
                        AvgValue = dataList.Sum(t => t.GiveFee) / count
                    };
                    baiscnormList.Add(baiscnorm);
                }
            }
            return baiscnormList;
        }

        /// <summary>
        /// 获取绩效标准基础值
        /// </summary>
        /// <param name="baiscnorms"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public decimal? GetBaiscNorm(List<res_baiscnorm> baiscnorms, PerforType type)
        {
            decimal? result = null;
            if (type == PerforType.临床主任护士长平均)
            {
                var lczrValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.临床主任));
                var hszValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.护士长));
                var total = ((lczrValue?.TotelNumber ?? 0) + (hszValue?.TotelNumber ?? 0));
                result = total == 0 ? 0 : ((lczrValue?.TotelValue ?? 0) + (hszValue?.TotelValue ?? 0)) / total;
            }
            else if (type == PerforType.临床主任医技主任护士长平均)
            {
                var lczrValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.临床主任));
                var yjzrValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.医技主任));
                var hszValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.护士长));
                var total = ((lczrValue?.TotelNumber ?? 0) + (yjzrValue?.TotelNumber ?? 0) + (hszValue?.TotelNumber ?? 0));
                result = total == 0 ? 0 : ((lczrValue?.TotelValue ?? 0) + (yjzrValue?.TotelValue ?? 0) + (hszValue?.TotelValue ?? 0)) / total;
            }
            else
            {
                result = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(type))?.AvgValue;
            }

            if (result.HasValue)
                result = Math.Round(result.Value, 4);
            return result;
        }

        /// <summary>
        /// 获取临床医生护士平均绩效
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public List<res_baiscnorm> DocterNurseBaiscnorm(List<res_baiscnorm> baiscnormList, List<im_accountbasic> accountbasicList, List<PerSheet> list)
        {
            var pairs = new[]
            {
                new { SheetType = SheetType.ComputeDoctorAccount, UnitType = UnitType.医生组, PerforType = PerforType.临床医生 },
                new { SheetType = SheetType.ComputeDoctorAccount, UnitType = UnitType.医技组, PerforType = PerforType.医技医生 },
                new { SheetType = SheetType.ComputeNurseAccount, UnitType = UnitType.护理组, PerforType = PerforType.护士 },
            };
            foreach (var info in pairs)
            {
                var sheet = list.FirstOrDefault(t => t.SheetType == info.SheetType);
                var perData = sheet.PerData.Select(t => (PerDataAccountBaisc)t);
                //剔除不同科室相同核算单元
                var groupData = perData.Where(t => t.UnitType == info.UnitType.ToString())
                    .GroupBy(t => t.AccountingUnit)
                    .Select(t => new { AccountingUnit = t.Key, Number = t.Sum(p => p.ManagerNumber + p.Number), PerforTotal = t.Sum(p => p.PerforTotal) });

                var baiscnorm = new res_baiscnorm
                {
                    PositionName = EnumHelper.GetDescription(info.PerforType),
                    TotelNumber = groupData.Sum(t => t.Number),
                    TotelValue = groupData.Sum(t => t.PerforTotal),
                    AvgValue = groupData.Sum(t => t.PerforTotal) / groupData.Sum(t => t.Number)
                };
                baiscnormList.Add(baiscnorm);
            }
            return baiscnormList;
        }
    }
}
