﻿using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Performance.Services
{
    public class NopiSevice
    {
        public static string GetCellStringValue(ICell cell)
        {
            if (cell != null)
            {
                try
                {
                    switch (cell.CellType)
                    {
                        case CellType.Numeric:
                            return cell.NumericCellValue.ToString();
                        case CellType.String:
                            return cell.StringCellValue.ToString();
                        case CellType.Formula:
                            return cell.NumericCellValue.ToString();
                    }
                }
                catch (Exception ex)
                {
                    //throw ex;
                }
            }
            return null;
        }
        public static decimal? GetCellValue(ICell cell)
        {
            if (cell != null)
            {
                try
                {
                    switch (cell.CellType)
                    {
                        case CellType.Numeric:
                            return ConvertHelper.To<decimal?>(cell.NumericCellValue);
                        case CellType.String:
                            return ConvertHelper.To<decimal?>(cell.StringCellValue);
                        case CellType.Formula:
                            return ConvertHelper.To<decimal?>(cell.NumericCellValue);
                    }
                }
                catch (Exception ex)
                {
                    //throw ex;
                }
            }
            return null;
        }

        public static DateTime? GetCellDatetimeValue(ICell cell)
        {
            if (cell != null)
            {
                if (cell.CellType == CellType.Numeric)
                {
                    if (HSSFDateUtil.IsCellDateFormatted(cell))
                    {
                        return cell.DateCellValue;
                    }
                }
                else if (cell.CellType == CellType.String)
                {
                    var reg = @"(19|20)\d{2}(-|/)[01]?\d(-|/)[0123]?\d( [012]?\d\:\d{2}\:\d{2})?";
                    if (!string.IsNullOrEmpty(cell.StringCellValue) && Regex.Match(cell.StringCellValue.Trim(), reg).ToString() == cell.StringCellValue.Trim())
                        return ConvertHelper.To<DateTime>(cell.StringCellValue);
                }
            }
            return null;
        }
    }
}
