﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class HospitalController : Controller
    {
        private HospitalService _hospitalService;
        private ClaimService _claim;
        public HospitalController(HospitalService hospitalService, ClaimService claimService)
        {
            _hospitalService = hospitalService;
            _claim = claimService;
        }

        [Route("hospitallist")]
        [HttpPost]
        public ApiResponse<List<HospitalResponse>> GetHospitalList([FromBody]ApiRequest request)
        {
            var hospitalList = _hospitalService.GetUserHopital(_claim.At(request.Token).UserID);
            return new ApiResponse<List<HospitalResponse>>(ResponseType.OK, "ok", hospitalList);
        }

        [Route("insert")]
        [HttpPost]
        public ApiResponse<HospitalResponse> Insert([CustomizeValidator(RuleSet = "Insert"), FromBody]HospitalRequest request)
        {
            var userid = _claim.At(request.Token).UserID;
            var hospital = _hospitalService.Insert(request, userid);
            _hospitalService.InsertUserHospital(userid, hospital.HosID);
            return new ApiResponse<HospitalResponse>(ResponseType.OK, hospital);
        }

        [Route("update")]
        [HttpPost]
        public ApiResponse<HospitalResponse> Update([CustomizeValidator(RuleSet = "Update"), FromBody]HospitalRequest request)
        {
            var hospital = _hospitalService.Update(request);
            return new ApiResponse<HospitalResponse>(ResponseType.OK, hospital);
        }

        [Route("delete")]
        [HttpPost]
        public ApiResponse Delete([CustomizeValidator(RuleSet = "Delete"), FromBody]HospitalRequest request)
        {
            if (!_hospitalService.Delete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
    }
}
