﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using Microsoft.Extensions.Options;
using Newtonsoft.Json.Linq;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.Infrastructure;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class SheetController : Controller
    {
        private SheetSevice _sheetSevice;
        private ClaimService _claim;
        public SheetController(SheetSevice sheetSevice,
            ClaimService claim)
        {
            _sheetSevice = sheetSevice;
            _claim = claim;
        }

        /// <summary>
        /// sheet 列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("sheetlist")]
        [HttpPost]
        public ApiResponse SheetList([FromBody]SheetRequest request)
        {
            var sheetList = _sheetSevice.SheetList(request.AllotID);
            return new ApiResponse(ResponseType.OK, sheetList);
        }

        /// <summary>
        /// sheet 数据详情
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("sheetexport")]
        [HttpPost]
        public ApiResponse SheetExport([FromBody]SheetExportRequest request)
        {
            var exportData = _sheetSevice.SheetExport(request.SheetID);
            return new ApiResponse(ResponseType.OK, exportData);
        }

    }
}
